/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.Map;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.CommitsApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.DeployKeysApi;
import org.gitlab4j.api.EventsApi;
import org.gitlab4j.api.GitLabApiClient;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.GroupApi;
import org.gitlab4j.api.IssuesApi;
import org.gitlab4j.api.JobApi;
import org.gitlab4j.api.LabelsApi;
import org.gitlab4j.api.MergeRequestApi;
import org.gitlab4j.api.MilestonesApi;
import org.gitlab4j.api.NamespaceApi;
import org.gitlab4j.api.NotesApi;
import org.gitlab4j.api.PipelineApi;
import org.gitlab4j.api.ProjectApi;
import org.gitlab4j.api.RepositoryApi;
import org.gitlab4j.api.RepositoryFileApi;
import org.gitlab4j.api.ServicesApi;
import org.gitlab4j.api.SessionApi;
import org.gitlab4j.api.UserApi;
import org.gitlab4j.api.models.OauthTokenResponse;
import org.gitlab4j.api.models.Session;
import org.gitlab4j.api.models.User;
import org.gitlab4j.api.models.Version;

public class GitLabApi {
    public static final int DEFAULT_PER_PAGE = 100;
    GitLabApiClient apiClient;
    private ApiVersion apiVersion;
    private String gitLabServerUrl;
    private Map<String, Object> clientConfigProperties;
    private int defaultPerPage = 100;
    private Session session;
    private CommitsApi commitsApi;
    private DeployKeysApi deployKeysApi;
    private GroupApi groupApi;
    private IssuesApi issuesApi;
    private MergeRequestApi mergeRequestApi;
    private MilestonesApi milestonesApi;
    private NamespaceApi namespaceApi;
    private PipelineApi pipelineApi;
    private ProjectApi projectApi;
    private RepositoryApi repositoryApi;
    private RepositoryFileApi repositoryFileApi;
    private ServicesApi servicesApi;
    private SessionApi sessionApi;
    private UserApi userApi;
    private JobApi jobApi;
    private LabelsApi labelsApi;
    private NotesApi notesApi;
    private EventsApi eventsApi;

    public final GitLabApi duplicate() {
        Integer sudoUserId = this.getSudoAsId();
        GitLabApi gitLabApi = new GitLabApi(this.apiVersion, this.gitLabServerUrl, this.getTokenType(), this.getAuthToken(), this.getSecretToken(), this.clientConfigProperties);
        if (sudoUserId != null) {
            gitLabApi.apiClient.setSudoAsId(sudoUserId);
        }
        if (this.getIgnoreCertificateErrors()) {
            gitLabApi.setIgnoreCertificateErrors(true);
        }
        gitLabApi.defaultPerPage = this.defaultPerPage;
        return gitLabApi;
    }

    public static GitLabApi oauth2Login(String url, String username, String password) throws GitLabApiException {
        return GitLabApi.oauth2Login(ApiVersion.V4, url, username, password, null, null, false);
    }

    public static GitLabApi oauth2Login(String url, String username, String password, boolean ignoreCertificateErrors) throws GitLabApiException {
        return GitLabApi.oauth2Login(ApiVersion.V4, url, username, password, null, null, ignoreCertificateErrors);
    }

    public static GitLabApi oauth2Login(String url, String username, String password, String secretToken, Map<String, Object> clientConfigProperties, boolean ignoreCertificateErrors) throws GitLabApiException {
        return GitLabApi.oauth2Login(ApiVersion.V4, url, username, password, secretToken, clientConfigProperties, ignoreCertificateErrors);
    }

    public static GitLabApi oauth2Login(ApiVersion apiVersion, String url, String username, String password, String secretToken, Map<String, Object> clientConfigProperties, boolean ignoreCertificateErrors) throws GitLabApiException {
        if (username == null || username.trim().length() == 0) {
            throw new IllegalArgumentException("both username and email cannot be empty or null");
        }
        GitLabApi gitLabApi = new GitLabApi(ApiVersion.OAUTH2_CLIENT, url, (String)null);
        if (ignoreCertificateErrors) {
            gitLabApi.setIgnoreCertificateErrors(true);
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("grant_type", "password", true).withParam("username", username, true).withParam("password", password, true);
        class Oauth2Api
        extends AbstractApi {
            Oauth2Api(GitLabApi gitlabApi) {
                super(gitlabApi);
            }
        }
        Response response = new Oauth2Api(gitLabApi).post(Response.Status.OK, (Form)formData, "oauth", "token");
        OauthTokenResponse oauthToken = (OauthTokenResponse)response.readEntity(OauthTokenResponse.class);
        gitLabApi = new GitLabApi(apiVersion, url, Constants.TokenType.ACCESS, oauthToken.getAccessToken(), secretToken, clientConfigProperties);
        if (ignoreCertificateErrors) {
            gitLabApi.setIgnoreCertificateErrors(true);
        }
        return gitLabApi;
    }

    public static GitLabApi login(ApiVersion apiVersion, String url, String username, String password) throws GitLabApiException {
        return GitLabApi.login(apiVersion, url, username, password, false);
    }

    public static GitLabApi login(String url, String username, String password) throws GitLabApiException {
        return GitLabApi.login(ApiVersion.V4, url, username, password, false);
    }

    public static GitLabApi login(ApiVersion apiVersion, String url, String username, String password, boolean ignoreCertificateErrors) throws GitLabApiException {
        GitLabApi gitLabApi = new GitLabApi(apiVersion, url, (String)null);
        if (ignoreCertificateErrors) {
            gitLabApi.setIgnoreCertificateErrors(true);
        }
        try {
            SessionApi sessionApi = gitLabApi.getSessionApi();
            Session session = sessionApi.login(username, null, password);
            gitLabApi = new GitLabApi(apiVersion, url, session);
            if (ignoreCertificateErrors) {
                gitLabApi.setIgnoreCertificateErrors(true);
            }
        }
        catch (GitLabApiException gle) {
            if (gle.getHttpStatus() != Response.Status.NOT_FOUND.getStatusCode()) {
                throw gle;
            }
            gitLabApi = GitLabApi.oauth2Login(apiVersion, url, username, password, null, null, ignoreCertificateErrors);
        }
        return gitLabApi;
    }

    public static GitLabApi login(String url, String username, String password, boolean ignoreCertificateErrors) throws GitLabApiException {
        return GitLabApi.login(ApiVersion.V4, url, username, password, ignoreCertificateErrors);
    }

    @Deprecated
    public static GitLabApi create(String url, String username, String password) throws GitLabApiException {
        return GitLabApi.login(url, username, password);
    }

    public Session getSession() {
        return this.session;
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, Constants.TokenType tokenType, String authToken) {
        this(apiVersion, hostUrl, tokenType, authToken, null);
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, String privateToken) {
        this(apiVersion, hostUrl, privateToken, null);
    }

    public GitLabApi(String hostUrl, Constants.TokenType tokenType, String authToken) {
        this(ApiVersion.V4, hostUrl, tokenType, authToken, null);
    }

    public GitLabApi(String hostUrl, String privateToken) {
        this(ApiVersion.V4, hostUrl, privateToken, null);
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, Session session) {
        this(apiVersion, hostUrl, Constants.TokenType.PRIVATE, session.getPrivateToken(), null);
        this.session = session;
    }

    public GitLabApi(String hostUrl, Session session) {
        this(ApiVersion.V4, hostUrl, session);
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, Constants.TokenType tokenType, String authToken, String secretToken) {
        this(apiVersion, hostUrl, tokenType, authToken, secretToken, null);
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, String privateToken, String secretToken) {
        this(apiVersion, hostUrl, privateToken, secretToken, null);
    }

    public GitLabApi(String hostUrl, Constants.TokenType tokenType, String authToken, String secretToken) {
        this(ApiVersion.V4, hostUrl, tokenType, authToken, secretToken);
    }

    public GitLabApi(String hostUrl, String privateToken, String secretToken) {
        this(ApiVersion.V4, hostUrl, Constants.TokenType.PRIVATE, privateToken, secretToken);
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, String privateToken, String secretToken, Map<String, Object> clientConfigProperties) {
        this(apiVersion, hostUrl, Constants.TokenType.PRIVATE, privateToken, secretToken, clientConfigProperties);
    }

    public GitLabApi(String hostUrl, Constants.TokenType tokenType, String authToken, String secretToken, Map<String, Object> clientConfigProperties) {
        this(ApiVersion.V4, hostUrl, tokenType, authToken, secretToken, clientConfigProperties);
    }

    public GitLabApi(String hostUrl, String privateToken, String secretToken, Map<String, Object> clientConfigProperties) {
        this(ApiVersion.V4, hostUrl, Constants.TokenType.PRIVATE, privateToken, secretToken, clientConfigProperties);
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, Constants.TokenType tokenType, String authToken, String secretToken, Map<String, Object> clientConfigProperties) {
        this.apiVersion = apiVersion;
        this.gitLabServerUrl = hostUrl;
        this.clientConfigProperties = clientConfigProperties;
        this.apiClient = new GitLabApiClient(apiVersion, hostUrl, tokenType, authToken, secretToken, clientConfigProperties);
    }

    public void sudo(String sudoAsUsername) throws GitLabApiException {
        if (sudoAsUsername == null || sudoAsUsername.trim().length() == 0) {
            this.apiClient.setSudoAsId(null);
            return;
        }
        User user = this.getUserApi().getUser(sudoAsUsername);
        if (user == null || user.getId() == null) {
            throw new GitLabApiException("the specified username was not found");
        }
        Integer sudoAsId = user.getId();
        this.apiClient.setSudoAsId(sudoAsId);
    }

    public void unsudo() {
        this.apiClient.setSudoAsId(null);
    }

    public void setSudoAsId(Integer sudoAsId) throws GitLabApiException {
        if (sudoAsId == null) {
            this.apiClient.setSudoAsId(null);
            return;
        }
        User user = this.getUserApi().getUser(sudoAsId);
        if (user == null || user.getId() != sudoAsId) {
            throw new GitLabApiException("the specified user ID was not found");
        }
        this.apiClient.setSudoAsId(sudoAsId);
    }

    public Integer getSudoAsId() {
        return this.apiClient.getSudoAsId();
    }

    public String getAuthToken() {
        return this.apiClient.getAuthToken();
    }

    public String getSecretToken() {
        return this.apiClient.getSecretToken();
    }

    public Constants.TokenType getTokenType() {
        return this.apiClient.getTokenType();
    }

    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public String getGitLabServerUrl() {
        return this.gitLabServerUrl;
    }

    public int getDefaultPerPage() {
        return this.defaultPerPage;
    }

    public void setDefaultPerPage(int defaultPerPage) {
        this.defaultPerPage = defaultPerPage;
    }

    GitLabApiClient getApiClient() {
        return this.apiClient;
    }

    public boolean getIgnoreCertificateErrors() {
        return this.apiClient.getIgnoreCertificateErrors();
    }

    public void setIgnoreCertificateErrors(boolean ignoreCertificateErrors) {
        this.apiClient.setIgnoreCertificateErrors(ignoreCertificateErrors);
    }

    public Version getVersion() throws GitLabApiException {
        class VersionApi
        extends AbstractApi {
            VersionApi(GitLabApi gitlabApi) {
                super(gitlabApi);
            }
        }
        Response response = new VersionApi(this).get(Response.Status.OK, null, "version");
        return (Version)response.readEntity(Version.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommitsApi getCommitsApi() {
        if (this.commitsApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.commitsApi == null) {
                    this.commitsApi = new CommitsApi(this);
                }
            }
        }
        return this.commitsApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeployKeysApi getDeployKeysApi() {
        if (this.deployKeysApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.deployKeysApi == null) {
                    this.deployKeysApi = new DeployKeysApi(this);
                }
            }
        }
        return this.deployKeysApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventsApi getEventsApi() {
        if (this.eventsApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.eventsApi == null) {
                    this.eventsApi = new EventsApi(this);
                }
            }
        }
        return this.eventsApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupApi getGroupApi() {
        if (this.groupApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.groupApi == null) {
                    this.groupApi = new GroupApi(this);
                }
            }
        }
        return this.groupApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IssuesApi getIssuesApi() {
        if (this.issuesApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.issuesApi == null) {
                    this.issuesApi = new IssuesApi(this);
                }
            }
        }
        return this.issuesApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobApi getJobApi() {
        if (this.jobApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.jobApi == null) {
                    this.jobApi = new JobApi(this);
                }
            }
        }
        return this.jobApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LabelsApi getLabelsApi() {
        if (this.labelsApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.labelsApi == null) {
                    this.labelsApi = new LabelsApi(this);
                }
            }
        }
        return this.labelsApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MergeRequestApi getMergeRequestApi() {
        if (this.mergeRequestApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.mergeRequestApi == null) {
                    this.mergeRequestApi = new MergeRequestApi(this);
                }
            }
        }
        return this.mergeRequestApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MilestonesApi getMilestonesApi() {
        if (this.milestonesApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.milestonesApi == null) {
                    this.milestonesApi = new MilestonesApi(this);
                }
            }
        }
        return this.milestonesApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamespaceApi getNamespaceApi() {
        if (this.namespaceApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.namespaceApi == null) {
                    this.namespaceApi = new NamespaceApi(this);
                }
            }
        }
        return this.namespaceApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotesApi getNotesApi() {
        if (this.notesApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.notesApi == null) {
                    this.notesApi = new NotesApi(this);
                }
            }
        }
        return this.notesApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PipelineApi getPipelineApi() {
        if (this.pipelineApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.pipelineApi == null) {
                    this.pipelineApi = new PipelineApi(this);
                }
            }
        }
        return this.pipelineApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectApi getProjectApi() {
        if (this.projectApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.projectApi == null) {
                    this.projectApi = new ProjectApi(this);
                }
            }
        }
        return this.projectApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryApi getRepositoryApi() {
        if (this.repositoryApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.repositoryApi == null) {
                    this.repositoryApi = new RepositoryApi(this);
                }
            }
        }
        return this.repositoryApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryFileApi getRepositoryFileApi() {
        if (this.repositoryFileApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.repositoryFileApi == null) {
                    this.repositoryFileApi = new RepositoryFileApi(this);
                }
            }
        }
        return this.repositoryFileApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServicesApi getServicesApi() {
        if (this.servicesApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.servicesApi == null) {
                    this.servicesApi = new ServicesApi(this);
                }
            }
        }
        return this.servicesApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionApi getSessionApi() {
        if (this.sessionApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.sessionApi == null) {
                    this.sessionApi = new SessionApi(this);
                }
            }
        }
        return this.sessionApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserApi getUserApi() {
        if (this.userApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.userApi == null) {
                    this.userApi = new UserApi(this);
                }
            }
        }
        return this.userApi;
    }

    public static enum ApiVersion {
        V3,
        V4,
        OAUTH2_CLIENT;


        public String getApiNamespace() {
            return "/api/" + this.name().toLowerCase();
        }
    }
}

