/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Branch;
import org.gitlab4j.api.models.CompareResults;
import org.gitlab4j.api.models.Tag;
import org.gitlab4j.api.models.TreeItem;
import org.gitlab4j.api.utils.FileUtils;

public class RepositoryApi
extends AbstractApi {
    public RepositoryApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Branch> getBranches(Integer projectId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", projectId, "repository", "branches");
        return (List)response.readEntity((GenericType)new GenericType<List<Branch>>(){});
    }

    public List<Branch> getBranches(Integer projectId, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", projectId, "repository", "branches");
        return (List)response.readEntity((GenericType)new GenericType<List<Branch>>(){});
    }

    public Pager<Branch> getBranches(Integer projectId, int itemsPerPage) throws GitLabApiException {
        return new Pager<Branch>(this, Branch.class, itemsPerPage, null, "projects", projectId, "repository", "branches");
    }

    public Branch getBranch(Integer projectId, String branchName) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "repository", "branches", this.urlEncode(branchName));
        return (Branch)response.readEntity(Branch.class);
    }

    public Branch createBranch(Integer projectId, String branchName, String ref) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam(this.isApiVersion(GitLabApi.ApiVersion.V3) ? "branch_name" : "branch", branchName, true).withParam("ref", ref, true);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "repository", "branches");
        return (Branch)response.readEntity(Branch.class);
    }

    public void deleteBranch(Integer projectId, String branchName) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", projectId, "repository", "branches", this.urlEncode(branchName));
    }

    public Branch protectBranch(Integer projectId, String branchName) throws GitLabApiException {
        Response response = this.put(Response.Status.OK, null, "projects", projectId, "repository", "branches", this.urlEncode(branchName), "protect");
        return (Branch)response.readEntity(Branch.class);
    }

    public Branch unprotectBranch(Integer projectId, String branchName) throws GitLabApiException {
        Response response = this.put(Response.Status.OK, null, "projects", projectId, "repository", "branches", this.urlEncode(branchName), "unprotect");
        return (Branch)response.readEntity(Branch.class);
    }

    public List<Tag> getTags(Integer projectId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", projectId, "repository", "tags");
        return (List)response.readEntity((GenericType)new GenericType<List<Tag>>(){});
    }

    public List<Tag> getTags(Integer projectId, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", projectId, "repository", "tags");
        return (List)response.readEntity((GenericType)new GenericType<List<Tag>>(){});
    }

    public Pager<Tag> getTags(Integer projectId, int itemsPerPage) throws GitLabApiException {
        return new Pager<Tag>(this, Tag.class, itemsPerPage, null, "projects", projectId, "repository", "tags");
    }

    public Tag createTag(Integer projectId, String tagName, String ref, String message, String releaseNotes) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("tag_name", tagName, true).withParam("ref", ref, true).withParam("message", message, false).withParam("release_description", releaseNotes, false);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "repository", "tags");
        return (Tag)response.readEntity(Tag.class);
    }

    public Tag createTag(Integer projectId, String tagName, String ref, String message, File releaseNotesFile) throws GitLabApiException {
        String releaseNotes;
        if (releaseNotesFile != null) {
            try {
                releaseNotes = FileUtils.readFileContents(releaseNotesFile);
            }
            catch (IOException ioe) {
                throw new GitLabApiException(ioe);
            }
        } else {
            releaseNotes = null;
        }
        return this.createTag(projectId, tagName, ref, message, releaseNotes);
    }

    public void deleteTag(Integer projectId, String tagName) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", projectId, "repository", "tags", tagName);
    }

    public List<TreeItem> getTree(Integer projectId) throws GitLabApiException {
        return this.getTree(projectId, "/", "master");
    }

    public Pager<TreeItem> getTree(Integer projectId, int itemsPerPage) throws GitLabApiException {
        return this.getTree(projectId, "/", "master", false, itemsPerPage);
    }

    public List<TreeItem> getTree(Integer projectId, String filePath, String refName) throws GitLabApiException {
        return this.getTree(projectId, filePath, refName, false);
    }

    public Pager<TreeItem> getTree(Integer projectId, String filePath, String refName, int itemsPerPage) throws GitLabApiException {
        return this.getTree(projectId, filePath, refName, false, itemsPerPage);
    }

    public List<TreeItem> getTree(Integer projectId, String filePath, String refName, Boolean recursive) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("id", projectId, true).withParam("path", filePath, false).withParam(this.isApiVersion(GitLabApi.ApiVersion.V3) ? "ref_name" : "ref", refName, false).withParam("recursive", recursive, false).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "repository", "tree");
        return (List)response.readEntity((GenericType)new GenericType<List<TreeItem>>(){});
    }

    public Pager<TreeItem> getTree(Integer projectId, String filePath, String refName, Boolean recursive, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("id", projectId, true).withParam("path", filePath, false).withParam(this.isApiVersion(GitLabApi.ApiVersion.V3) ? "ref_name" : "ref", refName, false).withParam("recursive", recursive, false);
        return new Pager<TreeItem>(this, TreeItem.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "repository", "tree");
    }

    public InputStream getRawBlobContent(Integer projectId, String sha) throws GitLabApiException {
        Response response = this.getWithAccepts(Response.Status.OK, null, "*", "projects", projectId, "repository", "blobs", sha, "raw");
        return (InputStream)response.readEntity(InputStream.class);
    }

    public InputStream getRepositoryArchive(Integer projectId, String sha) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("sha", sha);
        Response response = this.getWithAccepts(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "*", "projects", projectId, "repository", "archive");
        return (InputStream)response.readEntity(InputStream.class);
    }

    public File getRepositoryArchive(Integer projectId, String sha, File directory) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("sha", sha);
        Response response = this.getWithAccepts(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "*", "projects", projectId, "repository", "archive");
        try {
            if (directory == null) {
                directory = new File(System.getProperty("java.io.tmpdir"));
            }
            String filename = FileUtils.getFilenameFromContentDisposition(response);
            File file = new File(directory, filename);
            InputStream in = (InputStream)response.readEntity(InputStream.class);
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
    }

    public CompareResults compare(Integer projectId, String from, String to) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("from", from, true).withParam("to", to, true);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "repository", "compare");
        return (CompareResults)response.readEntity(CompareResults.class);
    }

    public CompareResults compare(String projectPath, String from, String to) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("from", from, true).withParam("to", to, true);
        try {
            projectPath = URLEncoder.encode(projectPath, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new GitLabApiException(uee);
        }
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectPath, "repository", "compare");
        return (CompareResults)response.readEntity(CompareResults.class);
    }
}

