/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.List;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Group;
import org.gitlab4j.api.models.Member;
import org.gitlab4j.api.models.Project;
import org.gitlab4j.api.models.Visibility;

public class GroupApi
extends AbstractApi {
    public GroupApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Group> getGroups() throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "groups");
        return (List)response.readEntity((GenericType)new GenericType<List<Group>>(){});
    }

    public List<Group> getGroups(int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "groups");
        return (List)response.readEntity((GenericType)new GenericType<List<Group>>(){});
    }

    public Pager<Group> getGroups(int itemsPerPage) throws GitLabApiException {
        return new Pager<Group>(this, Group.class, itemsPerPage, null, "groups");
    }

    public List<Group> getGroups(String search) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("search", search).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups");
        return (List)response.readEntity((GenericType)new GenericType<List<Group>>(){});
    }

    public List<Group> getGroups(String search, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("search", search).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups");
        return (List)response.readEntity((GenericType)new GenericType<List<Group>>(){});
    }

    public Pager<Group> getGroups(String search, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("search", search);
        return new Pager<Group>(this, Group.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "groups");
    }

    public List<Project> getProjects(int groupId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "groups", groupId, "projects");
        return (List)response.readEntity((GenericType)new GenericType<List<Project>>(){});
    }

    public List<Project> getProjects(int groupId, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "groups", groupId, "projects");
        return (List)response.readEntity((GenericType)new GenericType<List<Project>>(){});
    }

    public Pager<Project> getProjects(int groupId, int itemsPerPage) throws GitLabApiException {
        return new Pager<Project>(this, Project.class, itemsPerPage, null, "groups", groupId, "projects");
    }

    public Group getGroup(Integer groupId) throws GitLabApiException {
        return this.getGroup(groupId.toString());
    }

    public Group getGroup(String groupPath) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", this.urlEncode(groupPath));
        return (Group)response.readEntity(Group.class);
    }

    public void addGroup(String name, String path) throws GitLabApiException {
        Form formData = new Form();
        formData.param("name", name);
        formData.param("path", path);
        this.post(Response.Status.CREATED, formData, "groups");
    }

    public void addGroup(String name, String path, String description, Boolean membershipLock, Boolean shareWithGroupLock, Visibility visibility, Boolean lfsEnabled, Boolean requestAccessEnabled, Integer parentId, Integer sharedRunnersMinutesLimit) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name).withParam("path", path).withParam("description", description).withParam("membership_lock", membershipLock).withParam("share_with_group_lock", shareWithGroupLock).withParam("visibility", (Object)visibility).withParam("lfs_enabled", lfsEnabled).withParam("request_access_enabled", requestAccessEnabled).withParam("parent_id", parentId).withParam("shared_runners_minutes_limit", sharedRunnersMinutesLimit);
        this.post(Response.Status.CREATED, (Form)formData, "groups");
    }

    public Group updateGroup(Integer groupId, String name, String path, String description, Boolean membershipLock, Boolean shareWithGroupLock, Visibility visibility, Boolean lfsEnabled, Boolean requestAccessEnabled, Integer parentId, Integer sharedRunnersMinutesLimit) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name).withParam("path", path).withParam("description", description).withParam("membership_lock", membershipLock).withParam("share_with_group_lock", shareWithGroupLock).withParam("visibility", (Object)visibility).withParam("lfs_enabled", lfsEnabled).withParam("request_access_enabled", requestAccessEnabled).withParam("parent_id", parentId).withParam("shared_runners_minutes_limit", sharedRunnersMinutesLimit);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups", groupId);
        return (Group)response.readEntity(Group.class);
    }

    public void deleteGroup(Integer groupId) throws GitLabApiException {
        if (groupId == null) {
            throw new RuntimeException("groupId cannot be null");
        }
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "groups", groupId);
    }

    public void deleteGroup(Group group) throws GitLabApiException {
        this.deleteGroup(group.getId());
    }

    public List<Member> getMembers(int groupId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "groups", groupId, "members");
        return (List)response.readEntity((GenericType)new GenericType<List<Member>>(){});
    }

    public List<Member> getMembers(int groupId, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "groups", groupId, "members");
        return (List)response.readEntity((GenericType)new GenericType<List<Member>>(){});
    }

    public Pager<Member> getMembers(int groupId, int itemsPerPage) throws GitLabApiException {
        return new Pager<Member>(this, Member.class, itemsPerPage, null, "groups", groupId, "members");
    }

    public Member getMember(int groupId, int userId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "groups", groupId, "members", userId);
        return (Member)response.readEntity((GenericType)new GenericType<Member>(){});
    }

    public Member addMember(Integer groupId, Integer userId, Integer accessLevel) throws GitLabApiException {
        Form formData = new Form();
        formData.param("user_id", userId.toString());
        formData.param("access_level", accessLevel.toString());
        Response response = this.post(Response.Status.CREATED, formData, "groups", groupId, "members");
        return (Member)response.readEntity(Member.class);
    }

    public void removeMember(Integer projectId, Integer userId) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "groups", projectId, "members", userId);
    }
}

