/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.DatatypeConverter;

public class ISO8601 {
    public static final String PATTERN = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String PATTERN_MSEC = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String OUTPUT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String OUTPUT_MSEC_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String UTC_PATTERN = "yyyy-MM-dd HH:mm:ss 'UTC'";

    public static String getTimestamp() {
        return SafeDateFormatter.getDateFormat(PATTERN).format(new Date());
    }

    public static String getTimestamp(boolean withMsec) {
        return withMsec ? SafeDateFormatter.getDateFormat(PATTERN_MSEC).format(new Date()) : SafeDateFormatter.getDateFormat(PATTERN).format(new Date());
    }

    public static String toString(Calendar cal) {
        if (cal == null) {
            return null;
        }
        return ISO8601.toString(cal.getTime());
    }

    public static String toString(Date date, boolean withMsec) {
        if (date == null) {
            return null;
        }
        long time = date.getTime();
        return withMsec && time % 1000L != 0L ? SafeDateFormatter.getDateFormat(OUTPUT_MSEC_PATTERN).format(date) : SafeDateFormatter.getDateFormat(OUTPUT_PATTERN).format(date);
    }

    public static String toString(Date date) {
        return ISO8601.toString(date, true);
    }

    public static Date toDate(String dateTimeString) throws ParseException {
        if (dateTimeString == null) {
            return null;
        }
        if ((dateTimeString = dateTimeString.trim()).endsWith("UTC")) {
            return SafeDateFormatter.getDateFormat(UTC_PATTERN).parse(dateTimeString);
        }
        Calendar cal = DatatypeConverter.parseDateTime((String)dateTimeString);
        return cal.getTime();
    }

    public static Calendar toCalendar(String dateTimeString) throws ParseException {
        Date date = ISO8601.toDate(dateTimeString);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    private static final class SafeDateFormatter {
        private static final ThreadLocal<Map<String, SimpleDateFormat>> safeFormats = new ThreadLocal<Map<String, SimpleDateFormat>>(){

            @Override
            public Map<String, SimpleDateFormat> initialValue() {
                return new ConcurrentHashMap<String, SimpleDateFormat>();
            }
        };

        private SafeDateFormatter() {
        }

        private static SimpleDateFormat getDateFormat(String formatSpec) {
            Map<String, SimpleDateFormat> formatMap = safeFormats.get();
            SimpleDateFormat format = formatMap.get(formatSpec);
            if (format == null) {
                format = new SimpleDateFormat(formatSpec);
                format.setLenient(true);
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                formatMap.put(formatSpec, format);
            }
            return format;
        }
    }
}

