/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api.webhook;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.HookManager;
import org.gitlab4j.api.utils.HttpRequestUtils;
import org.gitlab4j.api.utils.JacksonJson;
import org.gitlab4j.api.webhook.BuildEvent;
import org.gitlab4j.api.webhook.Event;
import org.gitlab4j.api.webhook.IssueEvent;
import org.gitlab4j.api.webhook.MergeRequestEvent;
import org.gitlab4j.api.webhook.NoteEvent;
import org.gitlab4j.api.webhook.PipelineEvent;
import org.gitlab4j.api.webhook.PushEvent;
import org.gitlab4j.api.webhook.TagPushEvent;
import org.gitlab4j.api.webhook.WebHookListener;
import org.gitlab4j.api.webhook.WikiPageEvent;

public class WebHookManager
extends HookManager {
    private static final Logger LOG = Logger.getLogger(WebHookManager.class.getName());
    private final JacksonJson jacksonJson = new JacksonJson();
    private final List<WebHookListener> webhookListeners = new CopyOnWriteArrayList<WebHookListener>();

    public WebHookManager() {
    }

    public WebHookManager(String secretToken) {
        super(secretToken);
    }

    @Override
    public void handleEvent(HttpServletRequest request) throws GitLabApiException {
        if (!this.isValidSecretToken(request)) {
            String message = "X-Gitlab-Token mismatch!";
            LOG.warning(message);
            throw new GitLabApiException(message);
        }
        String eventName = request.getHeader("X-Gitlab-Event");
        LOG.info("handleEvent: X-Gitlab-Event=" + eventName);
        switch (eventName) {
            case "Build Hook": 
            case "Issue Hook": 
            case "Merge Request Hook": 
            case "Note Hook": 
            case "Pipeline Hook": 
            case "Push Hook": 
            case "Tag Push Hook": 
            case "Wiki Page Hook": {
                break;
            }
            default: {
                String message = "Unsupported X-Gitlab-Event, event Name=" + eventName;
                LOG.warning(message);
                throw new GitLabApiException(message);
            }
        }
        String errorMessage = null;
        try {
            Event event;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(HttpRequestUtils.getShortRequestDump(eventName + " webhook", true, request));
                String postData = HttpRequestUtils.getPostDataAsString(request);
                LOG.fine("Raw POST data:\n" + postData);
                event = this.jacksonJson.unmarshal(Event.class, postData);
                LOG.fine(event.getObjectKind() + " event:\n" + this.jacksonJson.marshal(event) + "\n");
            } else {
                InputStreamReader reader = new InputStreamReader((InputStream)request.getInputStream());
                event = this.jacksonJson.unmarshal(Event.class, reader);
            }
            this.fireEvent(event);
        }
        catch (JsonParseException jpe) {
            errorMessage = jpe.getMessage();
            LOG.warning("Error parsing JSON data, error=" + errorMessage);
        }
        catch (JsonMappingException jme) {
            errorMessage = jme.getMessage();
            LOG.warning("Error mapping JSON data, error=" + errorMessage);
        }
        catch (IOException ioe) {
            errorMessage = ioe.getMessage();
            LOG.warning("Error reading JSON data, error=" + errorMessage);
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            LOG.warning("Unexpected error reading JSON data, error=" + errorMessage);
        }
        if (errorMessage != null) {
            throw new GitLabApiException(errorMessage);
        }
    }

    public void handleEvent(Event event) throws GitLabApiException {
        LOG.info("handleEvent: object_kind=" + event.getObjectKind());
        switch (event.getObjectKind()) {
            case "build": 
            case "issue": 
            case "merge_request": 
            case "note": 
            case "pipeline": 
            case "push": 
            case "tag_push": 
            case "wiki_page": {
                break;
            }
            default: {
                String message = "Unsupported event object_kind, object_kind=" + event.getObjectKind();
                LOG.warning(message);
                throw new GitLabApiException(message);
            }
        }
        this.fireEvent(event);
    }

    public void addListener(WebHookListener listener) {
        if (!this.webhookListeners.contains(listener)) {
            this.webhookListeners.add(listener);
        }
    }

    public void removeListener(WebHookListener listener) {
        this.webhookListeners.remove(listener);
    }

    public void fireEvent(Event event) throws GitLabApiException {
        switch (event.getObjectKind()) {
            case "build": {
                this.fireBuildEvent((BuildEvent)event);
                break;
            }
            case "issue": {
                this.fireIssueEvent((IssueEvent)event);
                break;
            }
            case "merge_request": {
                this.fireMergeRequestEvent((MergeRequestEvent)event);
                break;
            }
            case "note": {
                this.fireNoteEvent((NoteEvent)event);
                break;
            }
            case "pipeline": {
                this.firePipelineEvent((PipelineEvent)event);
                break;
            }
            case "push": {
                this.firePushEvent((PushEvent)event);
                break;
            }
            case "tag_push": {
                this.fireTagPushEvent((TagPushEvent)event);
                break;
            }
            case "wiki_page": {
                this.fireWikiPageEvent((WikiPageEvent)event);
                break;
            }
            default: {
                String message = "Unsupported event object_kind, object_kind=" + event.getObjectKind();
                LOG.warning(message);
                throw new GitLabApiException(message);
            }
        }
    }

    protected void fireBuildEvent(BuildEvent buildEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onBuildEvent(buildEvent);
        }
    }

    protected void fireIssueEvent(IssueEvent issueEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onIssueEvent(issueEvent);
        }
    }

    protected void fireMergeRequestEvent(MergeRequestEvent mergeRequestEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onMergeRequestEvent(mergeRequestEvent);
        }
    }

    protected void fireNoteEvent(NoteEvent noteEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onNoteEvent(noteEvent);
        }
    }

    protected void firePipelineEvent(PipelineEvent pipelineEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onPipelineEvent(pipelineEvent);
        }
    }

    protected void firePushEvent(PushEvent pushEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onPushEvent(pushEvent);
        }
    }

    protected void fireTagPushEvent(TagPushEvent tagPushEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onTagPushEvent(tagPushEvent);
        }
    }

    protected void fireWikiPageEvent(WikiPageEvent wikiPageEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onWikiPageEvent(wikiPageEvent);
        }
    }
}

