/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.List;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.models.Label;

public class LabelsApi
extends AbstractApi {
    public LabelsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Label> getLabels(Integer projectId) throws GitLabApiException {
        return this.getLabels(projectId, 1, this.getDefaultPerPage());
    }

    public List<Label> getLabels(Integer projectId, int page, int perPage) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", projectId, "labels");
        return (List)response.readEntity((GenericType)new GenericType<List<Label>>(){});
    }

    public Label createLabel(Integer projectId, String name, String color, String description) throws GitLabApiException {
        return this.createLabel(projectId, name, color, description, null);
    }

    public Label createLabel(Integer projectId, String name, String color) throws GitLabApiException {
        return this.createLabel(projectId, name, color, null, null);
    }

    public Label createLabel(Integer projectId, String name, String color, Integer priority) throws GitLabApiException {
        return this.createLabel(projectId, name, color, null, priority);
    }

    public Label createLabel(Integer projectId, String name, String color, String description, Integer priority) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true).withParam("color", color, true).withParam("description", description).withParam("priority", priority);
        Response response = this.post(Response.Status.OK, (Form)formData, "projects", projectId, "labels");
        return (Label)response.readEntity(Label.class);
    }

    public Label updateLabelName(Integer projectId, String name, String newName, String description, Integer priority) throws GitLabApiException {
        return this.updateLabel(projectId, name, newName, null, description, priority);
    }

    public Label updateLabelColor(Integer projectId, String name, String color, String description, Integer priority) throws GitLabApiException {
        return this.updateLabel(projectId, name, null, color, description, priority);
    }

    public Label updateLabel(Integer projectId, String name, String newName, String color, String description, Integer priority) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true).withParam("new_name", newName).withParam("color", color).withParam("description", description).withParam("priority", priority);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "labels");
        return (Label)response.readEntity(Label.class);
    }

    public void deleteLabel(Integer projectId, String name) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true);
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "labels");
    }

    public Label subscribeLabel(Integer projectId, Integer labelId) throws GitLabApiException {
        Response response = this.post(Response.Status.NOT_MODIFIED, this.getDefaultPerPageParam(), "projects", projectId, "labels", labelId, "subscribe");
        return (Label)response.readEntity(Label.class);
    }

    public Label unsubscribeLabel(Integer projectId, Integer labelId) throws GitLabApiException {
        Response response = this.post(Response.Status.NOT_MODIFIED, this.getDefaultPerPageParam(), "projects", projectId, "labels", labelId, "unsubscribe");
        return (Label)response.readEntity(Label.class);
    }
}

