/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DurationUtils {
    private static char[] TIME_UNITS = new char[]{'w', 'd', 'h', 'm', 's'};
    private static int[] TIME_UNIT_MULTIPLIERS = new int[]{604800, 86400, 3600, 60, 1};
    private static Pattern durationPattern = Pattern.compile("(\\s*(\\d+)([a-z]))");

    public static final String toString(int durationSeconds) {
        int weeks = durationSeconds / TIME_UNIT_MULTIPLIERS[0];
        int days = (durationSeconds - weeks * TIME_UNIT_MULTIPLIERS[0]) / TIME_UNIT_MULTIPLIERS[1];
        int seconds = durationSeconds - weeks * TIME_UNIT_MULTIPLIERS[0] - days * TIME_UNIT_MULTIPLIERS[1];
        int hours = seconds / 3600;
        int minutes = seconds % 3600 / 60;
        seconds %= 60;
        StringBuilder buf = new StringBuilder();
        if (weeks > 0) {
            buf.append(weeks).append('w');
            if (seconds > 0) {
                buf.append(days).append('d').append(hours).append('h').append(minutes).append('m').append(seconds).append('s');
            } else if (minutes > 0) {
                buf.append(days).append('d').append(hours).append('h').append(minutes).append('m');
            } else if (hours > 0) {
                buf.append(days).append('d').append(hours).append('h');
            }
        } else if (days > 0) {
            buf.append(days).append('d');
            if (seconds > 0) {
                buf.append(hours).append('h').append(minutes).append('m').append(seconds).append('s');
            } else if (minutes > 0) {
                buf.append(hours).append('h').append(minutes).append('m');
            } else if (hours > 0) {
                buf.append(hours).append('h');
            }
        } else if (hours > 0) {
            buf.append(hours).append('h');
            if (seconds > 0) {
                buf.append(minutes).append('m').append(seconds).append('s');
            } else if (minutes > 0) {
                buf.append(minutes).append('m');
            }
        } else if (minutes > 0) {
            buf.append(minutes).append('m');
            if (seconds > 0) {
                buf.append(seconds).append('s');
            }
        } else {
            buf.append(' ').append(seconds).append('s');
        }
        return buf.toString();
    }

    public static final int parse(String durationString) {
        durationString = durationString.toLowerCase();
        Matcher matcher = durationPattern.matcher(durationString);
        int currentUnitIndex = -1;
        int seconds = 0;
        Boolean validDuration = null;
        while (matcher.find() && validDuration != Boolean.FALSE) {
            validDuration = true;
            int numGroups = matcher.groupCount();
            if (numGroups == 3) {
                char unit = matcher.group(3).charAt(0);
                int nextUnitIndex = DurationUtils.getUnitIndex(unit);
                if (nextUnitIndex > currentUnitIndex) {
                    currentUnitIndex = nextUnitIndex;
                    try {
                        seconds = (int)((long)seconds + Long.parseLong(matcher.group(2)) * (long)TIME_UNIT_MULTIPLIERS[nextUnitIndex]);
                    }
                    catch (NumberFormatException nfe) {
                        validDuration = false;
                    }
                    continue;
                }
                validDuration = false;
                continue;
            }
            validDuration = false;
        }
        if (validDuration != Boolean.TRUE) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid duration", durationString));
        }
        return seconds;
    }

    private static final int getUnitIndex(char unit) {
        for (int i = 0; i < TIME_UNITS.length; ++i) {
            if (unit != TIME_UNITS[i]) continue;
            return i;
        }
        return -1;
    }
}

