/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.utils.JacksonJson;
import org.glassfish.jersey.client.ClientConfig;

public class GitLabApiClient {
    protected static final String PRIVATE_TOKEN_HEADER = "PRIVATE-TOKEN";
    protected static final String AUTHORIZATION_HEADER = "Authorization";
    protected static final String X_GITLAB_TOKEN_HEADER = "X-Gitlab-Token";
    private ClientConfig clientConfig;
    private Client apiClient;
    private String hostUrl;
    private Constants.TokenType tokenType = Constants.TokenType.PRIVATE;
    private String authToken;
    private String secretToken;
    private boolean ignoreCertificateErrors;
    private SSLContext openSslContext;
    private HostnameVerifier openHostnameVerifier;

    public GitLabApiClient(GitLabApi.ApiVersion apiVersion, String hostUrl, String privateToken) {
        this(apiVersion, hostUrl, Constants.TokenType.PRIVATE, privateToken, null);
    }

    public GitLabApiClient(GitLabApi.ApiVersion apiVersion, String hostUrl, Constants.TokenType tokenType, String authToken) {
        this(apiVersion, hostUrl, tokenType, authToken, null);
    }

    public GitLabApiClient(String hostUrl, String privateToken) {
        this(GitLabApi.ApiVersion.V4, hostUrl, Constants.TokenType.PRIVATE, privateToken, null);
    }

    public GitLabApiClient(String hostUrl, Constants.TokenType tokenType, String authToken) {
        this(GitLabApi.ApiVersion.V4, hostUrl, tokenType, authToken, null);
    }

    public GitLabApiClient(GitLabApi.ApiVersion apiVersion, String hostUrl, String privateToken, String secretToken) {
        this(apiVersion, hostUrl, Constants.TokenType.PRIVATE, privateToken, secretToken, null);
    }

    public GitLabApiClient(GitLabApi.ApiVersion apiVersion, String hostUrl, Constants.TokenType tokenType, String authToken, String secretToken) {
        this(apiVersion, hostUrl, tokenType, authToken, secretToken, null);
    }

    public GitLabApiClient(String hostUrl, String privateToken, String secretToken) {
        this(GitLabApi.ApiVersion.V4, hostUrl, Constants.TokenType.PRIVATE, privateToken, secretToken, null);
    }

    public GitLabApiClient(String hostUrl, Constants.TokenType tokenType, String authToken, String secretToken) {
        this(GitLabApi.ApiVersion.V4, hostUrl, tokenType, authToken, secretToken, null);
    }

    public GitLabApiClient(String hostUrl, String privateToken, String secretToken, Map<String, Object> clientConfigProperties) {
        this(GitLabApi.ApiVersion.V4, hostUrl, Constants.TokenType.PRIVATE, privateToken, secretToken, clientConfigProperties);
    }

    public GitLabApiClient(GitLabApi.ApiVersion apiVersion, String hostUrl, String privateToken, String secretToken, Map<String, Object> clientConfigProperties) {
        this(apiVersion, hostUrl, Constants.TokenType.PRIVATE, privateToken, secretToken, clientConfigProperties);
    }

    public GitLabApiClient(GitLabApi.ApiVersion apiVersion, String hostUrl, Constants.TokenType tokenType, String authToken, String secretToken, Map<String, Object> clientConfigProperties) {
        this.hostUrl = (hostUrl.endsWith("/") ? hostUrl.replaceAll("/$", "") : hostUrl) + apiVersion.getApiNamespace();
        this.tokenType = tokenType;
        this.authToken = authToken;
        if (secretToken != null) {
            secretToken = (secretToken = secretToken.trim()).length() > 0 ? secretToken : null;
        }
        this.secretToken = secretToken;
        this.clientConfig = new ClientConfig();
        if (clientConfigProperties != null) {
            this.clientConfig.getProperties().putAll(clientConfigProperties);
        }
        this.clientConfig.register(JacksonJson.class);
    }

    protected URL getApiUrl(Object ... pathArgs) throws IOException {
        StringBuilder url = new StringBuilder();
        url.append(this.hostUrl);
        for (Object pathArg : pathArgs) {
            if (pathArg == null) continue;
            url.append("/");
            url.append(pathArg.toString());
        }
        return new URL(url.toString());
    }

    protected boolean validateSecretToken(Response response) {
        if (this.secretToken == null) {
            return true;
        }
        String secretToken = response.getHeaderString(X_GITLAB_TOKEN_HEADER);
        if (secretToken == null) {
            return false;
        }
        return this.secretToken.equals(secretToken);
    }

    protected Response get(MultivaluedMap<String, String> queryParams, Object ... pathArgs) throws IOException {
        URL url = this.getApiUrl(pathArgs);
        return this.get(queryParams, url);
    }

    protected Response get(MultivaluedMap<String, String> queryParams, URL url) {
        return this.invocation(url, queryParams).get();
    }

    protected Response getWithAccepts(MultivaluedMap<String, String> queryParams, String accepts, Object ... pathArgs) throws IOException {
        URL url = this.getApiUrl(pathArgs);
        return this.getWithAccepts(queryParams, url, accepts);
    }

    protected Response getWithAccepts(MultivaluedMap<String, String> queryParams, URL url, String accepts) {
        return this.invocation(url, queryParams, accepts).get();
    }

    protected Response post(Form formData, Object ... pathArgs) throws IOException {
        URL url = this.getApiUrl(pathArgs);
        return this.post(formData, url);
    }

    protected Response post(MultivaluedMap<String, String> queryParams, Object ... pathArgs) throws IOException {
        URL url = this.getApiUrl(pathArgs);
        return this.post(queryParams, url);
    }

    protected Response post(Form formData, URL url) {
        if (formData instanceof GitLabApiForm) {
            return this.invocation(url, null).post(Entity.entity((Object)formData.asMap(), (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        }
        return this.invocation(url, null).post(Entity.entity((Object)formData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
    }

    protected Response post(MultivaluedMap<String, String> queryParams, URL url) {
        return this.invocation(url, queryParams).post(null);
    }

    protected Response put(MultivaluedMap<String, String> queryParams, Object ... pathArgs) throws IOException {
        URL url = this.getApiUrl(pathArgs);
        return this.put(queryParams, url);
    }

    protected Response put(MultivaluedMap<String, String> queryParams, URL url) {
        return this.invocation(url, null).put(Entity.entity(queryParams, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
    }

    protected Response put(Form formData, Object ... pathArgs) throws IOException {
        URL url = this.getApiUrl(pathArgs);
        return this.put(formData, url);
    }

    protected Response put(Form formData, URL url) {
        if (formData instanceof GitLabApiForm) {
            return this.invocation(url, null).put(Entity.entity((Object)formData.asMap(), (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        }
        return this.invocation(url, null).put(Entity.entity((Object)formData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
    }

    protected Response delete(MultivaluedMap<String, String> queryParams, Object ... pathArgs) throws IOException {
        return this.delete(queryParams, this.getApiUrl(pathArgs));
    }

    protected Response delete(MultivaluedMap<String, String> queryParams, URL url) {
        return this.invocation(url, queryParams).delete();
    }

    protected Invocation.Builder invocation(URL url, MultivaluedMap<String, String> queryParams) {
        return this.invocation(url, queryParams, "application/json");
    }

    protected Invocation.Builder invocation(URL url, MultivaluedMap<String, String> queryParams, String accept) {
        String authValue;
        if (this.apiClient == null) {
            this.apiClient = this.ignoreCertificateErrors ? ClientBuilder.newBuilder().withConfig((Configuration)this.clientConfig).sslContext(this.openSslContext).hostnameVerifier(this.openHostnameVerifier).build() : ClientBuilder.newBuilder().withConfig((Configuration)this.clientConfig).build();
        }
        WebTarget target = (WebTarget)this.apiClient.target(url.toExternalForm()).property("jersey.config.client.followRedirects", (Object)true);
        if (queryParams != null) {
            for (Map.Entry param : queryParams.entrySet()) {
                target = target.queryParam((String)param.getKey(), ((List)param.getValue()).toArray());
            }
        }
        String authHeader = this.tokenType == Constants.TokenType.ACCESS ? AUTHORIZATION_HEADER : PRIVATE_TOKEN_HEADER;
        String string = authValue = this.tokenType == Constants.TokenType.ACCESS ? "Bearer " + this.authToken : this.authToken;
        if (accept == null || accept.trim().length() == 0) {
            return target.request().header(authHeader, (Object)authValue);
        }
        return target.request().header(authHeader, (Object)authValue).accept(new String[]{accept});
    }

    public boolean getIgnoreCertificateErrors() {
        return this.ignoreCertificateErrors;
    }

    public void setIgnoreCertificateErrors(boolean ignoreCertificateErrors) {
        if (this.ignoreCertificateErrors == ignoreCertificateErrors) {
            return;
        }
        if (!ignoreCertificateErrors) {
            this.ignoreCertificateErrors = false;
            this.openSslContext = null;
            this.openHostnameVerifier = null;
            this.apiClient = null;
        } else if (this.setupIgnoreCertificateErrors()) {
            this.ignoreCertificateErrors = true;
            this.apiClient = null;
        } else {
            this.ignoreCertificateErrors = false;
            this.apiClient = null;
            throw new RuntimeException("Unable to ignore certificate errors.");
        }
    }

    private boolean setupIgnoreCertificateErrors() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509ExtendedTrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            }
        }};
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            this.openSslContext = sslContext;
            this.openHostnameVerifier = hostnameVerifier;
        }
        catch (GeneralSecurityException ex) {
            this.openSslContext = null;
            this.openHostnameVerifier = null;
            return false;
        }
        return true;
    }
}

