/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;

public class ISO8601 {
    public static final String PATTERN = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String PATTERN_MSEC = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String OUTPUT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String OUTPUT_MSEC_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String UTC_PATTERN = "yyyy-MM-dd HH:mm:ss 'UTC'";
    private static final SimpleDateFormat iso8601Format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final SimpleDateFormat iso8601MsecFormat;
    private static final SimpleDateFormat iso8601OutputFormat;
    private static final SimpleDateFormat iso8601OutputMsecFormat;
    private static final SimpleDateFormat iso8601UtcFormat;

    public static String getTimestamp() {
        return iso8601Format.format(new Date());
    }

    public static String getTimestamp(boolean withMsec) {
        return withMsec ? iso8601MsecFormat.format(new Date()) : iso8601Format.format(new Date());
    }

    public static String toString(Calendar cal) {
        if (cal == null) {
            return null;
        }
        return ISO8601.toString(cal.getTime());
    }

    public static synchronized String toString(Date date) {
        if (date == null) {
            return null;
        }
        long time = date.getTime();
        return time % 1000L != 0L ? iso8601OutputMsecFormat.format(date) : iso8601OutputFormat.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date toDate(String dateTimeString) throws ParseException {
        if (dateTimeString == null) {
            return null;
        }
        if ((dateTimeString = dateTimeString.trim()).endsWith("UTC")) {
            SimpleDateFormat simpleDateFormat = iso8601UtcFormat;
            synchronized (simpleDateFormat) {
                return iso8601UtcFormat.parse(dateTimeString);
            }
        }
        Calendar cal = DatatypeConverter.parseDateTime((String)dateTimeString);
        return cal.getTime();
    }

    public static Calendar toCalendar(String dateTimeString) throws ParseException {
        Date date = ISO8601.toDate(dateTimeString);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    static {
        iso8601Format.setLenient(true);
        iso8601Format.setTimeZone(TimeZone.getTimeZone("UTC"));
        iso8601MsecFormat = new SimpleDateFormat(PATTERN_MSEC);
        iso8601MsecFormat.setLenient(true);
        iso8601MsecFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        iso8601OutputFormat = new SimpleDateFormat(OUTPUT_PATTERN);
        iso8601OutputFormat.setLenient(true);
        iso8601OutputFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        iso8601OutputMsecFormat = new SimpleDateFormat(OUTPUT_MSEC_PATTERN);
        iso8601OutputMsecFormat.setLenient(true);
        iso8601OutputMsecFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        iso8601UtcFormat = new SimpleDateFormat(UTC_PATTERN);
        iso8601UtcFormat.setLenient(true);
        iso8601UtcFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

