/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.utils.JacksonJson;
import org.glassfish.jersey.client.ClientConfig;

public class GitLabApiClient {
    protected static final String PRIVATE_TOKEN_HEADER = "PRIVATE-TOKEN";
    protected static final String X_GITLAB_TOKEN_HEADER = "X-Gitlab-Token";
    private ClientConfig clientConfig;
    private Client apiClient;
    private String hostUrl;
    private String privateToken;
    private String secretToken;
    private static boolean ignoreCertificateErrors;
    private static SSLSocketFactory defaultSocketFactory;

    public GitLabApiClient(GitLabApi.ApiVersion apiVersion, String hostUrl, String privateToken) {
        this(apiVersion, hostUrl, privateToken, null);
    }

    public GitLabApiClient(String hostUrl, String privateToken) {
        this(GitLabApi.ApiVersion.V4, hostUrl, privateToken, null);
    }

    public GitLabApiClient(GitLabApi.ApiVersion apiVersion, String hostUrl, String privateToken, String secretToken) {
        this(apiVersion, hostUrl, privateToken, secretToken, null);
    }

    public GitLabApiClient(String hostUrl, String privateToken, String secretToken) {
        this(GitLabApi.ApiVersion.V4, hostUrl, privateToken, secretToken, null);
    }

    public GitLabApiClient(GitLabApi.ApiVersion apiVersion, String hostUrl, String privateToken, String secretToken, Map<String, Object> clientConfigProperties) {
        this.hostUrl = (hostUrl.endsWith("/") ? hostUrl.replaceAll("/$", "") : hostUrl) + apiVersion.getApiNamespace();
        this.privateToken = privateToken;
        if (secretToken != null) {
            secretToken = (secretToken = secretToken.trim()).length() > 0 ? secretToken : null;
        }
        this.secretToken = secretToken;
        this.clientConfig = new ClientConfig();
        if (clientConfigProperties != null) {
            this.clientConfig.getProperties().putAll(clientConfigProperties);
        }
        this.clientConfig.register(JacksonJson.class);
    }

    public GitLabApiClient(String hostUrl, String privateToken, String secretToken, Map<String, Object> clientConfigProperties) {
        this(GitLabApi.ApiVersion.V4, hostUrl, privateToken, secretToken, clientConfigProperties);
    }

    public boolean getIgnoreCertificateErrors() {
        return ignoreCertificateErrors;
    }

    public void setIgnoreCerificateErrors(boolean ignoreCertificateErrors) {
        if (GitLabApiClient.ignoreCertificateErrors == ignoreCertificateErrors) {
            return;
        }
        if (!ignoreCertificateErrors) {
            GitLabApiClient.ignoreCertificateErrors = false;
            HttpsURLConnection.setDefaultSSLSocketFactory(defaultSocketFactory);
        } else {
            SSLSocketFactory defaultSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
            if (this.ignoreCertificateErrors()) {
                GitLabApiClient.ignoreCertificateErrors = true;
                GitLabApiClient.defaultSocketFactory = defaultSocketFactory;
            } else {
                throw new RuntimeException("Unable to ignore certificate errors.");
            }
        }
    }

    private boolean ignoreCertificateErrors() {
        TrustManager[] certs = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        SSLSocketFactory defaultSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, certs, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            HttpsURLConnection.getDefaultSSLSocketFactory();
        }
        catch (GeneralSecurityException ex) {
            HttpsURLConnection.setDefaultSSLSocketFactory(defaultSocketFactory);
            return false;
        }
        return true;
    }

    protected URL getApiUrl(Object ... pathArgs) throws IOException {
        StringBuilder url = new StringBuilder();
        url.append(this.hostUrl);
        for (Object pathArg : pathArgs) {
            if (pathArg == null) continue;
            url.append("/");
            url.append(pathArg.toString());
        }
        return new URL(url.toString());
    }

    protected boolean validateSecretToken(Response response) {
        if (this.secretToken == null) {
            return true;
        }
        String secretToken = response.getHeaderString(X_GITLAB_TOKEN_HEADER);
        if (secretToken == null) {
            return false;
        }
        return this.secretToken.equals(secretToken);
    }

    protected Response get(MultivaluedMap<String, String> queryParams, Object ... pathArgs) throws IOException {
        URL url = this.getApiUrl(pathArgs);
        return this.get(queryParams, url);
    }

    protected Response get(MultivaluedMap<String, String> queryParams, URL url) {
        return this.invocation(url, queryParams).get();
    }

    protected Response post(Form formData, Object ... pathArgs) throws IOException {
        URL url = this.getApiUrl(pathArgs);
        return this.post(formData, url);
    }

    protected Response post(MultivaluedMap<String, String> queryParams, Object ... pathArgs) throws IOException {
        URL url = this.getApiUrl(pathArgs);
        return this.post(queryParams, url);
    }

    protected Response post(Form formData, URL url) {
        if (formData instanceof GitLabApiForm) {
            return this.invocation(url, null).post(Entity.entity((Object)formData.asMap(), (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        }
        return this.invocation(url, null).post(Entity.entity((Object)formData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
    }

    protected Response post(MultivaluedMap<String, String> queryParams, URL url) {
        return this.invocation(url, queryParams).post(null);
    }

    protected Response put(MultivaluedMap<String, String> queryParams, Object ... pathArgs) throws IOException {
        URL url = this.getApiUrl(pathArgs);
        return this.put(queryParams, url);
    }

    protected Response put(MultivaluedMap<String, String> queryParams, URL url) {
        return this.invocation(url, null).put(Entity.entity(queryParams, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
    }

    protected Response delete(MultivaluedMap<String, String> queryParams, Object ... pathArgs) throws IOException {
        return this.delete(queryParams, this.getApiUrl(pathArgs));
    }

    protected Response delete(MultivaluedMap<String, String> queryParams, URL url) {
        return this.invocation(url, queryParams).delete();
    }

    protected Invocation.Builder invocation(URL url, MultivaluedMap<String, String> queryParams) {
        if (this.apiClient == null) {
            this.apiClient = ClientBuilder.newBuilder().withConfig((Configuration)this.clientConfig).sslContext(this.getSslContext()).hostnameVerifier((HostnameVerifier)new AcceptAllHostnameVerifier()).build();
        }
        WebTarget target = (WebTarget)this.apiClient.target(url.toExternalForm()).property("jersey.config.client.followRedirects", (Object)true);
        if (queryParams != null) {
            for (Map.Entry param : queryParams.entrySet()) {
                target = target.queryParam((String)param.getKey(), ((List)param.getValue()).toArray());
            }
        }
        return target.request().header(PRIVATE_TOKEN_HEADER, (Object)this.privateToken).accept(new String[]{"application/json"});
    }

    private SSLContext getSslContext() {
        try {
            return SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    protected class AcceptAllHostnameVerifier
    implements HostnameVerifier {
        protected AcceptAllHostnameVerifier() {
        }

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    }
}

