/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.net.URL;
import java.net.URLEncoder;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiClient;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;

public abstract class AbstractApi
implements Constants {
    private GitLabApi gitLabApi;

    public AbstractApi(GitLabApi gitLabApi) {
        this.gitLabApi = gitLabApi;
    }

    protected GitLabApi.ApiVersion getApiVersion() {
        return this.gitLabApi.getApiVersion();
    }

    protected boolean isApiVersion(GitLabApi.ApiVersion apiVersion) {
        return this.gitLabApi.getApiVersion() == apiVersion;
    }

    protected int getDefaultPerPage() {
        return this.gitLabApi.getDefaultPerPage();
    }

    protected GitLabApiClient getApiClient() {
        return this.gitLabApi.getApiClient();
    }

    protected String urlEncode(String s) throws GitLabApiException {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (Exception e) {
            throw new GitLabApiException(e);
        }
    }

    protected Response get(Response.Status expectedStatus, MultivaluedMap<String, String> queryParams, Object ... pathArgs) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().get(queryParams, pathArgs), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response get(Response.Status expectedStatus, MultivaluedMap<String, String> queryParams, URL url) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().get(queryParams, url), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response post(Response.Status expectedStatus, Form formData, Object ... pathArgs) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().post(formData, pathArgs), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response post(Response.Status expectedStatus, MultivaluedMap<String, String> queryParams, Object ... pathArgs) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().post(queryParams, pathArgs), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response post(Response.Status expectedStatus, Form formData, URL url) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().post(formData, url), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response put(Response.Status expectedStatus, MultivaluedMap<String, String> queryParams, Object ... pathArgs) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().put(queryParams, pathArgs), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response put(Response.Status expectedStatus, MultivaluedMap<String, String> queryParams, URL url) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().put(queryParams, url), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response delete(Response.Status expectedStatus, MultivaluedMap<String, String> queryParams, Object ... pathArgs) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().delete(queryParams, pathArgs), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected Response delete(Response.Status expectedStatus, MultivaluedMap<String, String> queryParams, URL url) throws GitLabApiException {
        try {
            return this.validate(this.getApiClient().delete(queryParams, url), expectedStatus);
        }
        catch (Exception e) {
            throw this.handle(e);
        }
    }

    protected void addFormParam(Form formData, String name, Object value) throws IllegalArgumentException {
        this.addFormParam(formData, name, value, false);
    }

    protected void addFormParam(Form formData, String name, Object value, boolean required) throws IllegalArgumentException {
        if (value == null) {
            if (required) {
                throw new IllegalArgumentException(name + " cannot be empty or null");
            }
            return;
        }
        String stringValue = value.toString().trim();
        if (required && stringValue.length() == 0) {
            throw new IllegalArgumentException(name + " cannot be empty or null");
        }
        formData.param(name, stringValue);
    }

    protected Response validate(Response response, Response.Status expected) throws GitLabApiException {
        if (response.getStatus() != expected.getStatusCode()) {
            throw new GitLabApiException(response);
        }
        if (!this.getApiClient().validateSecretToken(response)) {
            throw new GitLabApiException((Exception)new NotAuthorizedException((Object)"Invalid secret token in response.", new Object[0]));
        }
        return response;
    }

    protected GitLabApiException handle(Exception thrown) {
        if (thrown instanceof GitLabApiException) {
            return (GitLabApiException)thrown;
        }
        return new GitLabApiException(thrown);
    }

    protected MultivaluedMap<String, String> getPageQueryParams(int page, int perPage) {
        return new GitLabApiForm().withParam("page", page).withParam("per_page", perPage).asMap();
    }

    protected MultivaluedMap<String, String> getDefaultPerPageParam() {
        return new GitLabApiForm().withParam("per_page", this.getDefaultPerPage()).asMap();
    }
}

