/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.AccessLevel;
import org.gitlab4j.api.models.AllowedTo;
import org.gitlab4j.api.models.ProtectedBranch;

public class ProtectedBranchesApi
extends AbstractApi {
    public ProtectedBranchesApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<ProtectedBranch> getProtectedBranches(Object projectIdOrPath) throws GitLabApiException {
        return this.getProtectedBranches(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public Pager<ProtectedBranch> getProtectedBranches(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<ProtectedBranch>(this, ProtectedBranch.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "protected_branches");
    }

    public Stream<ProtectedBranch> getProtectedBranchesStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getProtectedBranches(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public ProtectedBranch getProtectedBranch(Object projectIdOrPath, String branchName) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "protected_branches", this.urlEncode(branchName));
        return (ProtectedBranch)response.readEntity(ProtectedBranch.class);
    }

    public Optional<ProtectedBranch> getOptionalProtectedBranch(Object projectIdOrPath, String branchName) {
        try {
            return Optional.ofNullable(this.getProtectedBranch(projectIdOrPath, branchName));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public void unprotectBranch(Object projectIdOrPath, String branchName) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "protected_branches", this.urlEncode(branchName));
    }

    public ProtectedBranch protectBranch(Object projectIdOrPath, String branchName) throws GitLabApiException {
        return this.protectBranch(projectIdOrPath, branchName, AccessLevel.MAINTAINER, AccessLevel.MAINTAINER);
    }

    public ProtectedBranch protectBranch(Object projectIdOrPath, String branchName, AccessLevel pushAccessLevel, AccessLevel mergeAccessLevel) throws GitLabApiException {
        return this.protectBranch(projectIdOrPath, branchName, pushAccessLevel, mergeAccessLevel, null, null);
    }

    public ProtectedBranch protectBranch(Object projectIdOrPath, String branchName, AccessLevel pushAccessLevel, AccessLevel mergeAccessLevel, AccessLevel unprotectAccessLevel, Boolean codeOwnerApprovalRequired) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", branchName, true).withParam("push_access_level", pushAccessLevel).withParam("merge_access_level", mergeAccessLevel).withParam("unprotect_access_level", unprotectAccessLevel).withParam("code_owner_approval_required", codeOwnerApprovalRequired);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "protected_branches"});
        return (ProtectedBranch)response.readEntity(ProtectedBranch.class);
    }

    public ProtectedBranch protectBranch(Object projectIdOrPath, String branchName, Integer allowedToPush, Integer allowedToMerge, Integer allowedToUnprotect, Boolean codeOwnerApprovalRequired) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", branchName, true).withParam("allowed_to_push[][user_id]", allowedToPush).withParam("allowed_to_merge[][user_id]", allowedToMerge).withParam("allowed_to_merge[][user_id]", allowedToUnprotect).withParam("code_owner_approval_required", codeOwnerApprovalRequired);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "protected_branches"});
        return (ProtectedBranch)response.readEntity(ProtectedBranch.class);
    }

    public ProtectedBranch protectBranch(Object projectIdOrPath, String branchName, AllowedTo allowedToPush, AllowedTo allowedToMerge, AllowedTo allowedToUnprotect, Boolean codeOwnerApprovalRequired) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", branchName, true).withParam("code_owner_approval_required", codeOwnerApprovalRequired);
        if (allowedToPush != null) {
            allowedToPush.getForm(formData, "allowed_to_push");
        }
        if (allowedToMerge != null) {
            allowedToMerge.getForm(formData, "allowed_to_merge");
        }
        if (allowedToUnprotect != null) {
            allowedToUnprotect.getForm(formData, "allowed_to_unprotect");
        }
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "protected_branches"});
        return (ProtectedBranch)response.readEntity(ProtectedBranch.class);
    }
}

