/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Branch;
import org.gitlab4j.api.models.Commit;
import org.gitlab4j.api.models.CompareResults;
import org.gitlab4j.api.models.Contributor;
import org.gitlab4j.api.models.TreeItem;
import org.gitlab4j.api.utils.FileUtils;

public class RepositoryApi
extends AbstractApi {
    public RepositoryApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Branch> getBranches(Object projectIdOrPath) throws GitLabApiException {
        return this.getBranches(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Branch> getBranches(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "branches");
        return (List)response.readEntity((GenericType)new GenericType<List<Branch>>(){});
    }

    public Pager<Branch> getBranches(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Branch>(this, Branch.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "branches");
    }

    public Stream<Branch> getBranchesStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getBranches(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Branch getBranch(Object projectIdOrPath, String branchName) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "branches", this.urlEncode(branchName));
        return (Branch)response.readEntity(Branch.class);
    }

    public Optional<Branch> getOptionalBranch(Object projectIdOrPath, String branchName) throws GitLabApiException {
        try {
            return Optional.ofNullable(this.getBranch(projectIdOrPath, branchName));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Branch createBranch(Object projectIdOrPath, String branchName, String ref) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam(this.isApiVersion(GitLabApi.ApiVersion.V3) ? "branch_name" : "branch", branchName, true).withParam("ref", ref, true);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "branches"});
        return (Branch)response.readEntity(Branch.class);
    }

    public void deleteBranch(Object projectIdOrPath, String branchName) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "branches", this.urlEncode(branchName));
    }

    public Branch protectBranch(Object projectIdOrPath, String branchName) throws GitLabApiException {
        Response response = this.put(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "branches", this.urlEncode(branchName), "protect");
        return (Branch)response.readEntity(Branch.class);
    }

    public Branch unprotectBranch(Object projectIdOrPath, String branchName) throws GitLabApiException {
        Response response = this.put(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "branches", this.urlEncode(branchName), "unprotect");
        return (Branch)response.readEntity(Branch.class);
    }

    public List<TreeItem> getTree(Object projectIdOrPath) throws GitLabApiException {
        return this.getTree(projectIdOrPath, "/", "master");
    }

    public Pager<TreeItem> getTree(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return this.getTree(projectIdOrPath, "/", "master", false, itemsPerPage);
    }

    public Stream<TreeItem> getTreeStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getTreeStream(projectIdOrPath, "/", "master");
    }

    public List<TreeItem> getTree(Object projectIdOrPath, String filePath, String refName) throws GitLabApiException {
        return this.getTree(projectIdOrPath, filePath, refName, false);
    }

    public Pager<TreeItem> getTree(Object projectIdOrPath, String filePath, String refName, int itemsPerPage) throws GitLabApiException {
        return this.getTree(projectIdOrPath, filePath, refName, false, itemsPerPage);
    }

    public Stream<TreeItem> getTreeStream(Object projectIdOrPath, String filePath, String refName) throws GitLabApiException {
        return this.getTreeStream(projectIdOrPath, filePath, refName, false);
    }

    public List<TreeItem> getTree(Object projectIdOrPath, String filePath, String refName, Boolean recursive) throws GitLabApiException {
        return this.getTree(projectIdOrPath, filePath, refName, recursive, this.getDefaultPerPage()).all();
    }

    public Pager<TreeItem> getTree(Object projectIdOrPath, String filePath, String refName, Boolean recursive, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("id", this.getProjectIdOrPath(projectIdOrPath), true).withParam("path", filePath, false).withParam(this.isApiVersion(GitLabApi.ApiVersion.V3) ? "ref_name" : "ref", refName, false).withParam("recursive", recursive, false);
        return new Pager<TreeItem>(this, TreeItem.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "tree");
    }

    public Stream<TreeItem> getTreeStream(Object projectIdOrPath, String filePath, String refName, Boolean recursive) throws GitLabApiException {
        return this.getTree(projectIdOrPath, filePath, refName, recursive, this.getDefaultPerPage()).stream();
    }

    public InputStream getRawBlobContent(Object projectIdOrPath, String sha) throws GitLabApiException {
        Response response = this.getWithAccepts(Response.Status.OK, null, "*", "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "blobs", sha, "raw");
        return (InputStream)response.readEntity(InputStream.class);
    }

    public InputStream getRepositoryArchive(Object projectIdOrPath, String sha) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("sha", sha);
        Response response = this.getWithAccepts(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "*", "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "archive");
        return (InputStream)response.readEntity(InputStream.class);
    }

    public InputStream getRepositoryArchive(Object projectIdOrPath, String sha, String format) throws GitLabApiException {
        Constants.ArchiveFormat archiveFormat = Constants.ArchiveFormat.forValue(format);
        return this.getRepositoryArchive(projectIdOrPath, sha, archiveFormat);
    }

    public InputStream getRepositoryArchive(Object projectIdOrPath, String sha, Constants.ArchiveFormat format) throws GitLabApiException {
        if (format == null) {
            format = Constants.ArchiveFormat.TAR_GZ;
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("sha", sha);
        Response response = this.getWithAccepts(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "*", "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "archive." + format.toString());
        return (InputStream)response.readEntity(InputStream.class);
    }

    public File getRepositoryArchive(Object projectIdOrPath, String sha, File directory) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("sha", sha);
        Response response = this.getWithAccepts(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "*", "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "archive");
        try {
            if (directory == null) {
                directory = new File(System.getProperty("java.io.tmpdir"));
            }
            String filename = FileUtils.getFilenameFromContentDisposition(response);
            File file = new File(directory, filename);
            InputStream in = (InputStream)response.readEntity(InputStream.class);
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
    }

    public File getRepositoryArchive(Object projectIdOrPath, String sha, File directory, String format) throws GitLabApiException {
        Constants.ArchiveFormat archiveFormat = Constants.ArchiveFormat.forValue(format);
        return this.getRepositoryArchive(projectIdOrPath, sha, directory, archiveFormat);
    }

    public File getRepositoryArchive(Object projectIdOrPath, String sha, File directory, Constants.ArchiveFormat format) throws GitLabApiException {
        if (format == null) {
            format = Constants.ArchiveFormat.TAR_GZ;
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("sha", sha);
        Response response = this.getWithAccepts(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "*", "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "archive." + format.toString());
        try {
            if (directory == null) {
                directory = new File(System.getProperty("java.io.tmpdir"));
            }
            String filename = FileUtils.getFilenameFromContentDisposition(response);
            File file = new File(directory, filename);
            InputStream in = (InputStream)response.readEntity(InputStream.class);
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
    }

    public CompareResults compare(Object projectIdOrPath, String from, String to, boolean straight) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("from", from, true).withParam("to", to, true).withParam("straight", straight);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "compare");
        return (CompareResults)response.readEntity(CompareResults.class);
    }

    public CompareResults compare(Object projectIdOrPath, String from, String to) throws GitLabApiException {
        return this.compare(projectIdOrPath, from, to, false);
    }

    public List<Contributor> getContributors(Object projectIdOrPath) throws GitLabApiException {
        return this.getContributors(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Contributor> getContributors(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "contributors");
        return (List)response.readEntity((GenericType)new GenericType<List<Contributor>>(){});
    }

    public Pager<Contributor> getContributors(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Contributor>(this, Contributor.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "contributors");
    }

    public Stream<Contributor> getContributorsStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getContributors(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Commit getMergeBase(Object projectIdOrPath, List<String> refs) throws GitLabApiException {
        GitLabApiForm queryParams = new GitLabApiForm().withParam("refs", refs, true);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)queryParams.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "merge_base");
        return (Commit)response.readEntity(Commit.class);
    }

    public Optional<Commit> getOptionalMergeBase(Object projectIdOrPath, List<String> refs) throws GitLabApiException {
        try {
            return Optional.ofNullable(this.getMergeBase(projectIdOrPath, refs));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public void deleteMergedBranches(Object projectIdOrPath) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "merged_branches");
    }
}

