/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Issue;
import org.gitlab4j.api.models.MergeRequest;
import org.gitlab4j.api.models.Milestone;

public class MilestonesApi
extends AbstractApi {
    public MilestonesApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Milestone> getGroupMilestones(Object groupIdOrPath) throws GitLabApiException {
        return this.getGroupMilestones(groupIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Milestone> getGroupMilestones(Object groupIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "groups", this.getGroupIdOrPath(groupIdOrPath), "milestones");
        return (List)response.readEntity((GenericType)new GenericType<List<Milestone>>(){});
    }

    public Pager<Milestone> getGroupMilestones(Object groupIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Milestone>(this, Milestone.class, itemsPerPage, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "milestones");
    }

    public Stream<Milestone> getGroupMilestonesStream(Object groupIdOrPath) throws GitLabApiException {
        return this.getGroupMilestones(groupIdOrPath, this.getDefaultPerPage()).stream();
    }

    public List<Milestone> getGroupMilestones(Object groupIdOrPath, Constants.MilestoneState state) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("state", (Object)state).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "milestones");
        return (List)response.readEntity((GenericType)new GenericType<List<Milestone>>(){});
    }

    public List<Milestone> getGroupMilestones(Object groupIdOrPath, String search) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("search", search).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "milestones");
        return (List)response.readEntity((GenericType)new GenericType<List<Milestone>>(){});
    }

    public List<Milestone> getGroupMilestones(Object groupIdOrPath, Constants.MilestoneState state, String search) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("state", (Object)state).withParam("search", search).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "milestones");
        return (List)response.readEntity((GenericType)new GenericType<List<Milestone>>(){});
    }

    public Milestone getGroupMilestone(Object groupIdOrPath, Integer milestoneId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "groups", this.getGroupIdOrPath(groupIdOrPath), "milestones", milestoneId);
        return (Milestone)response.readEntity(Milestone.class);
    }

    public List<Issue> getGroupIssues(Object groupIdOrPath, Integer milestoneId) throws GitLabApiException {
        return this.getGroupIssues(groupIdOrPath, milestoneId, this.getDefaultPerPage()).all();
    }

    public Pager<Issue> getGroupIssues(Object groupIdOrPath, Integer milestoneId, int itemsPerPage) throws GitLabApiException {
        return new Pager<Issue>(this, Issue.class, itemsPerPage, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "milestones", milestoneId, "issues");
    }

    public Stream<Issue> getGroupIssuesStream(Object groupIdOrPath, Integer milestoneId) throws GitLabApiException {
        return this.getGroupIssues(groupIdOrPath, milestoneId, this.getDefaultPerPage()).stream();
    }

    public List<MergeRequest> getGroupMergeRequest(Object groupIdOrPath, Integer milestoneId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "groups", this.getGroupIdOrPath(groupIdOrPath), "milestones", milestoneId, "merge_requests");
        return (List)response.readEntity((GenericType)new GenericType<List<MergeRequest>>(){});
    }

    public Milestone createGroupMilestone(Object groupIdOrPath, String title, String description, Date dueDate, Date startDate) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title, true).withParam("description", description).withParam("due_date", dueDate).withParam("start_date", startDate);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"groups", this.getGroupIdOrPath(groupIdOrPath), "milestones"});
        return (Milestone)response.readEntity(Milestone.class);
    }

    public Milestone closeGroupMilestone(Object groupIdOrPath, Integer milestoneId) throws GitLabApiException {
        if (milestoneId == null) {
            throw new RuntimeException("milestoneId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("state_event", (Object)Constants.MilestoneState.CLOSE);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "milestones", milestoneId);
        return (Milestone)response.readEntity(Milestone.class);
    }

    public Milestone activateGroupMilestone(Object groupIdOrPath, Integer milestoneId) throws GitLabApiException {
        if (milestoneId == null) {
            throw new RuntimeException("milestoneId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("state_event", (Object)Constants.MilestoneState.ACTIVATE);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "milestones", milestoneId);
        return (Milestone)response.readEntity(Milestone.class);
    }

    public Milestone updateGroupMilestone(Object groupIdOrPath, Integer milestoneId, String title, String description, Date dueDate, Date startDate, Constants.MilestoneState milestoneState) throws GitLabApiException {
        if (milestoneId == null) {
            throw new RuntimeException("milestoneId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title, true).withParam("description", description).withParam("due_date", dueDate).withParam("start_date", startDate).withParam("state_event", (Object)milestoneState);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "milestones", milestoneId);
        return (Milestone)response.readEntity(Milestone.class);
    }

    public List<Milestone> getMilestones(Object projectIdOrPath) throws GitLabApiException {
        return this.getMilestones(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Milestone> getMilestones(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "milestones");
        return (List)response.readEntity((GenericType)new GenericType<List<Milestone>>(){});
    }

    public Pager<Milestone> getMilestones(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Milestone>(this, Milestone.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "milestones");
    }

    public Stream<Milestone> getMilestonesStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getMilestones(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public List<Milestone> getMilestones(Object projectIdOrPath, Constants.MilestoneState state) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("state", (Object)state).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "milestones");
        return (List)response.readEntity((GenericType)new GenericType<List<Milestone>>(){});
    }

    public List<Milestone> getMilestones(Object projectIdOrPath, String search) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("search", search).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "milestones");
        return (List)response.readEntity((GenericType)new GenericType<List<Milestone>>(){});
    }

    public List<Milestone> getMilestones(Object projectIdOrPath, Constants.MilestoneState state, String search) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("state", (Object)state).withParam("search", search).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "milestones");
        return (List)response.readEntity((GenericType)new GenericType<List<Milestone>>(){});
    }

    public Milestone getMilestone(Object projectIdOrPath, Integer milestoneId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "milestones", milestoneId);
        return (Milestone)response.readEntity(Milestone.class);
    }

    public List<Issue> getIssues(Object projectIdOrPath, Integer milestoneId) throws GitLabApiException {
        return this.getIssues(projectIdOrPath, milestoneId, this.getDefaultPerPage()).all();
    }

    public Pager<Issue> getIssues(Object projectIdOrPath, Integer milestoneId, int itemsPerPage) throws GitLabApiException {
        return new Pager<Issue>(this, Issue.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "milestones", milestoneId, "issues");
    }

    public Stream<Issue> getIssuesStream(Object projectIdOrPath, Integer milestoneId) throws GitLabApiException {
        return this.getIssues(projectIdOrPath, milestoneId, this.getDefaultPerPage()).stream();
    }

    public List<MergeRequest> getMergeRequest(Object projectIdOrPath, Integer milestoneId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "milestones", milestoneId, "merge_requests");
        return (List)response.readEntity((GenericType)new GenericType<List<MergeRequest>>(){});
    }

    public Milestone createMilestone(Object projectIdOrPath, String title, String description, Date dueDate, Date startDate) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title, true).withParam("description", description).withParam("due_date", dueDate).withParam("start_date", startDate);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "milestones"});
        return (Milestone)response.readEntity(Milestone.class);
    }

    public Milestone closeMilestone(Object projectIdOrPath, Integer milestoneId) throws GitLabApiException {
        if (milestoneId == null) {
            throw new RuntimeException("milestoneId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("state_event", (Object)Constants.MilestoneState.CLOSE);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "milestones", milestoneId);
        return (Milestone)response.readEntity(Milestone.class);
    }

    public Milestone activateMilestone(Object projectIdOrPath, Integer milestoneId) throws GitLabApiException {
        if (milestoneId == null) {
            throw new RuntimeException("milestoneId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("state_event", (Object)Constants.MilestoneState.ACTIVATE);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "milestones", milestoneId);
        return (Milestone)response.readEntity(Milestone.class);
    }

    public Milestone updateMilestone(Object projectIdOrPath, Integer milestoneId, String title, String description, Date dueDate, Date startDate, Constants.MilestoneState milestoneState) throws GitLabApiException {
        if (milestoneId == null) {
            throw new RuntimeException("milestoneId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title, true).withParam("description", description).withParam("due_date", dueDate).withParam("start_date", startDate).withParam("state_event", (Object)milestoneState);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "milestones", milestoneId);
        return (Milestone)response.readEntity(Milestone.class);
    }
}

