/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.ws.rs.Produces;
import javax.ws.rs.ext.ContextResolver;
import org.gitlab4j.api.models.User;
import org.gitlab4j.api.utils.ISO8601;

@Produces(value={"application/json"})
public class JacksonJson
extends JacksonJaxbJsonProvider
implements ContextResolver<ObjectMapper> {
    private static final SimpleDateFormat iso8601UtcFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss 'UTC'");
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JacksonJson() {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        this.objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.objectMapper.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.configure(DeserializationFeature.READ_ENUMS_USING_TO_STRING, true);
        SimpleModule module = new SimpleModule("GitLabApiJsonModule");
        module.addSerializer(Date.class, (JsonSerializer)new JsonDateSerializer());
        module.addDeserializer(Date.class, (JsonDeserializer)new JsonDateDeserializer());
        this.objectMapper.registerModule((Module)module);
        this.setMapper(this.objectMapper);
    }

    public ObjectMapper getContext(Class<?> objectType) {
        return this.objectMapper;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public JsonNode readTree(String postData) throws JsonParseException, JsonMappingException, IOException {
        return this.objectMapper.readTree(postData);
    }

    public JsonNode readTree(Reader reader) throws JsonParseException, JsonMappingException, IOException {
        return this.objectMapper.readTree(reader);
    }

    public <T> T unmarshal(Class<T> returnType, JsonNode tree) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper objectMapper = this.getContext(returnType);
        return (T)objectMapper.treeToValue((TreeNode)tree, returnType);
    }

    public <T> T unmarshal(Class<T> returnType, Reader reader) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper objectMapper = this.getContext(returnType);
        return (T)objectMapper.readValue(reader, returnType);
    }

    public <T> T unmarshal(Class<T> returnType, String postData) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper objectMapper = this.getContext(returnType);
        return (T)objectMapper.readValue(postData, returnType);
    }

    public <T> List<T> unmarshalList(Class<T> returnType, Reader reader) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper objectMapper = this.getContext(null);
        CollectionType javaType = objectMapper.getTypeFactory().constructCollectionType(List.class, returnType);
        return (List)objectMapper.readValue(reader, (JavaType)javaType);
    }

    public <T> List<T> unmarshalList(Class<T> returnType, String postData) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper objectMapper = this.getContext(null);
        CollectionType javaType = objectMapper.getTypeFactory().constructCollectionType(List.class, returnType);
        return (List)objectMapper.readValue(postData, (JavaType)javaType);
    }

    public <T> Map<String, T> unmarshalMap(Class<T> returnType, Reader reader) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper objectMapper = this.getContext(null);
        return (Map)objectMapper.readValue(reader, new TypeReference<Map<String, T>>(){});
    }

    public <T> Map<String, T> unmarshalMap(Class<T> returnType, String jsonData) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper objectMapper = this.getContext(null);
        return (Map)objectMapper.readValue(jsonData, new TypeReference<Map<String, T>>(){});
    }

    public <T> String marshal(T object) {
        if (object == null) {
            throw new IllegalArgumentException("object parameter is null");
        }
        ObjectWriter writer = this.objectMapper.writer().withDefaultPrettyPrinter();
        String results = null;
        try {
            results = writer.writeValueAsString(object);
        }
        catch (JsonGenerationException e) {
            System.err.println("JsonGenerationException, message=" + e.getMessage());
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
            System.err.println("JsonMappingException, message=" + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("IOException, message=" + e.getMessage());
        }
        return results;
    }

    public static <T> String toJsonString(T object) {
        return JacksonJsonSingletonHelper.JACKSON_JSON.marshal(object);
    }

    public static JsonNode toJsonNode(String jsonString) throws IOException {
        return JacksonJsonSingletonHelper.JACKSON_JSON.objectMapper.readTree(jsonString);
    }

    static {
        iso8601UtcFormat.setLenient(true);
        iso8601UtcFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    private static class JacksonJsonSingletonHelper {
        private static final JacksonJson JACKSON_JSON = new JacksonJson();

        private JacksonJsonSingletonHelper() {
        }

        static {
            JACKSON_JSON.objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.LOWER_CAMEL_CASE);
            JACKSON_JSON.objectMapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        }
    }

    public static class UserListDeserializer
    extends JsonDeserializer<List<User>> {
        private static final ObjectMapper mapper = new JacksonJson().getObjectMapper();

        public List<User> deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JsonProcessingException {
            JsonNode tree = (JsonNode)jsonParser.readValueAsTree();
            int numUsers = tree.size();
            ArrayList<User> users = new ArrayList<User>(numUsers);
            for (int i = 0; i < numUsers; ++i) {
                JsonNode node = tree.get(i);
                JsonNode userNode = node.get("user");
                User user = (User)mapper.treeToValue((TreeNode)userNode, User.class);
                users.add(user);
            }
            return users;
        }
    }

    public static class UserListSerializer
    extends JsonSerializer<List<User>> {
        public void serialize(List<User> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartArray();
            for (User user : value) {
                jgen.writeStartObject();
                jgen.writeObjectField("user", (Object)user);
                jgen.writeEndObject();
            }
            jgen.writeEndArray();
        }
    }

    public static class JsonDateDeserializer
    extends JsonDeserializer<Date> {
        public Date deserialize(JsonParser jsonparser, DeserializationContext context) throws IOException, JsonProcessingException {
            try {
                return ISO8601.toDate(jsonparser.getText());
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class JsonDateSerializer
    extends JsonSerializer<Date> {
        public void serialize(Date date, JsonGenerator gen, SerializerProvider provider) throws IOException, JsonProcessingException {
            String iso8601String = ISO8601.toString(date);
            gen.writeString(iso8601String);
        }
    }

    public static class DateOnlySerializer
    extends JsonSerializer<Date> {
        public void serialize(Date date, JsonGenerator gen, SerializerProvider provider) throws IOException, JsonProcessingException {
            String dateString = ISO8601.dateOnly(date);
            gen.writeString(dateString);
        }
    }
}

