/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.AccessLevel;
import org.gitlab4j.api.models.Group;
import org.gitlab4j.api.models.GroupFilter;
import org.gitlab4j.api.models.GroupProjectsFilter;
import org.gitlab4j.api.models.Member;
import org.gitlab4j.api.models.Project;
import org.gitlab4j.api.models.Variable;
import org.gitlab4j.api.models.Visibility;

public class GroupApi
extends AbstractApi {
    public GroupApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Group> getGroups() throws GitLabApiException {
        return this.getGroups(this.getDefaultPerPage()).all();
    }

    public List<Group> getGroups(int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "groups");
        return (List)response.readEntity((GenericType)new GenericType<List<Group>>(){});
    }

    public Pager<Group> getGroups(int itemsPerPage) throws GitLabApiException {
        return new Pager<Group>(this, Group.class, itemsPerPage, null, "groups");
    }

    public Stream<Group> getGroupsStream() throws GitLabApiException {
        return this.getGroups(this.getDefaultPerPage()).stream();
    }

    public List<Group> getGroups(String search) throws GitLabApiException {
        return this.getGroups(search, this.getDefaultPerPage()).all();
    }

    public List<Group> getGroups(String search, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("search", search).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups");
        return (List)response.readEntity((GenericType)new GenericType<List<Group>>(){});
    }

    public Pager<Group> getGroups(String search, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("search", search);
        return new Pager<Group>(this, Group.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "groups");
    }

    public Stream<Group> getGroupsStream(String search) throws GitLabApiException {
        return this.getGroups(search, this.getDefaultPerPage()).stream();
    }

    public List<Group> getGroups(GroupFilter filter) throws GitLabApiException {
        return this.getGroups(filter, this.getDefaultPerPage()).all();
    }

    public Pager<Group> getGroups(GroupFilter filter, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = filter.getQueryParams();
        return new Pager<Group>(this, Group.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "groups");
    }

    public Stream<Group> getGroupsStream(GroupFilter filter) throws GitLabApiException {
        return this.getGroups(filter, this.getDefaultPerPage()).stream();
    }

    public List<Group> getSubGroups(Object groupIdOrPath) throws GitLabApiException {
        return this.getSubGroups(groupIdOrPath, this.getDefaultPerPage()).all();
    }

    public Pager<Group> getSubGroups(Object groupIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Group>(this, Group.class, itemsPerPage, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "subgroups");
    }

    public Stream<Group> getSubGroupsStream(Object groupIdOrPath) throws GitLabApiException {
        return this.getSubGroups(groupIdOrPath, this.getDefaultPerPage()).stream();
    }

    public List<Group> getSubGroups(Object groupIdOrPath, List<Integer> skipGroups, Boolean allAvailable, String search, Constants.GroupOrderBy orderBy, Constants.SortOrder sortOrder, Boolean statistics, Boolean owned) throws GitLabApiException {
        return this.getSubGroups(groupIdOrPath, skipGroups, allAvailable, search, orderBy, sortOrder, statistics, owned, this.getDefaultPerPage()).all();
    }

    public List<Group> getSubGroups(Object groupIdOrPath, List<Integer> skipGroups, Boolean allAvailable, String search, Constants.GroupOrderBy orderBy, Constants.SortOrder sortOrder, Boolean statistics, Boolean owned, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("skip_groups", skipGroups).withParam("all_available", allAvailable).withParam("search", search).withParam("order_by", (Object)orderBy).withParam("sort_order", (Object)sortOrder).withParam("statistics", statistics).withParam("owned", owned).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "subgroups");
        return (List)response.readEntity((GenericType)new GenericType<List<Group>>(){});
    }

    public Pager<Group> getSubGroups(Object groupIdOrPath, List<Integer> skipGroups, Boolean allAvailable, String search, Constants.GroupOrderBy orderBy, Constants.SortOrder sortOrder, Boolean statistics, Boolean owned, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("skip_groups", skipGroups).withParam("all_available", allAvailable).withParam("search", search).withParam("order_by", (Object)orderBy).withParam("sort_order", (Object)sortOrder).withParam("statistics", statistics).withParam("owned", owned);
        return new Pager<Group>(this, Group.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "subgroups");
    }

    public Stream<Group> getSubGroupsStream(Object groupIdOrPath, List<Integer> skipGroups, Boolean allAvailable, String search, Constants.GroupOrderBy orderBy, Constants.SortOrder sortOrder, Boolean statistics, Boolean owned) throws GitLabApiException {
        return this.getSubGroups(groupIdOrPath, skipGroups, allAvailable, search, orderBy, sortOrder, statistics, owned, this.getDefaultPerPage()).stream();
    }

    public List<Project> getProjects(Object groupIdOrPath, GroupProjectsFilter filter) throws GitLabApiException {
        return this.getProjects(groupIdOrPath, filter, this.getDefaultPerPage()).all();
    }

    public Pager<Project> getProjects(Object groupIdOrPath, GroupProjectsFilter filter, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = filter.getQueryParams();
        return new Pager<Project>(this, Project.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "projects");
    }

    public Stream<Project> getProjectsStream(Object groupIdOrPath, GroupProjectsFilter filter) throws GitLabApiException {
        return this.getProjects(groupIdOrPath, filter, this.getDefaultPerPage()).stream();
    }

    public List<Project> getProjects(Object groupIdOrPath) throws GitLabApiException {
        return this.getProjects(groupIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Project> getProjects(Object groupIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "groups", this.getGroupIdOrPath(groupIdOrPath), "projects");
        return (List)response.readEntity((GenericType)new GenericType<List<Project>>(){});
    }

    public Pager<Project> getProjects(Object groupIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Project>(this, Project.class, itemsPerPage, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "projects");
    }

    public Stream<Project> getProjectsStream(Object groupIdOrPath) throws GitLabApiException {
        return this.getProjects(groupIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Group getGroup(Object groupIdOrPath) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath));
        return (Group)response.readEntity(Group.class);
    }

    public Optional<Group> getOptionalGroup(Object groupIdOrPath) {
        try {
            return Optional.ofNullable(this.getGroup(groupIdOrPath));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Group addGroup(String name, String path) throws GitLabApiException {
        Form formData = new Form();
        formData.param("name", name);
        formData.param("path", path);
        Response response = this.post(Response.Status.CREATED, formData, new Object[]{"groups"});
        return (Group)response.readEntity(Group.class);
    }

    public Group addGroup(Group group) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", group.getName()).withParam("path", group.getPath()).withParam("description", group.getDescription()).withParam("visibility", (Object)group.getVisibility()).withParam("lfs_enabled", group.getLfsEnabled()).withParam("request_access_enabled", group.getRequestAccessEnabled()).withParam("parent_id", this.isApiVersion(GitLabApi.ApiVersion.V3) ? null : group.getParentId());
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"groups"});
        return (Group)response.readEntity(Group.class);
    }

    public Group addGroup(String name, String path, String description, Visibility visibility, Boolean lfsEnabled, Boolean requestAccessEnabled, Integer parentId) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name).withParam("path", path).withParam("description", description).withParam("visibility", (Object)visibility).withParam("lfs_enabled", lfsEnabled).withParam("request_access_enabled", requestAccessEnabled).withParam("parent_id", this.isApiVersion(GitLabApi.ApiVersion.V3) ? null : parentId);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"groups"});
        return (Group)response.readEntity(Group.class);
    }

    public Group updateGroup(Group group) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", group.getName()).withParam("path", group.getPath()).withParam("description", group.getDescription()).withParam("visibility", (Object)group.getVisibility()).withParam("lfs_enabled", group.getLfsEnabled()).withParam("request_access_enabled", group.getRequestAccessEnabled()).withParam("parent_id", this.isApiVersion(GitLabApi.ApiVersion.V3) ? null : group.getParentId());
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups", group.getId());
        return (Group)response.readEntity(Group.class);
    }

    public Group updateGroup(Object groupIdOrPath, String name, String path, String description, Visibility visibility, Boolean lfsEnabled, Boolean requestAccessEnabled, Integer parentId) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name).withParam("path", path).withParam("description", description).withParam("visibility", (Object)visibility).withParam("lfs_enabled", lfsEnabled).withParam("request_access_enabled", requestAccessEnabled).withParam("parent_id", this.isApiVersion(GitLabApi.ApiVersion.V3) ? null : parentId);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath));
        return (Group)response.readEntity(Group.class);
    }

    public Group addGroup(String name, String path, String description, Boolean membershipLock, Boolean shareWithGroupLock, Visibility visibility, Boolean lfsEnabled, Boolean requestAccessEnabled, Integer parentId, Integer sharedRunnersMinutesLimit) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name).withParam("path", path).withParam("description", description).withParam("membership_lock", membershipLock).withParam("share_with_group_lock", shareWithGroupLock).withParam("visibility", (Object)visibility).withParam("lfs_enabled", lfsEnabled).withParam("request_access_enabled", requestAccessEnabled).withParam("parent_id", parentId).withParam("shared_runners_minutes_limit", sharedRunnersMinutesLimit);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"groups"});
        return (Group)response.readEntity(Group.class);
    }

    public Group updateGroup(Object groupIdOrPath, String name, String path, String description, Boolean membershipLock, Boolean shareWithGroupLock, Visibility visibility, Boolean lfsEnabled, Boolean requestAccessEnabled, Integer parentId, Integer sharedRunnersMinutesLimit) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name).withParam("path", path).withParam("description", description).withParam("membership_lock", membershipLock).withParam("share_with_group_lock", shareWithGroupLock).withParam("visibility", (Object)visibility).withParam("lfs_enabled", lfsEnabled).withParam("request_access_enabled", requestAccessEnabled).withParam("parent_id", parentId).withParam("shared_runners_minutes_limit", sharedRunnersMinutesLimit);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath));
        return (Group)response.readEntity(Group.class);
    }

    public void deleteGroup(Object groupIdOrPath) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "groups", this.getGroupIdOrPath(groupIdOrPath));
    }

    public List<Member> getMembers(Object groupIdOrPath) throws GitLabApiException {
        return this.getMembers(groupIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Member> getMembers(Object groupIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "groups", this.getGroupIdOrPath(groupIdOrPath), "members");
        return (List)response.readEntity((GenericType)new GenericType<List<Member>>(){});
    }

    public Pager<Member> getMembers(Object groupIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Member>(this, Member.class, itemsPerPage, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "members");
    }

    public Stream<Member> getMembersStream(Object groupIdOrPath) throws GitLabApiException {
        return this.getMembers(groupIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Member getMember(Object groupIdOrPath, int userId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "groups", this.getGroupIdOrPath(groupIdOrPath), "members", userId);
        return (Member)response.readEntity((GenericType)new GenericType<Member>(){});
    }

    public Optional<Member> getOptionalMember(Object groupIdOrPath, int userId) {
        try {
            return Optional.ofNullable(this.getMember(groupIdOrPath, userId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public List<Member> getAllMembers(Object groupIdOrPath) throws GitLabApiException {
        return this.getAllMembers(groupIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Member> getAllMembers(Object groupIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "groups", this.getGroupIdOrPath(groupIdOrPath), "members", "all");
        return (List)response.readEntity((GenericType)new GenericType<List<Member>>(){});
    }

    public Pager<Member> getAllMembers(Object groupIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Member>(this, Member.class, itemsPerPage, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "members", "all");
    }

    public Stream<Member> getAllMembersStream(Object groupIdOrPath) throws GitLabApiException {
        return this.getAllMembers(groupIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Member addMember(Object groupIdOrPath, Integer userId, Integer accessLevel) throws GitLabApiException {
        return this.addMember(groupIdOrPath, userId, accessLevel, null);
    }

    public Member addMember(Object groupIdOrPath, Integer userId, AccessLevel accessLevel) throws GitLabApiException {
        return this.addMember(groupIdOrPath, userId, accessLevel.toValue(), null);
    }

    public Member addMember(Object groupIdOrPath, Integer userId, AccessLevel accessLevel, Date expiresAt) throws GitLabApiException {
        return this.addMember(groupIdOrPath, userId, accessLevel.toValue(), expiresAt);
    }

    public Member addMember(Object groupIdOrPath, Integer userId, Integer accessLevel, Date expiresAt) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("user_id", userId, true).withParam("access_level", accessLevel, true).withParam("expires_at", expiresAt, false);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"groups", this.getGroupIdOrPath(groupIdOrPath), "members"});
        return (Member)response.readEntity(Member.class);
    }

    public Member updateMember(Object groupIdOrPath, Integer userId, Integer accessLevel) throws GitLabApiException {
        return this.updateMember(groupIdOrPath, userId, accessLevel, null);
    }

    public Member updateMember(Object groupIdOrPath, Integer userId, AccessLevel accessLevel) throws GitLabApiException {
        return this.updateMember(groupIdOrPath, userId, accessLevel.toValue(), null);
    }

    public Member updateMember(Object groupIdOrPath, Integer userId, AccessLevel accessLevel, Date expiresAt) throws GitLabApiException {
        return this.updateMember(groupIdOrPath, userId, accessLevel.toValue(), expiresAt);
    }

    public Member updateMember(Object groupIdOrPath, Integer userId, Integer accessLevel, Date expiresAt) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("access_level", accessLevel, true).withParam("expires_at", expiresAt, false);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "members", userId);
        return (Member)response.readEntity(Member.class);
    }

    public void removeMember(Object groupIdOrPath, Integer userId) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "members", userId);
    }

    public void ldapSync(Object groupIdOrPath) throws GitLabApiException {
        this.post(Response.Status.NO_CONTENT, (Form)null, new Object[]{"groups", this.getGroupIdOrPath(groupIdOrPath), "ldap_sync"});
    }

    public void addLdapGroupLink(Object groupIdOrPath, String cn, AccessLevel groupAccess, String provider) throws GitLabApiException {
        if (groupAccess == null) {
            throw new RuntimeException("groupAccess cannot be null or empty");
        }
        this.addLdapGroupLink(groupIdOrPath, cn, groupAccess.toValue(), provider);
    }

    public void addLdapGroupLink(Object groupIdOrPath, String cn, Integer groupAccess, String provider) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("cn", cn, true).withParam("group_access", groupAccess, true).withParam("provider", provider, true);
        this.post(Response.Status.CREATED, (Form)formData, new Object[]{"groups", this.getGroupIdOrPath(groupIdOrPath), "ldap_group_links"});
    }

    public void deleteLdapGroupLink(Object groupIdOrPath, String cn) throws GitLabApiException {
        if (cn == null || cn.trim().isEmpty()) {
            throw new RuntimeException("cn cannot be null or empty");
        }
        this.delete(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "ldap_group_links", cn);
    }

    public void deleteLdapGroupLink(Object groupIdOrPath, String cn, String provider) throws GitLabApiException {
        if (cn == null || cn.trim().isEmpty()) {
            throw new RuntimeException("cn cannot be null or empty");
        }
        if (provider == null || provider.trim().isEmpty()) {
            throw new RuntimeException("LDAP provider cannot be null or empty");
        }
        this.delete(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "ldap_group_links", provider, cn);
    }

    public List<Variable> getVariables(Object groupIdOrPath) throws GitLabApiException {
        return this.getVariables(groupIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Variable> getVariables(Object groupIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "groups", this.getGroupIdOrPath(groupIdOrPath), "variables");
        return (List)response.readEntity((GenericType)new GenericType<List<Variable>>(){});
    }

    public Pager<Variable> getVariables(Object groupIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Variable>(this, Variable.class, itemsPerPage, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "variables");
    }

    public Stream<Variable> getVariablesStream(Object groupIdOrPath) throws GitLabApiException {
        return this.getVariables(groupIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Variable getVariable(Object groupIdOrPath, String key) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "variables", key);
        return (Variable)response.readEntity(Variable.class);
    }

    public Optional<Variable> getOptionalVariable(Object groupIdOrPath, String key) {
        try {
            return Optional.ofNullable(this.getVariable(groupIdOrPath, key));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Variable createVariable(Object groupIdOrPath, String key, String value, Boolean isProtected) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("key", key, true).withParam("value", value, true).withParam("protected", isProtected);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"groups", this.getGroupIdOrPath(groupIdOrPath), "variables"});
        return (Variable)response.readEntity(Variable.class);
    }

    public Variable updateVariable(Object groupIdOrPath, String key, String value, Boolean isProtected) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("value", value, true).withParam("protected", isProtected);
        Response response = this.putWithFormData(Response.Status.CREATED, formData, "groups", this.getGroupIdOrPath(groupIdOrPath), "variables", key);
        return (Variable)response.readEntity(Variable.class);
    }

    public void deleteVariable(Object groupIdOrPath, String key) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "variables", key);
    }

    public Project transferProject(Object groupIdOrPath, Object projectIdOrPath) throws GitLabApiException {
        Response response = this.post(Response.Status.CREATED, (Form)null, new Object[]{"groups", this.getGroupIdOrPath(groupIdOrPath), "projects", this.getProjectIdOrPath(projectIdOrPath)});
        return (Project)response.readEntity(Project.class);
    }
}

