/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Note;

public class NotesApi
extends AbstractApi {
    public NotesApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    @Deprecated
    public List<Note> getNotes(Object projectIdOrPath, Integer issueIid) throws GitLabApiException {
        return this.getIssueNotes(projectIdOrPath, issueIid);
    }

    @Deprecated
    public List<Note> getNotes(Object projectIdOrPath, Integer issueIid, int page, int perPage) throws GitLabApiException {
        return this.getIssueNotes(projectIdOrPath, issueIid, page, perPage);
    }

    @Deprecated
    public Pager<Note> getNotes(Object projectIdOrPath, Integer issueIid, int itemsPerPage) throws GitLabApiException {
        return this.getIssueNotes(projectIdOrPath, issueIid, itemsPerPage);
    }

    public List<Note> getIssueNotes(Object projectIdOrPath, Integer issueIid) throws GitLabApiException {
        return this.getIssueNotes(projectIdOrPath, issueIid, this.getDefaultPerPage()).all();
    }

    public List<Note> getIssueNotes(Object projectIdOrPath, Integer issueIid, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "notes");
        return (List)response.readEntity((GenericType)new GenericType<List<Note>>(){});
    }

    public Pager<Note> getIssueNotes(Object projectIdOrPath, Integer issueIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<Note>(this, Note.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "notes");
    }

    public Stream<Note> getIssueNotesStream(Object projectIdOrPath, Integer issueIid) throws GitLabApiException {
        return this.getIssueNotes(projectIdOrPath, issueIid, this.getDefaultPerPage()).stream();
    }

    public Note getIssueNote(Object projectIdOrPath, Integer issueIid, Integer noteId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "notes", noteId);
        return (Note)response.readEntity(Note.class);
    }

    public Note createIssueNote(Object projectIdOrPath, Integer issueIid, String body) throws GitLabApiException {
        return this.createIssueNote(projectIdOrPath, issueIid, body, null);
    }

    public Note createIssueNote(Object projectIdOrPath, Integer issueIid, String body, Date createdAt) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("body", body, true).withParam("created_at", createdAt);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "notes"});
        return (Note)response.readEntity(Note.class);
    }

    public Note updateIssueNote(Object projectIdOrPath, Integer issueIid, Integer noteId, String body) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("body", body, true);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "notes", noteId);
        return (Note)response.readEntity(Note.class);
    }

    public void deleteIssueNote(Object projectIdOrPath, Integer issueIid, Integer noteId) throws GitLabApiException {
        if (issueIid == null) {
            throw new RuntimeException("issueIid cannot be null");
        }
        if (noteId == null) {
            throw new RuntimeException("noteId cannot be null");
        }
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "notes", noteId);
    }

    public List<Note> getMergeRequestNotes(Object projectIdOrPath, Integer mergeRequestIid) throws GitLabApiException {
        return this.getMergeRequestNotes(projectIdOrPath, mergeRequestIid, null, null, this.getDefaultPerPage()).all();
    }

    public List<Note> getMergeRequestNotes(Object projectIdOrPath, Integer mergeRequestIid, Constants.SortOrder sortOrder, Note.OrderBy orderBy) throws GitLabApiException {
        return this.getMergeRequestNotes(projectIdOrPath, mergeRequestIid, sortOrder, orderBy, this.getDefaultPerPage()).all();
    }

    public List<Note> getMergeRequestNotes(Object projectIdOrPath, Integer mergeRequestIid, int page, int perPage) throws GitLabApiException {
        return this.getMergeRequestNotes(projectIdOrPath, mergeRequestIid, null, null, page, perPage);
    }

    public List<Note> getMergeRequestNotes(Object projectIdOrPath, Integer mergeRequestIid, Constants.SortOrder sortOrder, Note.OrderBy orderBy, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("sort", (Object)sortOrder).withParam("order_by", (Object)orderBy).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "notes");
        return (List)response.readEntity((GenericType)new GenericType<List<Note>>(){});
    }

    public Pager<Note> getMergeRequestNotes(Object projectIdOrPath, Integer mergeRequestIid, int itemsPerPage) throws GitLabApiException {
        return this.getMergeRequestNotes(projectIdOrPath, mergeRequestIid, null, null, itemsPerPage);
    }

    public Stream<Note> getMergeRequestNotesStream(Object projectIdOrPath, Integer mergeRequestIid) throws GitLabApiException {
        return this.getMergeRequestNotes(projectIdOrPath, mergeRequestIid, null, null, this.getDefaultPerPage()).stream();
    }

    public Pager<Note> getMergeRequestNotes(Object projectIdOrPath, Integer mergeRequestIid, Constants.SortOrder sortOrder, Note.OrderBy orderBy, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("sort", (Object)sortOrder).withParam("order_by", (Object)orderBy).withParam("page", 1).withParam("per_page", itemsPerPage);
        return new Pager<Note>(this, Note.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "notes");
    }

    public Stream<Note> getMergeRequestNotesStream(Object projectIdOrPath, Integer mergeRequestIid, Constants.SortOrder sortOrder, Note.OrderBy orderBy) throws GitLabApiException {
        return this.getMergeRequestNotes(projectIdOrPath, mergeRequestIid, sortOrder, orderBy, this.getDefaultPerPage()).stream();
    }

    public Note getMergeRequestNote(Object projectIdOrPath, Integer mergeRequestIid, Integer noteId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "notes", noteId);
        return (Note)response.readEntity(Note.class);
    }

    public Note createMergeRequestNote(Object projectIdOrPath, Integer mergeRequestIid, String body) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("body", body, true);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "notes"});
        return (Note)response.readEntity(Note.class);
    }

    public Note updateMergeRequestNote(Object projectIdOrPath, Integer mergeRequestIid, Integer noteId, String body) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("body", body, true);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "notes", noteId);
        return (Note)response.readEntity(Note.class);
    }

    public void deleteMergeRequestNote(Object projectIdOrPath, Integer mergeRequestIid, Integer noteId) throws GitLabApiException {
        if (mergeRequestIid == null) {
            throw new RuntimeException("mergeRequestIid cannot be null");
        }
        if (noteId == null) {
            throw new RuntimeException("noteId cannot be null");
        }
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "notes", noteId);
    }
}

