/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum AccessLevel {
    NONE(0),
    GUEST(10),
    REPORTER(20),
    DEVELOPER(30),
    MASTER(40),
    OWNER(50);

    public final int value;
    private static Map<Integer, AccessLevel> valuesMap;

    private AccessLevel(int value) {
        this.value = value;
    }

    @JsonCreator
    public static AccessLevel forValue(Integer value) {
        return valuesMap.get(value);
    }

    @JsonValue
    public Integer toValue() {
        return this.value;
    }

    static {
        valuesMap = new HashMap<Integer, AccessLevel>(6);
        for (AccessLevel accessLevel : AccessLevel.values()) {
            valuesMap.put(accessLevel.value, accessLevel);
        }
    }
}

