/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.List;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.models.User;

public class UserApi
extends AbstractApi {
    UserApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<User> getUsers() throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "users");
        return (List)response.readEntity((GenericType)new GenericType<List<User>>(){});
    }

    public List<User> getUsers(int page, int perPage) throws GitLabApiException {
        Form formData = new Form();
        this.addFormParam(formData, "page", page, false);
        this.addFormParam(formData, "per_page", perPage, false);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users");
        return (List)response.readEntity((GenericType)new GenericType<List<User>>(){});
    }

    public User getUser(int userId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "users", userId);
        return (User)response.readEntity(User.class);
    }

    public List<User> findUsers(String emailOrUsername) throws GitLabApiException {
        Form formData = new Form();
        this.addFormParam(formData, "search", emailOrUsername, true);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users");
        return (List)response.readEntity((GenericType)new GenericType<List<User>>(){});
    }

    public User createUser(User user, String password, Integer projectsLimit) throws GitLabApiException {
        Form formData = this.user2form(user, projectsLimit, password, true);
        Response response = this.post(Response.Status.CREATED, formData, "users");
        return (User)response.readEntity(User.class);
    }

    public User modifyUser(User user, String password, Integer projectsLimit) throws GitLabApiException {
        Form form = this.user2form(user, projectsLimit, password, false);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)form.asMap(), "users", user.getId());
        return (User)response.readEntity(User.class);
    }

    public void deleteUser(Integer userId) throws GitLabApiException {
        if (userId == null) {
            throw new RuntimeException("userId cannot be null");
        }
        this.delete(Response.Status.OK, null, "users", userId);
    }

    public void deleteUser(User user) throws GitLabApiException {
        this.deleteUser(user.getId());
    }

    private Form user2form(User user, Integer projectsLimit, String password, boolean isCreate) {
        Form form = new Form();
        this.addFormParam(form, "email", user.getEmail(), isCreate);
        this.addFormParam(form, "password", password, isCreate);
        this.addFormParam(form, "username", user.getUsername(), isCreate);
        this.addFormParam(form, "name", user.getName(), isCreate);
        this.addFormParam(form, "skype", user.getSkype(), false);
        this.addFormParam(form, "linkedin", user.getLinkedin(), false);
        this.addFormParam(form, "twitter", user.getTwitter(), false);
        this.addFormParam(form, "website_url", user.getWebsiteUrl(), false);
        this.addFormParam(form, "projects_limit", projectsLimit, false);
        this.addFormParam(form, "external", user.getExternal(), false);
        this.addFormParam(form, "provider", user.getProvider(), false);
        this.addFormParam(form, "bio", user.getBio(), false);
        this.addFormParam(form, "location", user.getLocation(), false);
        this.addFormParam(form, "admin", user.getIsAdmin(), false);
        this.addFormParam(form, "can_create_group", user.getCanCreateGroup(), false);
        this.addFormParam(form, "external", user.getExternal(), false);
        return form;
    }
}

