/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import org.gitlab4j.api.CommitsApi;
import org.gitlab4j.api.GitLabApiClient;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GroupApi;
import org.gitlab4j.api.MergeRequestApi;
import org.gitlab4j.api.ProjectApi;
import org.gitlab4j.api.RepositoryApi;
import org.gitlab4j.api.RepositoryFileApi;
import org.gitlab4j.api.ServicesApi;
import org.gitlab4j.api.SessionApi;
import org.gitlab4j.api.UserApi;

public class GitLabApi {
    GitLabApiClient apiClient;
    private CommitsApi commitsApi;
    private GroupApi groupApi;
    private MergeRequestApi mergeRequestApi;
    private ProjectApi projectApi;
    private RepositoryApi repositoryApi;
    private RepositoryFileApi repositoryFileApi;
    private ServicesApi servicesApi;
    private SessionApi sessoinApi;
    private UserApi userApi;

    public static GitLabApi create(String url, String username, String password) throws GitLabApiException {
        String token = new SessionApi(new GitLabApi(url, null)).login(username, null, password).getPrivateToken();
        return new GitLabApi(url, token);
    }

    public GitLabApi(String hostUrl, String privateToken) {
        this(hostUrl, privateToken, null);
    }

    public GitLabApi(String hostUrl, String privateToken, String secretToken) {
        this.apiClient = new GitLabApiClient(hostUrl, privateToken, secretToken);
        this.commitsApi = new CommitsApi(this);
        this.groupApi = new GroupApi(this);
        this.mergeRequestApi = new MergeRequestApi(this);
        this.projectApi = new ProjectApi(this);
        this.repositoryApi = new RepositoryApi(this);
        this.servicesApi = new ServicesApi(this);
        this.sessoinApi = new SessionApi(this);
        this.userApi = new UserApi(this);
        this.repositoryFileApi = new RepositoryFileApi(this);
    }

    GitLabApiClient getApiClient() {
        return this.apiClient;
    }

    public CommitsApi getCommitsApi() {
        return this.commitsApi;
    }

    public MergeRequestApi getMergeRequestApi() {
        return this.mergeRequestApi;
    }

    public GroupApi getGroupApi() {
        return this.groupApi;
    }

    public ProjectApi getProjectApi() {
        return this.projectApi;
    }

    public RepositoryApi getRepositoryApi() {
        return this.repositoryApi;
    }

    public RepositoryFileApi getRepositoryFileApi() {
        return this.repositoryFileApi;
    }

    public ServicesApi getServicesApi() {
        return this.servicesApi;
    }

    public SessionApi getSessionApi() {
        return this.sessoinApi;
    }

    public UserApi getUserApi() {
        return this.userApi;
    }
}

