/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab.api;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import org.gitlab.api.TokenType;
import org.gitlab.api.http.GitlabHTTPRequestor;
import org.gitlab.api.http.Query;
import org.gitlab.api.models.GitlabAccessLevel;
import org.gitlab.api.models.GitlabBranch;
import org.gitlab.api.models.GitlabCommit;
import org.gitlab.api.models.GitlabCommitDiff;
import org.gitlab.api.models.GitlabCommitStatus;
import org.gitlab.api.models.GitlabGroup;
import org.gitlab.api.models.GitlabGroupMember;
import org.gitlab.api.models.GitlabIssue;
import org.gitlab.api.models.GitlabMergeRequest;
import org.gitlab.api.models.GitlabMilestone;
import org.gitlab.api.models.GitlabNamespace;
import org.gitlab.api.models.GitlabNote;
import org.gitlab.api.models.GitlabProject;
import org.gitlab.api.models.GitlabProjectHook;
import org.gitlab.api.models.GitlabProjectMember;
import org.gitlab.api.models.GitlabRepositoryTree;
import org.gitlab.api.models.GitlabSSHKey;
import org.gitlab.api.models.GitlabSession;
import org.gitlab.api.models.GitlabSystemHook;
import org.gitlab.api.models.GitlabUser;

public class GitlabAPI {
    public static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final String API_NAMESPACE = "/api/v3";
    private static final String PARAM_SUDO = "sudo";
    private final String hostUrl;
    private final String apiToken;
    private final TokenType tokenType;
    private boolean ignoreCertificateErrors = false;

    private GitlabAPI(String hostUrl, String apiToken, TokenType tokenType) {
        this.hostUrl = hostUrl.endsWith("/") ? hostUrl.replaceAll("/$", "") : hostUrl;
        this.apiToken = apiToken;
        this.tokenType = tokenType;
    }

    public static GitlabSession connect(String hostUrl, String username, String password) throws IOException {
        String tailUrl = "/session";
        GitlabAPI api = GitlabAPI.connect(hostUrl, null, (TokenType)null);
        return api.dispatch().with("login", username).with("password", password).to(tailUrl, GitlabSession.class);
    }

    public static GitlabAPI connect(String hostUrl, String apiToken) {
        return new GitlabAPI(hostUrl, apiToken, TokenType.PRIVATE_TOKEN);
    }

    public static GitlabAPI connect(String hostUrl, String apiToken, TokenType tokenType) {
        return new GitlabAPI(hostUrl, apiToken, tokenType);
    }

    public GitlabAPI ignoreCertificateErrors(boolean ignoreCertificateErrors) {
        this.ignoreCertificateErrors = ignoreCertificateErrors;
        return this;
    }

    public GitlabHTTPRequestor retrieve() {
        return new GitlabHTTPRequestor(this);
    }

    public GitlabHTTPRequestor dispatch() {
        return new GitlabHTTPRequestor(this).method("POST");
    }

    public boolean isIgnoreCertificateErrors() {
        return this.ignoreCertificateErrors;
    }

    public URL getAPIUrl(String tailAPIUrl) throws IOException {
        if (this.apiToken != null) {
            tailAPIUrl = tailAPIUrl + (tailAPIUrl.indexOf(63) > 0 ? (char)'&' : '?') + this.tokenType.getTokenParamName() + "=" + this.apiToken;
        }
        if (!tailAPIUrl.startsWith("/")) {
            tailAPIUrl = "/" + tailAPIUrl;
        }
        return new URL(this.hostUrl + API_NAMESPACE + tailAPIUrl);
    }

    public URL getUrl(String tailAPIUrl) throws IOException {
        if (!tailAPIUrl.startsWith("/")) {
            tailAPIUrl = "/" + tailAPIUrl;
        }
        return new URL(this.hostUrl + tailAPIUrl);
    }

    public List<GitlabUser> getUsers() throws IOException {
        String tailUrl = GitlabUser.URL;
        return this.retrieve().getAll(tailUrl, GitlabUser[].class);
    }

    public List<GitlabUser> findUsers(String emailOrUsername) throws IOException {
        String tailUrl = GitlabUser.URL + "?search=" + emailOrUsername;
        GitlabUser[] users = this.retrieve().to(tailUrl, GitlabUser[].class);
        return Arrays.asList(users);
    }

    public GitlabUser getUser() throws IOException {
        String tailUrl = GitlabUser.USER_URL;
        return this.retrieve().to(tailUrl, GitlabUser.class);
    }

    public GitlabUser getUser(Integer userId) throws IOException {
        String tailUrl = GitlabUser.URL + "/" + userId;
        return this.retrieve().to(tailUrl, GitlabUser.class);
    }

    public GitlabUser getUserViaSudo(String username) throws IOException {
        String tailUrl = GitlabUser.USER_URL + "?" + PARAM_SUDO + "=" + username;
        return this.retrieve().to(tailUrl, GitlabUser.class);
    }

    public GitlabUser createUser(String email, String password, String username, String fullName, String skypeId, String linkedIn, String twitter, String website_url, Integer projects_limit, String extern_uid, String extern_provider_name, String bio, Boolean isAdmin, Boolean can_create_group, Boolean skip_confirmation) throws IOException {
        Query query = new Query().append("email", email).appendIf("confirm", skip_confirmation == null ? null : Boolean.valueOf(skip_confirmation == false)).appendIf("password", password).appendIf("username", username).appendIf("name", fullName).appendIf("skype", skypeId).appendIf("linkedin", linkedIn).appendIf("twitter", twitter).appendIf("website_url", website_url).appendIf("projects_limit", projects_limit).appendIf("extern_uid", extern_uid).appendIf("provider", extern_provider_name).appendIf("bio", bio).appendIf("admin", isAdmin).appendIf("can_create_group", can_create_group);
        String tailUrl = GitlabUser.USERS_URL + query.toString();
        return this.dispatch().to(tailUrl, GitlabUser.class);
    }

    public GitlabUser updateUser(Integer targetUserId, String email, String password, String username, String fullName, String skypeId, String linkedIn, String twitter, String website_url, Integer projects_limit, String extern_uid, String extern_provider_name, String bio, Boolean isAdmin, Boolean can_create_group) throws IOException {
        Query query = new Query().append("email", email).appendIf("password", password).appendIf("username", username).appendIf("name", fullName).appendIf("skype", skypeId).appendIf("linkedin", linkedIn).appendIf("twitter", twitter).appendIf("website_url", website_url).appendIf("projects_limit", projects_limit).appendIf("extern_uid", extern_uid).appendIf("provider", extern_provider_name).appendIf("bio", bio).appendIf("admin", isAdmin).appendIf("can_create_group", can_create_group);
        String tailUrl = GitlabUser.USERS_URL + "/" + targetUserId + query.toString();
        return this.retrieve().method("PUT").to(tailUrl, GitlabUser.class);
    }

    public void blockUser(Integer targetUserId) throws IOException {
        String tailUrl = GitlabUser.USERS_URL + "/" + targetUserId + GitlabUser.BLOCK_URL;
        this.retrieve().method("PUT").to(tailUrl, Void.class);
    }

    public void unblockUser(Integer targetUserId) throws IOException {
        String tailUrl = GitlabUser.USERS_URL + "/" + targetUserId + GitlabUser.UNBLOCK_URL;
        this.retrieve().method("PUT").to(tailUrl, Void.class);
    }

    public GitlabSSHKey createSSHKey(Integer targetUserId, String title, String key) throws IOException {
        Query query = new Query().append("title", title).append("key", key);
        String tailUrl = GitlabUser.USERS_URL + "/" + targetUserId + GitlabSSHKey.KEYS_URL + query.toString();
        return this.dispatch().to(tailUrl, GitlabSSHKey.class);
    }

    public void deleteSSHKey(Integer targetUserId, Integer targetKeyId) throws IOException {
        String tailUrl = GitlabUser.USERS_URL + "/" + targetUserId + GitlabSSHKey.KEYS_URL + "/" + targetKeyId;
        this.retrieve().method("DELETE").to(tailUrl, Void.class);
    }

    public List<GitlabSSHKey> getSSHKeys(Integer targetUserId) throws IOException {
        String tailUrl = GitlabUser.USERS_URL + "/" + targetUserId + GitlabSSHKey.KEYS_URL;
        return Arrays.asList((Object[])this.retrieve().to(tailUrl, GitlabSSHKey[].class));
    }

    public GitlabSSHKey getSSHKey(Integer keyId) throws IOException {
        String tailUrl = GitlabSSHKey.KEYS_URL + "/" + keyId;
        return this.retrieve().to(tailUrl, GitlabSSHKey.class);
    }

    public void deleteUser(Integer targetUserId) throws IOException {
        String tailUrl = GitlabUser.USERS_URL + "/" + targetUserId;
        this.retrieve().method("DELETE").to(tailUrl, Void.class);
    }

    public GitlabGroup getGroup(Integer groupId) throws IOException {
        String tailUrl = "/groups/" + groupId;
        return this.retrieve().to(tailUrl, GitlabGroup.class);
    }

    public List<GitlabGroup> getGroups() throws IOException {
        String tailUrl = "/groups";
        return this.retrieve().getAll(tailUrl, GitlabGroup[].class);
    }

    public List<GitlabGroupMember> getGroupMembers(GitlabGroup group) throws IOException {
        return this.getGroupMembers(group.getId());
    }

    public List<GitlabGroupMember> getGroupMembers(Integer groupId) throws IOException {
        String tailUrl = "/groups/" + groupId + "/members";
        return Arrays.asList((Object[])this.retrieve().to(tailUrl, GitlabGroupMember[].class));
    }

    public GitlabGroup createGroup(String name) throws IOException {
        return this.createGroup(name, name);
    }

    public GitlabGroup createGroup(String name, String path) throws IOException {
        return this.createGroup(name, path, null, null);
    }

    public GitlabGroup createGroup(String name, String path, String ldapCn, GitlabAccessLevel ldapAccess) throws IOException {
        Query query = new Query().append("name", name).append("path", path).appendIf("ldap_cn", ldapCn).appendIf("ldap_access", ldapAccess);
        String tailUrl = "/groups" + query.toString();
        return this.dispatch().to(tailUrl, GitlabGroup.class);
    }

    public GitlabGroupMember addGroupMember(GitlabGroup group, GitlabUser user, GitlabAccessLevel accessLevel) throws IOException {
        return this.addGroupMember(group.getId(), user.getId(), accessLevel);
    }

    public GitlabGroupMember addGroupMember(Integer groupId, Integer userId, GitlabAccessLevel accessLevel) throws IOException {
        Query query = new Query().appendIf("id", groupId).appendIf("user_id", userId).appendIf("access_level", accessLevel);
        String tailUrl = "/groups/" + groupId + "/members" + query.toString();
        return this.dispatch().to(tailUrl, GitlabGroupMember.class);
    }

    public void deleteGroupMember(GitlabGroup group, GitlabUser user) throws IOException {
        this.deleteGroupMember(group.getId(), user.getId());
    }

    public void deleteGroupMember(Integer groupId, Integer userId) throws IOException {
        String tailUrl = "/groups/" + groupId + "/" + "/members" + "/" + userId;
        this.retrieve().method("DELETE").to(tailUrl, Void.class);
    }

    public void deleteGroup(Integer groupId) throws IOException {
        String tailUrl = "/groups/" + groupId;
        this.retrieve().method("DELETE").to(tailUrl, Void.class);
    }

    public GitlabProject getProject(Serializable projectId) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId);
        return this.retrieve().to(tailUrl, GitlabProject.class);
    }

    public List<GitlabProject> getProjects() throws IOException {
        String tailUrl = "/projects";
        return this.retrieve().getAll(tailUrl, GitlabProject[].class);
    }

    public List<GitlabProject> getAllProjects() throws IOException {
        String tailUrl = "/projects/all";
        return this.retrieve().getAll(tailUrl, GitlabProject[].class);
    }

    public GitlabProject createProject(String name) throws IOException {
        return this.createProject(name, null, null, null, null, null, null, null, null, null, null);
    }

    public GitlabProject createProject(String name, Integer namespaceId, String description, Boolean issuesEnabled, Boolean wallEnabled, Boolean mergeRequestsEnabled, Boolean wikiEnabled, Boolean snippetsEnabled, Boolean publik, Integer visibilityLevel, String importUrl) throws IOException {
        Query query = new Query().append("name", name).appendIf("namespace_id", namespaceId).appendIf("description", description).appendIf("issues_enabled", issuesEnabled).appendIf("wall_enabled", wallEnabled).appendIf("merge_requests_enabled", mergeRequestsEnabled).appendIf("wiki_enabled", wikiEnabled).appendIf("snippets_enabled", snippetsEnabled).appendIf("public", publik).appendIf("visibility_level", visibilityLevel).appendIf("import_url", importUrl);
        String tailUrl = "/projects" + query.toString();
        return this.dispatch().to(tailUrl, GitlabProject.class);
    }

    public GitlabProject createUserProject(Integer userId, String name) throws IOException {
        return this.createUserProject(userId, name, null, null, null, null, null, null, null, null, null);
    }

    public GitlabProject createUserProject(Integer userId, String name, String description, String defaultBranch, Boolean issuesEnabled, Boolean wallEnabled, Boolean mergeRequestsEnabled, Boolean wikiEnabled, Boolean snippetsEnabled, Boolean publik, Integer visibilityLevel) throws IOException {
        Query query = new Query().append("name", name).appendIf("description", description).appendIf("default_branch", defaultBranch).appendIf("issues_enabled", issuesEnabled).appendIf("wall_enabled", wallEnabled).appendIf("merge_requests_enabled", mergeRequestsEnabled).appendIf("wiki_enabled", wikiEnabled).appendIf("snippets_enabled", snippetsEnabled).appendIf("public", publik).appendIf("visibility_level", visibilityLevel);
        String tailUrl = "/projects/user/" + userId + query.toString();
        return this.dispatch().to(tailUrl, GitlabProject.class);
    }

    public GitlabProject updateProject(Integer projectId, String name, String description, Boolean issuesEnabled, Boolean wallEnabled, Boolean mergeRequestsEnabled, Boolean wikiEnabled, Boolean snippetsEnabled, Boolean publik, Integer visibilityLevel) throws IOException {
        Query query = new Query().appendIf("name", name).appendIf("description", description).appendIf("issues_enabled", issuesEnabled).appendIf("wall_enabled", wallEnabled).appendIf("merge_requests_enabled", mergeRequestsEnabled).appendIf("wiki_enabled", wikiEnabled).appendIf("snippets_enabled", snippetsEnabled).appendIf("public", publik).appendIf("visibility_level", visibilityLevel);
        String tailUrl = "/projects/" + projectId + query.toString();
        return this.retrieve().method("PUT").to(tailUrl, GitlabProject.class);
    }

    public void deleteProject(Serializable projectId) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId);
        this.retrieve().method("DELETE").to(tailUrl, null);
    }

    public List<GitlabMergeRequest> getOpenMergeRequests(Serializable projectId) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/merge_requests" + "?state=opened";
        return this.retrieve().getAll(tailUrl, GitlabMergeRequest[].class);
    }

    public List<GitlabMergeRequest> getOpenMergeRequests(GitlabProject project) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/merge_requests" + "?state=opened";
        return this.retrieve().getAll(tailUrl, GitlabMergeRequest[].class);
    }

    public List<GitlabMergeRequest> getMergeRequests(Serializable projectId) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/merge_requests";
        return this.retrieve().getAll(tailUrl, GitlabMergeRequest[].class);
    }

    public List<GitlabMergeRequest> getMergeRequests(GitlabProject project) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/merge_requests";
        return this.retrieve().getAll(tailUrl, GitlabMergeRequest[].class);
    }

    public List<GitlabMergeRequest> getAllMergeRequests(GitlabProject project) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/merge_requests";
        return this.retrieve().getAll(tailUrl, GitlabMergeRequest[].class);
    }

    public GitlabMergeRequest getMergeRequestByIid(Serializable projectId, Integer mergeRequestIid) throws IOException {
        Query query = new Query().append("iid", mergeRequestIid.toString());
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/merge_requests" + query.toString();
        List ls = this.retrieve().getAll(tailUrl, GitlabMergeRequest[].class);
        if (ls.size() == 0) {
            throw new FileNotFoundException();
        }
        return (GitlabMergeRequest)ls.get(0);
    }

    public GitlabMergeRequest getMergeRequest(GitlabProject project, Integer mergeRequestId) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/merge_request/" + mergeRequestId;
        return this.retrieve().to(tailUrl, GitlabMergeRequest.class);
    }

    public GitlabMergeRequest updateMergeRequest(Serializable projectId, Integer mergeRequestId, String targetBranch, Integer assigneeId, String title, String description, String stateEvent, String labels) throws IOException {
        Query query = new Query().appendIf("target_branch", targetBranch).appendIf("assignee_id", assigneeId).appendIf("title", title).appendIf("description", description).appendIf("state_event", stateEvent).appendIf("labels", labels);
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/merge_request/" + mergeRequestId + query.toString();
        return this.retrieve().method("PUT").to(tailUrl, GitlabMergeRequest.class);
    }

    public GitlabMergeRequest acceptMergeRequest(GitlabProject project, Integer mergeRequestId, String mergeCommitMessage) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/merge_request/" + mergeRequestId + "/merge";
        GitlabHTTPRequestor requestor = this.retrieve().method("PUT");
        requestor.with("id", project.getId());
        requestor.with("merge_request_id", mergeRequestId);
        if (mergeCommitMessage != null) {
            requestor.with("merge_commit_message", mergeCommitMessage);
        }
        return requestor.to(tailUrl, GitlabMergeRequest.class);
    }

    public GitlabNote getNote(GitlabMergeRequest mergeRequest, Integer noteId) throws IOException {
        String tailUrl = "/projects/" + mergeRequest.getProjectId() + "/merge_requests" + "/" + mergeRequest.getId() + "/notes" + "/" + noteId;
        return this.retrieve().to(tailUrl, GitlabNote.class);
    }

    public List<GitlabNote> getNotes(GitlabMergeRequest mergeRequest) throws IOException {
        String tailUrl = "/projects/" + mergeRequest.getProjectId() + "/merge_requests" + "/" + mergeRequest.getId() + "/notes";
        GitlabNote[] notes = this.retrieve().to(tailUrl, GitlabNote[].class);
        return Arrays.asList(notes);
    }

    public List<GitlabNote> getAllNotes(GitlabMergeRequest mergeRequest) throws IOException {
        String tailUrl = "/projects/" + mergeRequest.getProjectId() + "/merge_requests" + "/" + mergeRequest.getId() + "/notes";
        return this.retrieve().getAll(tailUrl, GitlabNote[].class);
    }

    public GitlabCommit getCommit(Serializable projectId, String commitHash) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/repository/commits/" + commitHash;
        return this.retrieve().to(tailUrl, GitlabCommit.class);
    }

    public List<GitlabCommit> getCommits(GitlabMergeRequest mergeRequest) throws IOException {
        Integer projectId = mergeRequest.getSourceProjectId();
        if (projectId == null) {
            projectId = mergeRequest.getProjectId();
        }
        Query query = new Query().append("ref_name", mergeRequest.getSourceBranch());
        String tailUrl = "/projects/" + projectId + "/repository" + "/commits" + query.toString();
        GitlabCommit[] commits = this.retrieve().to(tailUrl, GitlabCommit[].class);
        return Arrays.asList(commits);
    }

    public List<GitlabCommit> getAllCommits(Serializable projectId) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/repository" + "/commits";
        return this.retrieve().getAll(tailUrl, GitlabCommit[].class);
    }

    public List<GitlabCommitDiff> getCommitDiffs(Serializable projectId, String commitHash) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/repository/commits/" + commitHash + "/diff";
        GitlabCommitDiff[] diffs = this.retrieve().to(tailUrl, GitlabCommitDiff[].class);
        return Arrays.asList(diffs);
    }

    public List<GitlabCommitStatus> getCommitStatuses(GitlabProject project, String commitHash) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/repository" + "/commits" + "/" + commitHash + "/statuses";
        GitlabCommitStatus[] statuses = this.retrieve().to(tailUrl, GitlabCommitStatus[].class);
        return Arrays.asList(statuses);
    }

    public GitlabCommitStatus createCommitStatus(GitlabProject project, String commitHash, String state, String ref, String name, String targetUrl, String description) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/statuses" + "/" + commitHash;
        return this.dispatch().with("state", state).with("ref", ref).with("name", name).with("target_url", targetUrl).with("description", description).to(tailUrl, GitlabCommitStatus.class);
    }

    public byte[] getRawFileContent(GitlabProject project, String sha, String filepath) throws IOException {
        Query query = new Query().append("filepath", filepath);
        String tailUrl = "/projects/" + project.getId() + "/repository/blobs/" + sha + query.toString();
        return this.retrieve().to(tailUrl, byte[].class);
    }

    public byte[] getRawBlobContent(GitlabProject project, String sha) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/repository/raw_blobs/" + sha;
        return this.retrieve().to(tailUrl, byte[].class);
    }

    public byte[] getFileArchive(GitlabProject project) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/repository/archive";
        return this.retrieve().to(tailUrl, byte[].class);
    }

    public List<GitlabRepositoryTree> getRepositoryTree(GitlabProject project, String path, String ref_name) throws IOException {
        Query query = new Query().appendIf("path", path).appendIf("ref_name", ref_name);
        String tailUrl = "/projects/" + project.getId() + "/repository" + GitlabRepositoryTree.URL + query.toString();
        GitlabRepositoryTree[] tree = this.retrieve().to(tailUrl, GitlabRepositoryTree[].class);
        return Arrays.asList(tree);
    }

    public GitlabNote updateNote(GitlabMergeRequest mergeRequest, Integer noteId, String body) throws IOException {
        Query query = new Query().appendIf("body", body);
        String tailUrl = "/projects/" + mergeRequest.getProjectId() + "/merge_requests" + "/" + mergeRequest.getId() + "/notes" + "/" + noteId + query.toString();
        return this.retrieve().method("PUT").to(tailUrl, GitlabNote.class);
    }

    public GitlabNote createNote(GitlabMergeRequest mergeRequest, String body) throws IOException {
        String tailUrl = "/projects/" + mergeRequest.getProjectId() + "/merge_requests" + "/" + mergeRequest.getId() + "/notes";
        return this.dispatch().with("body", body).to(tailUrl, GitlabNote.class);
    }

    public List<GitlabBranch> getBranches(Serializable projectId) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/repository/branches/";
        GitlabBranch[] branches = this.retrieve().to(tailUrl, GitlabBranch[].class);
        return Arrays.asList(branches);
    }

    public List<GitlabBranch> getBranches(GitlabProject project) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/repository/branches/";
        GitlabBranch[] branches = this.retrieve().to(tailUrl, GitlabBranch[].class);
        return Arrays.asList(branches);
    }

    public GitlabBranch getBranch(GitlabProject project, String branchName) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/repository/branches/" + branchName;
        return this.retrieve().to(tailUrl, GitlabBranch.class);
    }

    public void protectBranch(GitlabProject project, String branchName) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/repository/branches/" + branchName + "/protect";
        this.retrieve().method("PUT").to(tailUrl, Void.class);
    }

    public void unprotectBranch(GitlabProject project, String branchName) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/repository/branches/" + branchName + "/unprotect";
        this.retrieve().method("PUT").to(tailUrl, Void.class);
    }

    public List<GitlabProjectHook> getProjectHooks(Serializable projectId) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/hooks";
        GitlabProjectHook[] hooks = this.retrieve().to(tailUrl, GitlabProjectHook[].class);
        return Arrays.asList(hooks);
    }

    public List<GitlabProjectHook> getProjectHooks(GitlabProject project) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/hooks";
        GitlabProjectHook[] hooks = this.retrieve().to(tailUrl, GitlabProjectHook[].class);
        return Arrays.asList(hooks);
    }

    public GitlabProjectHook getProjectHook(GitlabProject project, String hookId) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/hooks" + "/" + hookId;
        GitlabProjectHook hook = this.retrieve().to(tailUrl, GitlabProjectHook.class);
        return hook;
    }

    public GitlabProjectHook addProjectHook(GitlabProject project, String url) throws IOException {
        Query query = new Query().append("url", url);
        String tailUrl = "/projects/" + project.getId() + "/hooks" + query.toString();
        return this.dispatch().to(tailUrl, GitlabProjectHook.class);
    }

    public GitlabProjectHook addProjectHook(Serializable projectId, String url, boolean pushEvents, boolean issuesEvents, boolean mergeRequestEvents, boolean sslVerification) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/hooks";
        return this.dispatch().with("url", url).with("push_events", pushEvents ? "true" : "false").with("issues_events", issuesEvents ? "true" : "false").with("merge_requests_events", mergeRequestEvents ? "true" : "false").with("enable_ssl_verification", sslVerification ? "true" : "false").to(tailUrl, GitlabProjectHook.class);
    }

    public GitlabProjectHook editProjectHook(GitlabProject project, String hookId, String url) throws IOException {
        Query query = new Query().append("url", url);
        String tailUrl = "/projects/" + project.getId() + "/hooks" + "/" + hookId + query.toString();
        return this.retrieve().method("PUT").to(tailUrl, GitlabProjectHook.class);
    }

    public void deleteProjectHook(GitlabProjectHook hook) throws IOException {
        String tailUrl = "/projects/" + hook.getProjectId() + "/hooks" + "/" + hook.getId();
        this.retrieve().method("DELETE").to(tailUrl, Void.class);
    }

    public void deleteProjectHook(GitlabProject project, String hookId) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/hooks" + "/" + hookId;
        this.retrieve().method("DELETE").to(tailUrl, Void.class);
    }

    public List<GitlabIssue> getIssues(GitlabProject project) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/issues";
        return this.retrieve().getAll(tailUrl, GitlabIssue[].class);
    }

    public GitlabIssue getIssue(Serializable projectId, Integer issueId) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/issues" + "/" + issueId;
        return this.retrieve().to(tailUrl, GitlabIssue.class);
    }

    public GitlabIssue createIssue(int projectId, int assigneeId, int milestoneId, String labels, String description, String title) throws IOException {
        String tailUrl = "/projects/" + projectId + "/issues";
        GitlabHTTPRequestor requestor = this.dispatch();
        this.applyIssue(requestor, projectId, assigneeId, milestoneId, labels, description, title);
        return requestor.to(tailUrl, GitlabIssue.class);
    }

    public GitlabIssue editIssue(int projectId, int issueId, int assigneeId, int milestoneId, String labels, String description, String title, GitlabIssue.Action action) throws IOException {
        String tailUrl = "/projects/" + projectId + "/issues" + "/" + issueId;
        GitlabHTTPRequestor requestor = this.retrieve().method("PUT");
        this.applyIssue(requestor, projectId, assigneeId, milestoneId, labels, description, title);
        if (action != GitlabIssue.Action.LEAVE) {
            requestor.with("state_event", action.toString().toLowerCase());
        }
        return requestor.to(tailUrl, GitlabIssue.class);
    }

    private void applyIssue(GitlabHTTPRequestor requestor, int projectId, int assigneeId, int milestoneId, String labels, String description, String title) {
        requestor.with("title", title).with("description", description).with("labels", labels).with("milestone_id", milestoneId);
        if (assigneeId != 0) {
            requestor.with("assignee_id", assigneeId == -1 ? 0 : assigneeId);
        }
    }

    public List<GitlabNote> getNotes(GitlabIssue issue) throws IOException {
        String tailUrl = "/projects/" + issue.getProjectId() + "/issues" + "/" + issue.getId() + "/notes";
        return Arrays.asList((Object[])this.retrieve().to(tailUrl, GitlabNote[].class));
    }

    public GitlabNote createNote(Serializable projectId, Integer issueId, String message) throws IOException {
        String tailUrl = "/projects/" + projectId + "/issues" + "/" + issueId + "/notes";
        return this.dispatch().with("body", message).to(tailUrl, GitlabNote.class);
    }

    public GitlabNote createNote(GitlabIssue issue, String message) throws IOException {
        return this.createNote((Serializable)((Object)String.valueOf(issue.getProjectId())), issue.getId(), message);
    }

    public List<GitlabMilestone> getMilestones(GitlabProject project) throws IOException {
        return this.getMilestones((Serializable)((Object)String.valueOf(project.getId())));
    }

    public List<GitlabMilestone> getMilestones(Serializable projectId) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/milestones";
        return Arrays.asList((Object[])this.retrieve().to(tailUrl, GitlabMilestone[].class));
    }

    public GitlabProjectMember addProjectMember(GitlabProject project, GitlabUser user, GitlabAccessLevel accessLevel) throws IOException {
        return this.addProjectMember(project.getId(), user.getId(), accessLevel);
    }

    public GitlabProjectMember addProjectMember(Integer projectId, Integer userId, GitlabAccessLevel accessLevel) throws IOException {
        Query query = new Query().appendIf("id", projectId).appendIf("user_id", userId).appendIf("access_level", accessLevel);
        String tailUrl = "/projects/" + projectId + "/members" + query.toString();
        return this.dispatch().to(tailUrl, GitlabProjectMember.class);
    }

    public void deleteProjectMember(GitlabProject project, GitlabUser user) throws IOException {
        this.deleteProjectMember(project.getId(), user.getId());
    }

    public void deleteProjectMember(Integer projectId, Integer userId) throws IOException {
        String tailUrl = "/projects/" + projectId + "/" + "/members" + "/" + userId;
        this.retrieve().method("DELETE").to(tailUrl, Void.class);
    }

    public List<GitlabProjectMember> getProjectMembers(GitlabProject project) throws IOException {
        return this.getProjectMembers(project.getId());
    }

    public List<GitlabProjectMember> getProjectMembers(Serializable projectId) throws IOException {
        String tailUrl = "/projects/" + this.sanitizeProjectId(projectId) + "/members";
        return Arrays.asList((Object[])this.retrieve().to(tailUrl, GitlabProjectMember[].class));
    }

    public List<GitlabProjectMember> getNamespaceMembers(GitlabNamespace namespace) throws IOException {
        return this.getNamespaceMembers(namespace.getId());
    }

    public List<GitlabProjectMember> getNamespaceMembers(Integer namespaceId) throws IOException {
        String tailUrl = "/groups/" + namespaceId + "/members";
        return Arrays.asList((Object[])this.retrieve().to(tailUrl, GitlabProjectMember[].class));
    }

    public void transfer(Integer namespaceId, Integer projectId) throws IOException {
        String tailUrl = "/groups/" + namespaceId + "/projects" + "/" + projectId;
        this.dispatch().to(tailUrl, Void.class);
    }

    public GitlabSSHKey createDeployKey(Integer targetProjectId, String title, String key) throws IOException {
        Query query = new Query().append("title", title).append("key", key);
        String tailUrl = "/projects/" + targetProjectId + GitlabSSHKey.KEYS_URL + query.toString();
        return this.dispatch().to(tailUrl, GitlabSSHKey.class);
    }

    public void deleteDeployKey(Integer targetProjectId, Integer targetKeyId) throws IOException {
        String tailUrl = "/projects/" + targetProjectId + GitlabSSHKey.KEYS_URL + "/" + targetKeyId;
        this.retrieve().method("DELETE").to(tailUrl, Void.class);
    }

    public List<GitlabSSHKey> getDeployKeys(Integer targetProjectId) throws IOException {
        String tailUrl = "/projects/" + targetProjectId + GitlabSSHKey.KEYS_URL;
        return Arrays.asList((Object[])this.retrieve().to(tailUrl, GitlabSSHKey[].class));
    }

    public GitlabSession getCurrentSession() throws IOException {
        String tailUrl = "/user";
        return this.retrieve().to(tailUrl, GitlabSession.class);
    }

    public List<GitlabSystemHook> getSystemHooks() throws IOException {
        String tailUrl = "/hooks";
        return Arrays.asList((Object[])this.retrieve().to(tailUrl, GitlabSystemHook[].class));
    }

    public GitlabSystemHook addSystemHook(String url) throws IOException {
        String tailUrl = "/hooks";
        return this.dispatch().with("url", url).to(tailUrl, GitlabSystemHook.class);
    }

    public void testSystemHook(Integer hookId) throws IOException {
        String tailUrl = "/hooks/" + hookId;
        this.retrieve().to(tailUrl, Void.class);
    }

    public GitlabSystemHook deleteSystemHook(Integer hookId) throws IOException {
        String tailUrl = "/hooks/" + hookId;
        return this.retrieve().method("DELETE").to(tailUrl, GitlabSystemHook.class);
    }

    private String sanitizeProjectId(Serializable projectId) {
        if (!(projectId instanceof String) && !(projectId instanceof Integer)) {
            throw new IllegalArgumentException();
        }
        try {
            return URLEncoder.encode(String.valueOf(projectId), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

