/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v321;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.geotoolkit.gml.xml.Coordinates;
import org.geotoolkit.util.Utilities;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="CoordinatesType", propOrder={"value"})
public class CoordinatesType
implements Coordinates {
    @XmlValue
    private String value;
    @XmlAttribute
    private String decimal;
    @XmlAttribute
    private String cs;
    @XmlAttribute
    private String ts;

    public CoordinatesType() {
    }

    public CoordinatesType(Coordinates that) {
        if (that != null) {
            this.cs = that.getCs();
            this.decimal = that.getDecimal();
            this.ts = that.getTs();
            this.value = that.getValue();
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public List<Double> getValues() {
        String curentTs = this.ts == null ? " " : this.ts;
        String curentCs = this.cs == null ? "," : this.cs;
        ArrayList<Double> values = new ArrayList<Double>();
        if (this.value != null) {
            StringTokenizer tokenizer = new StringTokenizer(this.value, curentTs);
            while (tokenizer.hasMoreTokens()) {
                String v = tokenizer.nextToken();
                try {
                    int i = v.indexOf(curentCs);
                    if (i == -1) continue;
                    String first = v.substring(0, i);
                    String second = v.substring(i + 1);
                    values.add(Double.parseDouble(first));
                    values.add(Double.parseDouble(second));
                }
                catch (NumberFormatException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "unable to parse coordiante value:{0}", v);
                }
            }
        }
        return values;
    }

    @Override
    public String getDecimal() {
        if (this.decimal == null) {
            return ".";
        }
        return this.decimal;
    }

    public void setDecimal(String value) {
        this.decimal = value;
    }

    @Override
    public String getCs() {
        if (this.cs == null) {
            return ",";
        }
        return this.cs;
    }

    public void setCs(String value) {
        this.cs = value;
    }

    @Override
    public String getTs() {
        if (this.ts == null) {
            return " ";
        }
        return this.ts;
    }

    public void setTs(String value) {
        this.ts = value;
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.value != null ? this.value.hashCode() : 0);
        hash = 47 * hash + (this.decimal != null ? this.decimal.hashCode() : 0);
        hash = 47 * hash + (this.cs != null ? this.cs.hashCode() : 0);
        hash = 47 * hash + (this.ts != null ? this.ts.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CoordinatesType) {
            CoordinatesType that = (CoordinatesType)object;
            return Utilities.equals((Object)this.cs, (Object)that.cs) && Utilities.equals((Object)this.ts, (Object)that.ts) && Utilities.equals((Object)this.value, (Object)that.value) && Utilities.equals((Object)this.decimal, (Object)that.decimal);
        }
        return false;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("CoordinatesType[").append('\n');
        if (this.value != null) {
            s.append("value : ").append(this.value.toString()).append('\n');
        }
        if (this.decimal != null) {
            s.append("decimal : ").append(this.decimal.toString()).append('\n');
        }
        if (this.cs != null) {
            s.append("cs : ").append(this.cs.toString()).append('\n');
        }
        if (this.ts != null) {
            s.append("ts : ").append(this.ts.toString()).append('\n');
        }
        s.append("]");
        return s.toString();
    }
}

