/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v311;

import java.io.Serializable;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.geotoolkit.gml.xml.AbstractTimePosition;
import org.geotoolkit.gml.xml.TimeIndeterminateValueType;
import org.geotoolkit.util.SimpleInternationalString;
import org.geotoolkit.util.Utilities;
import org.opengis.temporal.Position;
import org.opengis.util.InternationalString;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="TimePositionType", propOrder={"value"})
public class TimePositionType
extends AbstractTimePosition
implements Serializable {
    @XmlValue
    private String value;
    @XmlAttribute
    @XmlSchemaType(name="anyURI")
    private String frame;
    @XmlAttribute
    private String calendarEraName;
    @XmlAttribute
    private TimeIndeterminateValueType indeterminatePosition;

    TimePositionType() {
    }

    public TimePositionType(String value) {
        this.value = value;
    }

    public TimePositionType(Position value) {
        this(value.getDate());
    }

    public TimePositionType(TimeIndeterminateValueType indeterminatePosition) {
        this.indeterminatePosition = indeterminatePosition;
        this.value = "";
    }

    public TimePositionType(Timestamp time) {
        this.value = time.toString();
    }

    public TimePositionType(Date time) {
        this.setValue(time);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setValue(Date value) {
        DateFormat df;
        Calendar c = Calendar.getInstance();
        c.setTime(value);
        if (c.get(10) == 0 && c.get(12) == 0 && c.get(13) == 0) {
            DateFormat df2;
            DateFormat dateFormat = df2 = (DateFormat)FORMATTERS.get(2);
            synchronized (dateFormat) {
                this.value = df2.format(value);
            }
        }
        DateFormat dateFormat = df = (DateFormat)FORMATTERS.get(0);
        synchronized (dateFormat) {
            this.value = df.format(value);
        }
    }

    public String getFrame() {
        return this.frame;
    }

    public void setFrame(String value) {
        this.frame = value;
    }

    public String getCalendarEraName() {
        return this.calendarEraName;
    }

    public void setCalendarEraName(String value) {
        this.calendarEraName = value;
    }

    @Override
    public TimeIndeterminateValueType getIndeterminatePosition() {
        return this.indeterminatePosition;
    }

    public void setIndeterminatePosition(TimeIndeterminateValueType value) {
        this.indeterminatePosition = value;
    }

    public Date getDate() {
        return this.parseDate(this.value);
    }

    public Time getTime() {
        return Time.valueOf(this.value);
    }

    public InternationalString getDateTime() {
        if (this.value != null) {
            return new SimpleInternationalString(this.value);
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TimePositionType) {
            TimePositionType that = (TimePositionType)object;
            return Utilities.equals((Object)this.calendarEraName, (Object)that.calendarEraName) && Utilities.equals((Object)this.frame, (Object)that.frame) && Utilities.equals((Object)((Object)this.indeterminatePosition), (Object)((Object)that.indeterminatePosition)) && Utilities.equals((Object)this.value, (Object)that.value);
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.value != null ? this.value.hashCode() : 0);
        hash = 97 * hash + (this.calendarEraName != null ? this.calendarEraName.hashCode() : 0);
        hash = 97 * hash + (this.frame != null ? this.frame.hashCode() : 0);
        hash = 97 * hash + (this.indeterminatePosition != null ? this.indeterminatePosition.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.calendarEraName != null) {
            s.append("calendarEraName:").append(this.calendarEraName).append('\n');
        }
        if (this.frame != null) {
            s.append("frame:").append(this.frame).append('\n');
        }
        if (this.indeterminatePosition != null) {
            s.append("indeterminatePosition:").append(this.indeterminatePosition.value()).append('\n');
        }
        if (this.value != null && this.getDate() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("d MMMMM yyyy HH:mm:ss z");
            s.append(sdf.format(this.getDate()));
        }
        return s.toString();
    }
}

