/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.geotoolkit.temporal.object.ISODateParser;

public class PeriodUtilities {
    private DateFormat dateFormat;
    private ISODateParser dateParser = new ISODateParser();

    public PeriodUtilities(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getDatesRespresentation(SortedSet<Date> dates) {
        Date first;
        if (dates.comparator() != null) {
            throw new IllegalArgumentException("Dates should be sorted naturaly without any custom comparator.");
        }
        if (dates.isEmpty()) {
            return "";
        }
        StringBuffer response = new StringBuffer();
        Date previousDate = first = dates.first();
        long previousGap = 0L;
        long gap = 0L;
        int nbDataInGap = 0;
        Iterator i$ = dates.iterator();
        while (i$.hasNext()) {
            previousGap = gap;
            Date d = (Date)i$.next();
            if (previousGap != (gap = d.getTime() - previousDate.getTime())) {
                if (nbDataInGap >= 2) {
                    String firstDate = this.dateFormat.format(first);
                    if (response.indexOf(firstDate + ',') != -1) {
                        int pos = response.indexOf(firstDate);
                        response.delete(pos, pos + firstDate.length() + 1);
                    }
                    response.append(this.getPeriodDescription(dates.subSet(first, d), previousGap)).append(',');
                    nbDataInGap = 1;
                } else if (nbDataInGap > 0) {
                    this.dateFormat.format(previousDate, response, new FieldPosition(0)).append(',');
                    nbDataInGap = 1;
                }
                first = previousDate;
            } else {
                ++nbDataInGap;
            }
            previousDate = d;
        }
        if (nbDataInGap > 0) {
            if (nbDataInGap >= 2) {
                String firstDate = this.dateFormat.format(first);
                if (response.indexOf(firstDate + ',') != -1) {
                    int pos = response.indexOf(firstDate);
                    response.delete(pos, pos + firstDate.length() + 1);
                }
                response.append(this.getPeriodDescription(dates.tailSet(first), gap));
                nbDataInGap = 1;
            } else if (nbDataInGap > 0) {
                this.dateFormat.format(previousDate, response, new FieldPosition(0));
                nbDataInGap = 1;
            }
        }
        return response.toString();
    }

    public String getPeriodDescription(SortedSet<Date> dates, long gap) {
        StringBuffer response = new StringBuffer();
        this.dateFormat.format(dates.first(), response, new FieldPosition(0));
        response.append('/');
        this.dateFormat.format(dates.last(), response, new FieldPosition(0));
        response.append("/P");
        long temp = gap / 31536000000L;
        if (temp > 1L) {
            response.append(temp).append('Y');
            gap -= temp * 31536000000L;
        }
        if ((temp = gap / 2628000000L) >= 1L) {
            response.append(temp).append('M');
            gap -= temp * 2628000000L;
        }
        if ((temp = gap / 604800000L) >= 1L) {
            response.append(temp).append('W');
            gap -= temp * 604800000L;
        }
        if ((temp = gap / 86400000L) >= 1L) {
            response.append(temp).append('D');
            gap -= temp * 86400000L;
        }
        if (gap != 0L) {
            response.append('T');
        }
        if ((temp = gap / 3600000L) >= 1L) {
            response.append(temp).append('H');
            gap -= temp * 3600000L;
        }
        if ((temp = gap / 60000L) >= 1L) {
            response.append(temp).append('M');
            gap -= temp * 60000L;
        }
        if ((temp = gap / 1000L) >= 1L) {
            response.append(temp).append('S');
            gap -= temp * 1000L;
        }
        if (gap != 0L) {
            throw new IllegalArgumentException("TimePeriod can't be found a the Millisecond precision");
        }
        return response.toString();
    }

    public SortedSet<Date> getDatesFromPeriodDescription(String periods) throws ParseException {
        TreeSet<Date> response = new TreeSet<Date>();
        StringTokenizer tokens = new StringTokenizer(periods, ",");
        while (tokens.hasMoreTokens()) {
            String dates = tokens.nextToken().trim();
            int slash = dates.indexOf(47);
            if (slash == -1) {
                response.add(this.dateFormat == null ? this.dateParser.parseToDate(dates) : this.dateFormat.parse(dates));
                continue;
            }
            String begin = dates.substring(0, slash);
            Date first = this.dateFormat == null ? this.dateParser.parseToDate(begin) : this.dateFormat.parse(begin);
            dates = dates.substring(slash + 1);
            slash = dates.indexOf(47);
            String end = dates.substring(0, slash);
            Date last = this.dateFormat == null ? this.dateParser.parseToDate(end) : this.dateFormat.parse(end);
            dates = dates.substring(slash + 1);
            long gap = this.getTimeFromPeriodDescription(dates);
            Date currentDate = first;
            while (!currentDate.equals(last)) {
                response.add(currentDate);
                currentDate = new Date(currentDate.getTime() + gap);
            }
            response.add(last);
        }
        return response;
    }

    public long getTimeFromPeriodDescription(String periodDescription) {
        long time = 0L;
        if ((periodDescription = periodDescription.substring(1)).indexOf(89) != -1) {
            int nbYear = Integer.parseInt(periodDescription.substring(0, periodDescription.indexOf(89)));
            time += (long)nbYear * 31536000000L;
            periodDescription = periodDescription.substring(periodDescription.indexOf(89) + 1);
        }
        if (periodDescription.indexOf(77) != -1 && (periodDescription.indexOf(84) == -1 || periodDescription.indexOf(84) > periodDescription.indexOf(77))) {
            int nbMonth = Integer.parseInt(periodDescription.substring(0, periodDescription.indexOf(77)));
            time += (long)nbMonth * 2628000000L;
            periodDescription = periodDescription.substring(periodDescription.indexOf(77) + 1);
        }
        if (periodDescription.indexOf(87) != -1) {
            int nbWeek = Integer.parseInt(periodDescription.substring(0, periodDescription.indexOf(87)));
            time += (long)nbWeek * 604800000L;
            periodDescription = periodDescription.substring(periodDescription.indexOf(87) + 1);
        }
        if (periodDescription.indexOf(68) != -1) {
            int nbDay = Integer.parseInt(periodDescription.substring(0, periodDescription.indexOf(68)));
            time += (long)nbDay * 86400000L;
            periodDescription = periodDescription.substring(periodDescription.indexOf(68) + 1);
        }
        if (periodDescription.indexOf(84) != -1) {
            periodDescription = periodDescription.substring(1);
        }
        if (periodDescription.indexOf(72) != -1) {
            int nbHour = Integer.parseInt(periodDescription.substring(0, periodDescription.indexOf(72)));
            time += (long)nbHour * 3600000L;
            periodDescription = periodDescription.substring(periodDescription.indexOf(72) + 1);
        }
        if (periodDescription.indexOf(77) != -1) {
            int nbMin = Integer.parseInt(periodDescription.substring(0, periodDescription.indexOf(77)));
            time += (long)nbMin * 60000L;
            periodDescription = periodDescription.substring(periodDescription.indexOf(77) + 1);
        }
        if (periodDescription.indexOf(83) != -1) {
            int nbSec = Integer.parseInt(periodDescription.substring(0, periodDescription.indexOf(83)));
            time += (long)nbSec * 1000L;
            periodDescription = periodDescription.substring(periodDescription.indexOf(83) + 1);
        }
        if (periodDescription.length() != 0) {
            throw new IllegalArgumentException("The period descritpion is malformed");
        }
        return time;
    }
}

