/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.jaxb;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry.JTSLineString;
import org.geotoolkit.internal.jaxb.CoordinateReferenceSystemAdapter;
import org.geotoolkit.internal.jaxb.CoordinatesType;
import org.geotoolkit.internal.jaxb.PosListType;
import org.geotoolkit.referencing.CRS;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="lineStringPosListType", namespace="http://www.opengis.net/gml")
public class LineStringPosListType {
    @XmlAttribute
    private String srsName;
    @XmlElement(namespace="http://www.opengis.net/gml")
    private PosListType posList;
    @XmlElement(namespace="http://www.opengis.net/gml")
    private CoordinatesType coordinates;

    public LineStringPosListType() {
    }

    public LineStringPosListType(List<Double> value) {
        this.posList = new PosListType(value);
    }

    public LineStringPosListType(JTSLineString lineString) {
        this.srsName = CoordinateReferenceSystemAdapter.getSrsName(lineString.getCoordinateReferenceSystem());
        ArrayList<Double> value = new ArrayList<Double>();
        for (Position p : lineString.getPositions()) {
            for (int i = 0; i < p.getDirectPosition().getDimension(); ++i) {
                value.add(p.getDirectPosition().getOrdinate(i));
            }
        }
        this.posList = new PosListType(value);
    }

    public JTSLineString getJTSLineString() {
        JTSLineString result;
        block7: {
            block6: {
                CoordinateReferenceSystem crs = null;
                if (this.srsName != null) {
                    try {
                        crs = CRS.decode((String)this.srsName);
                    }
                    catch (NoSuchAuthorityCodeException ex) {
                        Logger.getLogger(LineStringPosListType.class.getName()).log(Level.WARNING, null, ex);
                    }
                    catch (FactoryException ex) {
                        Logger.getLogger(LineStringPosListType.class.getName()).log(Level.WARNING, null, ex);
                    }
                }
                result = new JTSLineString(crs);
                if (this.posList == null) break block6;
                for (int i = 0; i < this.posList.getValue().size(); i += 2) {
                    result.getPositions().add((Position)new GeneralDirectPosition(new double[]{this.posList.getValue().get(i), this.posList.getValue().get(i + 1)}));
                }
                break block7;
            }
            if (this.coordinates == null) break block7;
            for (int i = 0; i < this.coordinates.getValues().size(); i += 2) {
                result.getPositions().add((Position)new GeneralDirectPosition(new double[]{this.coordinates.getValues().get(i), this.coordinates.getValues().get(i + 1)}));
            }
        }
        return result;
    }

    public String getSrsName() {
        return this.srsName;
    }

    public void setSrsName(String srsName) {
        this.srsName = srsName;
    }

    public PosListType getPosList() {
        return this.posList;
    }

    public void setPosList(PosListType posList) {
        this.posList = posList;
    }

    public CoordinatesType getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(CoordinatesType coordinates) {
        this.coordinates = coordinates;
    }
}

