/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.jaxb;

import java.util.logging.Level;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.geotoolkit.internal.jaxb.DirectPositionType;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.util.collection.Cache;
import org.geotoolkit.util.logging.Logging;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

public class CoordinateReferenceSystemAdapter
extends XmlAdapter<String, CoordinateReferenceSystem> {
    private static final Cache<CoordinateReferenceSystem, String> cachedIdentifier = new Cache();

    public CoordinateReferenceSystem unmarshal(String v) throws Exception {
        if (v != null) {
            return CRS.decode((String)v);
        }
        return null;
    }

    public String marshal(CoordinateReferenceSystem v) throws Exception {
        return CoordinateReferenceSystemAdapter.getSrsName(v);
    }

    public static String getSrsName(CoordinateReferenceSystem crs) {
        String srsName = null;
        if (crs != null) {
            try {
                srsName = (String)cachedIdentifier.get((Object)crs);
                if (srsName == null && !cachedIdentifier.containsKey((Object)crs)) {
                    srsName = IdentifiedObjects.lookupIdentifier((Citation)Citations.URN_OGC, (IdentifiedObject)crs, (boolean)false);
                    if (srsName == null) {
                        srsName = IdentifiedObjects.getIdentifier((IdentifiedObject)crs);
                    }
                    cachedIdentifier.put((Object)crs, (Object)srsName);
                }
            }
            catch (FactoryException ex) {
                Logging.getLogger(DirectPositionType.class).log(Level.WARNING, null, ex);
            }
        }
        return srsName;
    }
}

