/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.logging;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.geotoolkit.util.logging.LoggerAdapter;

public class Log4JLogger
extends LoggerAdapter {
    final Logger logger;

    public Log4JLogger(String string, Logger logger) {
        super(string);
        this.logger = logger;
    }

    private static Level toLog4JLevel(java.util.logging.Level level) {
        int n = level.intValue();
        switch (n / 100) {
            default: {
                switch (n) {
                    default: {
                        if (n >= 0) {
                            return Level.FATAL;
                        }
                    }
                    case -2147483648: {
                        return Level.ALL;
                    }
                    case 0x7FFFFFFF: 
                }
                return Level.OFF;
            }
            case 10: {
                return Level.ERROR;
            }
            case 9: {
                return Level.WARN;
            }
            case 7: 
            case 8: {
                return Level.INFO;
            }
            case 5: 
            case 6: {
                return Level.DEBUG;
            }
            case 4: {
                return Level.TRACE;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
        }
        return Level.ALL;
    }

    private static java.util.logging.Level toJavaLevel(Level level) {
        int n = level.toInt();
        if (n == Integer.MAX_VALUE) {
            return java.util.logging.Level.OFF;
        }
        if (n >= 40000) {
            return java.util.logging.Level.SEVERE;
        }
        if (n >= 30000) {
            return java.util.logging.Level.WARNING;
        }
        if (n >= 20000) {
            return java.util.logging.Level.CONFIG;
        }
        if (n >= 10000) {
            return java.util.logging.Level.FINE;
        }
        if (n >= 5000) {
            return java.util.logging.Level.FINER;
        }
        return java.util.logging.Level.ALL;
    }

    public void setLevel(java.util.logging.Level level) {
        this.logger.setLevel(Log4JLogger.toLog4JLevel(level));
    }

    public java.util.logging.Level getLevel() {
        return Log4JLogger.toJavaLevel(this.logger.getEffectiveLevel());
    }

    public boolean isLoggable(java.util.logging.Level level) {
        return this.logger.isEnabledFor((Priority)Log4JLogger.toLog4JLevel(level));
    }

    public void log(java.util.logging.Level level, String string) {
        this.logger.log((Priority)Log4JLogger.toLog4JLevel(level), (Object)string);
    }

    public void log(java.util.logging.Level level, String string, Throwable throwable) {
        this.logger.log((Priority)Log4JLogger.toLog4JLevel(level), (Object)string, throwable);
    }

    public void severe(String string) {
        this.logger.error((Object)string);
    }

    public void warning(String string) {
        this.logger.warn((Object)string);
    }

    public void info(String string) {
        this.logger.info((Object)string);
    }

    public void config(String string) {
        this.logger.info((Object)string);
    }

    public void fine(String string) {
        this.logger.debug((Object)string);
    }

    public void finer(String string) {
        this.logger.debug((Object)string);
    }

    public void finest(String string) {
        this.logger.trace((Object)string);
    }
}

