/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.image.io;

import java.awt.geom.AffineTransform;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.imageio.IIOException;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.io.ContentFormatException;
import org.geotoolkit.lang.Static;
import org.geotoolkit.resources.Errors;

public final class SupportFiles
extends Static {
    private static final String ENCODING = "ISO-8859-1";
    private static final String[][] SPECIAL_CASES = new String[][]{{"jpg", "jpw", "jpegw"}, {"jpeg", "jpw", "jpgw"}, {"tif", "tiffw"}, {"bmp", "bmw"}};

    private SupportFiles() {
    }

    /*
     * Unable to fully structure code
     */
    private static File toSupportFile(File var0, String var1_1, boolean var2_2) {
        var3_3 = var0.getParentFile();
        var4_4 = new StringBuilder(var0.getName());
        var5_5 = var4_4.lastIndexOf(".");
        if (var5_5 >= 0) {
            var6_6 = var4_4.substring(++var5_5);
            var4_4.setLength(var5_5);
        } else {
            var6_6 = "";
            var5_5 = var4_4.append('.').length();
        }
        var7_7 = var0;
        var8_8 = null;
        var9_9 = 0;
        var10_10 = 0;
        block11: while (true) {
            block18: {
                switch (var10_10) {
                    case 0: {
                        var4_4.append(var1_1);
                        break;
                    }
                    case 1: {
                        var4_4.append(var1_1.toUpperCase());
                        break;
                    }
                    case 2: {
                        if (!var2_2) break block11;
                        var4_4.append(var6_6).append('w');
                        break;
                    }
                    case 3: {
                        var4_4.append(var6_6.toUpperCase()).append('W');
                        break;
                    }
                    case 4: {
                        for (String[] var14_14 : SupportFiles.SPECIAL_CASES) {
                            if (!var6_6.equalsIgnoreCase(var14_14[0])) continue;
                            var8_8 = var14_14;
                            break;
                        }
                        if (var8_8 != null) ** GOTO lbl41
                        var10_10 += 2;
                        break block18;
lbl41:
                        // 1 sources

                        ++var10_10;
                    }
                    case 5: {
                        var4_4.append((String)var8_8[++var9_9]);
                        break;
                    }
                    case 6: {
                        var4_4.append(var8_8[var9_9].toUpperCase());
                        if (var9_9 + 1 == var8_8.length) break;
                        var10_10 -= 2;
                        break;
                    }
                    case 7: {
                        if (!var1_1.equals("tfw")) {
                            var4_4.append("tfw");
                            break;
                        }
                        break block18;
                    }
                    case 8: {
                        var4_4.append("TFW");
                        break;
                    }
                    default: {
                        break block11;
                    }
                }
                var11_11 = new File(var3_3, var4_4.toString());
                if (var11_11.isFile()) {
                    return var11_11;
                }
                var4_4.setLength(var5_5);
                if (var10_10 == 0) {
                    var7_7 = var11_11;
                }
            }
            ++var10_10;
        }
        return var7_7;
    }

    public static Object changeExtension(Object object, String string) throws IOException {
        if (object != null) {
            boolean bl = string.equals("tfw");
            if (bl) {
                string = SupportFiles.toSuffixTFW(object);
            }
            if (object instanceof File) {
                return SupportFiles.toSupportFile((File)object, string, bl);
            }
            Object object2 = IOUtilities.changeExtension((Object)object, (String)string);
            if (object2 != null) {
                return object2;
            }
            throw new IIOException(Errors.format((int)226, object.getClass()));
        }
        return object;
    }

    public static String toSuffixTFW(Object object) {
        String string = IOUtilities.extension((Object)object);
        int n = string.length();
        if (n >= 2) {
            return String.valueOf(new char[]{Character.toLowerCase(string.charAt(0)), Character.toLowerCase(string.charAt(n - 1)), 'w'});
        }
        return "tfw";
    }

    public static void writeTFW(File file, AffineTransform affineTransform) throws IOException {
        String string = SupportFiles.toSuffixTFW(file);
        String string2 = file.getName();
        StringBuilder stringBuilder = new StringBuilder(string2);
        int n = string2.lastIndexOf(46);
        if (n >= 0) {
            stringBuilder.setLength(n + 1);
        } else {
            stringBuilder.append('.');
        }
        file = new File(file.getParent(), stringBuilder.append(string).toString());
        SupportFiles.writeTFW(new FileOutputStream(file), affineTransform);
    }

    public static void writeTFW(OutputStream outputStream, AffineTransform affineTransform) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, ENCODING));
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        for (int i = 0; i < dArray.length; ++i) {
            bufferedWriter.write(String.valueOf(dArray[i]));
            bufferedWriter.newLine();
        }
        bufferedWriter.close();
    }

    public static AffineTransform parseTFW(File file) throws IOException {
        if (!(file = SupportFiles.toSupportFile(file, SupportFiles.toSuffixTFW(file), true)).isFile()) {
            throw new FileNotFoundException(Errors.format((int)64, (Object)file.getName()));
        }
        return SupportFiles.parseTFW(new FileInputStream(file), file.getName());
    }

    public static AffineTransform parseTFW(InputStream inputStream, Object object) throws IOException {
        String string;
        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream, ENCODING));
        double[] dArray = new double[6];
        int n = 0;
        while ((string = lineNumberReader.readLine()) != null) {
            if ((string = string.trim()).isEmpty() || string.charAt(0) == '#') continue;
            if (n >= dArray.length) {
                lineNumberReader.close();
                throw new ContentFormatException(Errors.format((int)66));
            }
            try {
                dArray[n++] = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                lineNumberReader.close();
                throw new ContentFormatException(Errors.format((int)10, (Object)IOUtilities.name((Object)object), (Object)lineNumberReader.getLineNumber()), (Throwable)numberFormatException);
            }
        }
        lineNumberReader.close();
        if (n != dArray.length) {
            throw new EOFException(Errors.format((int)61));
        }
        return new AffineTransform(dArray);
    }
}

