/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.image.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.IIOServiceProvider;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageInputStream;
import org.apache.sis.util.ArraysExt;
import org.geotoolkit.factory.Factories;
import org.geotoolkit.internal.image.io.CheckedImageInputStream;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.lang.Static;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;

public final class Formats
extends Static {
    private Formats() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void selectImageReader(Object object, Locale locale, ReadCall readCall) throws IOException {
        void var9_14;
        void var9_10;
        String string = IOUtilities.extension((Object)object);
        boolean bl = string != null && !string.isEmpty();
        int n = 0;
        LinkedList<ImageReaderSpi> linkedList = new LinkedList<ImageReaderSpi>();
        boolean bl2 = false;
        boolean bl3 = false;
        Object var9_9 = null;
        ImageInputStream imageInputStream = null;
        Object object2 = object;
        block13: while (true) {
            int n2 = 0;
            Iterator iterator = Formats.orderForClassLoader(bl2 ? linkedList.iterator() : IIORegistry.getDefaultInstance().getServiceProviders(ImageReaderSpi.class, true));
            while (iterator.hasNext()) {
                ImageReaderSpi imageReaderSpi;
                block32: {
                    block33: {
                        imageReaderSpi = (ImageReaderSpi)iterator.next();
                        if (bl2) break block33;
                        if (!bl) {
                            linkedList.add(imageReaderSpi);
                            break block32;
                        } else if (ArraysExt.contains((Object[])imageReaderSpi.getFileSuffixes(), (Object)string)) {
                            linkedList.add(n++, imageReaderSpi);
                            break block32;
                        } else {
                            linkedList.add(imageReaderSpi);
                            continue;
                        }
                    }
                    if (bl) {
                        if (n2++ == n) break;
                        iterator.remove();
                    }
                }
                if (!imageReaderSpi.canDecodeInput(object2)) continue;
                ImageReader imageReader = imageReaderSpi.createReaderInstance();
                if (object2 instanceof ImageInputStream) {
                    ((ImageInputStream)object2).mark();
                }
                imageReader.setInput(object2, true, false);
                if (locale != null) {
                    try {
                        imageReader.setLocale(locale);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                try {
                    readCall.read(imageReader);
                    bl3 = true;
                    break block13;
                }
                catch (IOException iOException) {
                    if (var9_10 != null) continue;
                    IOException iOException2 = iOException;
                }
                finally {
                    imageReader.dispose();
                    if (bl3 && object2 != object || !(object2 instanceof ImageInputStream)) continue;
                    try {
                        ((ImageInputStream)object2).reset();
                    }
                    catch (IOException iOException) {
                        if (object2 == object) {
                            throw iOException;
                        }
                        readCall.recoverableException(iOException);
                        ((ImageInputStream)object2).close();
                        imageInputStream = Formats.createImageInputStream(object);
                        object2 = imageInputStream;
                        if (imageInputStream != null) continue;
                        throw iOException;
                    }
                }
            }
            if (object2 instanceof ImageInputStream) {
                if (!bl) break;
                bl = false;
                if (object2 != object) {
                    object2 = object;
                }
            } else if (bl && n == 0) {
                bl = false;
            } else {
                object2 = imageInputStream;
                if (imageInputStream == null) {
                    imageInputStream = Formats.createImageInputStream(object);
                    object2 = imageInputStream;
                    if (imageInputStream == null) {
                        if (!bl) break;
                        bl = false;
                        object2 = object;
                    }
                }
            }
            bl2 = true;
        }
        if (imageInputStream != null) {
            imageInputStream.close();
        }
        if (bl3) return;
        if (var9_10 != null) throw var9_14;
        if (object instanceof File && !((File)object).exists()) {
            FileNotFoundException fileNotFoundException = new FileNotFoundException(Errors.format((int)64, (Object)object));
            throw var9_14;
        }
        IIOException iIOException = new IIOException(Errors.format((int)158));
        throw var9_14;
    }

    public static ImageReaderSpi getReaderByFormatName(String string, Class<? extends ImageReaderSpi> clazz) throws IllegalArgumentException {
        return Formats.getByFormatName(ImageReaderSpi.class, string, clazz);
    }

    public static ImageWriterSpi getWriterByFormatName(String string, Class<? extends ImageWriterSpi> clazz) throws IllegalArgumentException {
        return Formats.getByFormatName(ImageWriterSpi.class, string, clazz);
    }

    private static <T extends ImageReaderWriterSpi> T getByFormatName(Class<T> clazz, String string, Class<? extends T> clazz2) throws IllegalArgumentException {
        if (string == null) {
            return null;
        }
        string = string.trim();
        ImageReaderWriterSpi imageReaderWriterSpi = null;
        boolean bl = string.equalsIgnoreCase("TIFF");
        IIORegistry iIORegistry = IIORegistry.getDefaultInstance();
        Iterator<T> iterator = Formats.orderForClassLoader(iIORegistry.getServiceProviders(clazz, true));
        while (iterator.hasNext()) {
            ImageReaderWriterSpi imageReaderWriterSpi2 = (ImageReaderWriterSpi)iterator.next();
            if (clazz2 != null && clazz2.isInstance(imageReaderWriterSpi2) || !ArraysExt.contains((Object[])imageReaderWriterSpi2.getFormatNames(), (Object)string)) continue;
            if (imageReaderWriterSpi2.getClass().getName().startsWith("com.sun.media.") == bl) {
                return (T)imageReaderWriterSpi2;
            }
            if (imageReaderWriterSpi != null) continue;
            imageReaderWriterSpi = imageReaderWriterSpi2;
        }
        if (imageReaderWriterSpi != null) {
            return (T)imageReaderWriterSpi;
        }
        throw new IllegalArgumentException(Errors.format((int)220, (Object)string));
    }

    public static String getDisplayName(ImageReaderWriterSpi imageReaderWriterSpi) {
        String string = null;
        if (imageReaderWriterSpi != null) {
            int n;
            String[] stringArray = imageReaderWriterSpi.getFormatNames();
            if (stringArray != null) {
                for (String string2 : stringArray) {
                    n = string2.length();
                    if (n == 0) continue;
                    if (string != null) {
                        n -= string.length();
                    }
                    if (n < 0) continue;
                    if (n == 0) {
                        int n2 = 0;
                        int n3 = 0;
                        int n4 = string2.length();
                        while (--n4 >= 0) {
                            if (Character.isUpperCase(string2.charAt(n4))) {
                                ++n2;
                            }
                            if (!Character.isUpperCase(string.charAt(n4))) continue;
                            ++n3;
                        }
                        if (n2 <= n3) continue;
                    }
                    string = string2;
                }
            }
            if (string == null && (stringArray = imageReaderWriterSpi.getMIMETypes()) != null) {
                for (String string2 : stringArray) {
                    n = string2.length();
                    if (n == 0 || string != null && n >= string.length()) continue;
                    string = string2;
                }
            }
        }
        return string;
    }

    public static String[] simplify(String ... stringArray) {
        if (stringArray != null) {
            Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
            int n = 0;
            for (int i = 1; i < stringArray.length; ++i) {
                String string = stringArray[i - 1];
                String string2 = stringArray[i];
                if (!string.equalsIgnoreCase(string2)) {
                    stringArray[n++] = string;
                    continue;
                }
                if (string.compareTo(string2) <= 0) continue;
                stringArray[i - 1] = string2;
                stringArray[i] = string;
            }
            stringArray = (String[])ArraysExt.resize((Object[])stringArray, (int)n);
        }
        return stringArray;
    }

    public static void formatDescription(IIOServiceProvider iIOServiceProvider, Locale locale, StringBuilder stringBuilder) {
        Vocabulary vocabulary = Vocabulary.getResources((Locale)locale);
        String string = iIOServiceProvider.getDescription(locale);
        if (string == null) {
            string = vocabulary.getString(309);
        }
        stringBuilder.append(string);
        string = iIOServiceProvider.getVersion();
        if (string != null) {
            stringBuilder.append(" (").append(vocabulary.getString(322, (Object)string));
            string = iIOServiceProvider.getVendorName();
            if (string != null) {
                stringBuilder.append(", ").append(string);
            }
            stringBuilder.append(')');
        }
    }

    public static ImageInputStream createUncachedImageInputStream(Object object) throws IOException {
        ImageInputStreamSpi imageInputStreamSpi = null;
        Iterator<ImageInputStreamSpi> iterator = Formats.orderForClassLoader(IIORegistry.getDefaultInstance().getServiceProviders(ImageInputStreamSpi.class, true));
        while (iterator.hasNext()) {
            ImageInputStreamSpi imageInputStreamSpi2 = iterator.next();
            if (!imageInputStreamSpi2.getInputClass().isInstance(object)) continue;
            if (!imageInputStreamSpi2.needsCacheFile()) {
                return imageInputStreamSpi2.createInputStreamInstance(object, false, ImageIO.getCacheDirectory());
            }
            if (imageInputStreamSpi != null) continue;
            imageInputStreamSpi = imageInputStreamSpi2;
        }
        if (imageInputStreamSpi != null) {
            return imageInputStreamSpi.createInputStreamInstance(object, false, ImageIO.getCacheDirectory());
        }
        return null;
    }

    private static ImageInputStream createImageInputStream(Object object) throws IOException {
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(object);
        assert (CheckedImageInputStream.isValid(imageInputStream = CheckedImageInputStream.wrap(imageInputStream)));
        return imageInputStream;
    }

    private static <T> Iterator<T> orderForClassLoader(Iterator<T> iterator) {
        return Factories.orderForClassLoader((ClassLoader)Formats.class.getClassLoader(), iterator);
    }

    public static interface ReadCall {
        public void read(ImageReader var1) throws IOException;

        public void recoverableException(Throwable var1);
    }
}

