/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.image.io;

import javax.imageio.metadata.IIOMetadata;
import org.geotoolkit.image.io.metadata.MetadataNodeAccessor;
import org.opengis.metadata.extent.GeographicBoundingBox;

public class DiscoveryAccessor {
    public static final String ROOT = "DiscoveryMetadata";
    public static final String GEOGRAPHIC_ELEMENT = "DiscoveryMetadata/Extent/GeographicElement";
    private final IIOMetadata metadata;

    public DiscoveryAccessor(IIOMetadata iIOMetadata) {
        this.metadata = iIOMetadata;
    }

    public void setGeographicElement(GeographicBoundingBox geographicBoundingBox) {
        if (geographicBoundingBox != null) {
            MetadataNodeAccessor metadataNodeAccessor = new MetadataNodeAccessor(this.metadata, GEOGRAPHIC_ELEMENT);
            metadataNodeAccessor.setAttribute("westBoundLongitude", this.nice(geographicBoundingBox.getWestBoundLongitude()));
            metadataNodeAccessor.setAttribute("eastBoundLongitude", this.nice(geographicBoundingBox.getEastBoundLongitude()));
            metadataNodeAccessor.setAttribute("southBoundLatitude", this.nice(geographicBoundingBox.getSouthBoundLatitude()));
            metadataNodeAccessor.setAttribute("northBoundLatitude", this.nice(geographicBoundingBox.getNorthBoundLatitude()));
            metadataNodeAccessor.setAttribute("inclusion", geographicBoundingBox.getInclusion());
        }
    }

    protected double nice(double d) {
        return d;
    }
}

