/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.plugin;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Logger;
import javax.imageio.IIOException;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import org.apache.sis.util.Localized;
import org.geotoolkit.image.io.ImageWriterAdapter;
import org.geotoolkit.image.io.InformationType;
import org.geotoolkit.image.io.metadata.MetadataHelper;
import org.geotoolkit.image.io.metadata.SpatialMetadata;
import org.geotoolkit.image.io.plugin.WorldFileImageReader;
import org.geotoolkit.internal.image.io.Formats;
import org.geotoolkit.internal.image.io.SupportFiles;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.io.wkt.PrjFiles;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.logging.Logging;
import org.opengis.coverage.grid.RectifiedGrid;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ImageCRS;

public class WorldFileImageWriter
extends ImageWriterAdapter {
    public WorldFileImageWriter(Spi spi) throws IOException {
        super(spi);
    }

    public WorldFileImageWriter(Spi spi, ImageWriter imageWriter) {
        super(spi, imageWriter);
    }

    @Override
    protected Object createOutput(String string) throws IOException {
        if ("main".equalsIgnoreCase(string)) {
            return super.createOutput(string);
        }
        ImageWriterSpi imageWriterSpi = this.originatingProvider;
        if (imageWriterSpi instanceof Spi && ((Spi)imageWriterSpi).exclude(string)) {
            return null;
        }
        Object object = this.output;
        if ("tfw".equalsIgnoreCase(string)) {
            string = SupportFiles.toSuffixTFW(object);
        }
        return IOUtilities.changeExtension((Object)object, (String)string);
    }

    @Override
    protected void writeImageMetadata(IIOMetadata iIOMetadata, int n, ImageWriteParam imageWriteParam) throws IOException {
        if (n != 0) {
            throw new IIOException(Errors.getResources((Locale)this.locale).getString(96, (Object)n));
        }
        if (iIOMetadata instanceof SpatialMetadata) {
            Object object;
            Object object2;
            MetadataHelper metadataHelper;
            SpatialMetadata spatialMetadata = (SpatialMetadata)iIOMetadata;
            RectifiedGrid rectifiedGrid = spatialMetadata.getInstanceForType(RectifiedGrid.class);
            if (rectifiedGrid != null) {
                metadataHelper = new MetadataHelper((Localized)spatialMetadata);
                object2 = metadataHelper.getAffineTransform(rectifiedGrid, imageWriteParam);
                object = this.createOutput("tfw");
                if (object != null) {
                    OutputStream outputStream = IOUtilities.openWrite((Object)object);
                    SupportFiles.writeTFW(outputStream, (AffineTransform)object2);
                    outputStream.close();
                }
            }
            if ((metadataHelper = spatialMetadata.getInstanceForType(CoordinateReferenceSystem.class)) != null && !(metadataHelper instanceof ImageCRS) && (object2 = this.createOutput("prj")) != null) {
                object = IOUtilities.openWrite((Object)object2);
                PrjFiles.write((CoordinateReferenceSystem)metadataHelper, (OutputStream)object);
                ((OutputStream)object).close();
            }
        }
    }

    private static final class ASC
    extends Spi {
        ASC() {
            super("ASCII-Grid", "org.geotoolkit.image.io.plugin.WorldFileImageReader$ASC");
        }

        @Override
        boolean exclude(String string) {
            return "tfw".equalsIgnoreCase(string);
        }
    }

    private static final class TXT
    extends Spi {
        TXT() {
            super("matrix", "org.geotoolkit.image.io.plugin.WorldFileImageReader$TXT");
        }
    }

    private static final class BMP
    extends Spi {
        BMP() {
            super("BMP", "org.geotoolkit.image.io.plugin.WorldFileImageReader$BMP");
        }
    }

    private static final class GIF
    extends Spi {
        GIF() {
            super("GIF", "org.geotoolkit.image.io.plugin.WorldFileImageReader$GIF");
        }
    }

    private static final class PNG
    extends Spi {
        PNG() {
            super("PNG", "org.geotoolkit.image.io.plugin.WorldFileImageReader$PNG");
        }
    }

    private static final class JPEG
    extends Spi {
        JPEG() {
            super("JPEG", "org.geotoolkit.image.io.plugin.WorldFileImageReader$JPEG");
        }
    }

    private static final class TIFF
    extends Spi {
        TIFF() {
            super("TIFF", "org.geotoolkit.image.io.plugin.WorldFileImageReader$TIFF");
        }
    }

    public static class Spi
    extends ImageWriterAdapter.Spi {
        public Spi(ImageWriterSpi imageWriterSpi) {
            super(imageWriterSpi);
            this.pluginClassName = "org.geotoolkit.image.io.plugin.WorldFileImageWriter";
            this.addFormatNameSuffix("-wf");
            this.addExtraMetadataFormat("geotk-coverageio_3.07", false, true);
        }

        public Spi(String string) throws IllegalArgumentException {
            this(Formats.getWriterByFormatName(string, Spi.class));
        }

        protected Spi(String string, String string2) throws IllegalArgumentException {
            this(string);
            this.readerSpiNames = new String[]{string2};
        }

        @Override
        public String getDescription(Locale locale) {
            return Vocabulary.getResources((Locale)locale).getString(150, (Object)1, (Object)Formats.getDisplayName(this.main));
        }

        boolean exclude(String string) {
            return false;
        }

        @Override
        public Set<InformationType> getModifiedInformation(ImageTypeSpecifier imageTypeSpecifier) {
            return WorldFileImageReader.Spi.INFO;
        }

        @Override
        public ImageWriter createWriterInstance(Object object) throws IOException {
            return new WorldFileImageWriter(this, this.main.createWriterInstance(object));
        }

        public static void registerDefaults(ServiceRegistry serviceRegistry) {
            if (serviceRegistry == null) {
                serviceRegistry = IIORegistry.getDefaultInstance();
            }
            int n = 0;
            while (true) {
                block13: {
                    Spi spi;
                    try {
                        switch (n) {
                            case 0: {
                                spi = new TIFF();
                                break;
                            }
                            case 1: {
                                spi = new JPEG();
                                break;
                            }
                            case 2: {
                                spi = new PNG();
                                break;
                            }
                            case 3: {
                                spi = new GIF();
                                break;
                            }
                            case 4: {
                                spi = new BMP();
                                break;
                            }
                            case 5: {
                                spi = new TXT();
                                break;
                            }
                            case 6: {
                                spi = new ASC();
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        Logging.recoverableException((Logger)Logging.getLogger((String)"org.geotoolkit.image.io"), Spi.class, (String)"registerDefaults", (Throwable)runtimeException);
                        break block13;
                    }
                    serviceRegistry.registerServiceProvider(spi, ImageWriterSpi.class);
                    serviceRegistry.setOrdering(ImageWriterSpi.class, spi.main, spi);
                }
                ++n;
            }
        }

        public static void unregisterDefaults(ServiceRegistry serviceRegistry) {
            if (serviceRegistry == null) {
                serviceRegistry = IIORegistry.getDefaultInstance();
            }
            int n = 0;
            while (true) {
                Class clazz;
                switch (n) {
                    case 0: {
                        clazz = TIFF.class;
                        break;
                    }
                    case 1: {
                        clazz = JPEG.class;
                        break;
                    }
                    case 2: {
                        clazz = PNG.class;
                        break;
                    }
                    case 3: {
                        clazz = GIF.class;
                        break;
                    }
                    case 4: {
                        clazz = BMP.class;
                        break;
                    }
                    case 5: {
                        clazz = TXT.class;
                        break;
                    }
                    case 6: {
                        clazz = ASC.class;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                Spi spi = serviceRegistry.getServiceProviderByClass(clazz);
                if (spi != null) {
                    serviceRegistry.deregisterServiceProvider(spi, ImageWriterSpi.class);
                }
                ++n;
            }
        }
    }
}

