/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.plugin;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Logger;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import org.geotoolkit.image.io.ImageReaderAdapter;
import org.geotoolkit.image.io.InformationType;
import org.geotoolkit.image.io.metadata.ReferencingBuilder;
import org.geotoolkit.image.io.metadata.SpatialMetadata;
import org.geotoolkit.internal.image.io.Formats;
import org.geotoolkit.internal.image.io.GridDomainAccessor;
import org.geotoolkit.internal.image.io.SupportFiles;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.io.wkt.PrjFiles;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.logging.Logging;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WorldFileImageReader
extends ImageReaderAdapter {
    private boolean inputReplaced;

    public WorldFileImageReader(Spi spi) throws IOException {
        super(spi);
    }

    public WorldFileImageReader(Spi spi, ImageReader imageReader) {
        super(spi, imageReader);
    }

    @Override
    protected Object createInput(String string) throws IOException {
        if ("main".equalsIgnoreCase(string)) {
            return super.createInput(string);
        }
        ImageReaderSpi imageReaderSpi = this.originatingProvider;
        if (imageReaderSpi instanceof Spi && ((Spi)imageReaderSpi).exclude(string)) {
            return null;
        }
        return SupportFiles.changeExtension(this.input, string);
    }

    private Object getVerifiedInput(String string) throws IOException {
        Object object;
        if (!this.inputReplaced) {
            this.input = IOUtilities.tryToFile((Object)this.input);
            this.inputReplaced = true;
        }
        if ((object = this.createInput(string)) instanceof File && !((File)object).isFile()) {
            object = null;
        }
        return object;
    }

    @Override
    protected SpatialMetadata createMetadata(int n) throws IOException {
        SpatialMetadata spatialMetadata = super.createMetadata(n);
        if (n >= 0) {
            AffineTransform affineTransform = null;
            CoordinateReferenceSystem coordinateReferenceSystem = null;
            Object object = this.getVerifiedInput("tfw");
            if (object != null) {
                affineTransform = SupportFiles.parseTFW(IOUtilities.open((Object)object), object);
            }
            if ((object = this.getVerifiedInput("prj")) != null) {
                coordinateReferenceSystem = PrjFiles.read((InputStream)IOUtilities.open((Object)object), (boolean)true);
            }
            if (affineTransform != null || coordinateReferenceSystem != null) {
                if (spatialMetadata == null) {
                    spatialMetadata = new SpatialMetadata(false, (ImageReader)this, null);
                }
                if (affineTransform != null) {
                    int n2 = this.getWidth(n);
                    int n3 = this.getHeight(n);
                    new GridDomainAccessor(spatialMetadata).setAll(affineTransform, new Rectangle(n2, n3), null, PixelOrientation.UPPER_LEFT);
                }
                if (coordinateReferenceSystem != null) {
                    new ReferencingBuilder(spatialMetadata).setCoordinateReferenceSystem(coordinateReferenceSystem);
                }
            }
        }
        return spatialMetadata;
    }

    @Override
    protected void close() throws IOException {
        this.inputReplaced = false;
        super.close();
    }

    private static final class Records
    extends Spi {
        Records() {
            super("records");
        }

        @Override
        boolean exclude(String string) {
            return "tfw".equalsIgnoreCase(string);
        }
    }

    private static final class ASC
    extends Spi {
        ASC() {
            super("ASCII-Grid", "org.geotoolkit.image.io.plugin.WorldFileImageWriter$ASC");
        }

        @Override
        boolean exclude(String string) {
            return "tfw".equalsIgnoreCase(string);
        }
    }

    private static final class TXT
    extends Spi {
        TXT() {
            super("matrix", "org.geotoolkit.image.io.plugin.WorldFileImageWriter$TXT");
        }
    }

    private static final class BMP
    extends Spi {
        BMP() {
            super("BMP", "org.geotoolkit.image.io.plugin.WorldFileImageWriter$BMP");
        }
    }

    private static final class GIF
    extends Spi {
        GIF() {
            super("GIF", "org.geotoolkit.image.io.plugin.WorldFileImageWriter$GIF");
        }
    }

    private static final class PNG
    extends Spi {
        PNG() {
            super("PNG", "org.geotoolkit.image.io.plugin.WorldFileImageWriter$PNG");
        }
    }

    private static final class JPEG
    extends Spi {
        JPEG() {
            super("JPEG", "org.geotoolkit.image.io.plugin.WorldFileImageWriter$JPEG");
        }
    }

    private static final class TIFF
    extends Spi {
        TIFF() {
            super("TIFF", "org.geotoolkit.image.io.plugin.WorldFileImageWriter$TIFF");
        }
    }

    public static class Spi
    extends ImageReaderAdapter.Spi {
        static final String NAME_SUFFIX = "-wf";
        static final Set<InformationType> INFO = Collections.singleton(InformationType.IMAGE_METADATA);

        public Spi(ImageReaderSpi imageReaderSpi) {
            super(imageReaderSpi);
            this.pluginClassName = "org.geotoolkit.image.io.plugin.WorldFileImageReader";
            this.addFormatNameSuffix(NAME_SUFFIX);
            this.addExtraMetadataFormat("geotk-coverageio_3.07", false, true);
        }

        public Spi(String string) throws IllegalArgumentException {
            this(Formats.getReaderByFormatName(string, Spi.class));
        }

        protected Spi(String string, String string2) throws IllegalArgumentException {
            this(string);
            this.writerSpiNames = new String[]{string2};
        }

        @Override
        public String getDescription(Locale locale) {
            return Vocabulary.getResources((Locale)locale).getString(150, (Object)0, (Object)Formats.getDisplayName(this.main));
        }

        boolean exclude(String string) {
            return false;
        }

        private boolean exists(Object object, String string) throws IOException {
            Object object2;
            if (!this.exclude(string) && (object2 = SupportFiles.changeExtension(object, string)) instanceof File) {
                return ((File)object2).isFile();
            }
            return false;
        }

        @Override
        public boolean canDecodeInput(Object object) throws IOException {
            if (IOUtilities.canProcessAsPath((Object)object) && (this.exists(object = IOUtilities.tryToFile((Object)object), "tfw") || this.exists(object, "prj"))) {
                return super.canDecodeInput(object);
            }
            return false;
        }

        @Override
        public Set<InformationType> getModifiedInformation(Object object) throws IOException {
            return INFO;
        }

        @Override
        public ImageReader createReaderInstance(Object object) throws IOException {
            return new WorldFileImageReader(this, this.main.createReaderInstance(object));
        }

        public static void registerDefaults(ServiceRegistry serviceRegistry) {
            if (serviceRegistry == null) {
                serviceRegistry = IIORegistry.getDefaultInstance();
            }
            int n = 0;
            while (true) {
                block14: {
                    Spi spi;
                    try {
                        switch (n) {
                            case 0: {
                                spi = new TIFF();
                                break;
                            }
                            case 1: {
                                spi = new JPEG();
                                break;
                            }
                            case 2: {
                                spi = new PNG();
                                break;
                            }
                            case 3: {
                                spi = new GIF();
                                break;
                            }
                            case 4: {
                                spi = new BMP();
                                break;
                            }
                            case 5: {
                                spi = new TXT();
                                break;
                            }
                            case 6: {
                                spi = new ASC();
                                break;
                            }
                            case 7: {
                                spi = new Records();
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        Logging.recoverableException((Logger)Logging.getLogger((String)"org.geotoolkit.image.io"), Spi.class, (String)"registerDefaults", (Throwable)runtimeException);
                        break block14;
                    }
                    serviceRegistry.registerServiceProvider(spi, ImageReaderSpi.class);
                    serviceRegistry.setOrdering(ImageReaderSpi.class, spi, spi.main);
                }
                ++n;
            }
        }

        public static void unregisterDefaults(ServiceRegistry serviceRegistry) {
            if (serviceRegistry == null) {
                serviceRegistry = IIORegistry.getDefaultInstance();
            }
            int n = 0;
            while (true) {
                Class clazz;
                switch (n) {
                    case 0: {
                        clazz = TIFF.class;
                        break;
                    }
                    case 1: {
                        clazz = JPEG.class;
                        break;
                    }
                    case 2: {
                        clazz = PNG.class;
                        break;
                    }
                    case 3: {
                        clazz = GIF.class;
                        break;
                    }
                    case 4: {
                        clazz = BMP.class;
                        break;
                    }
                    case 5: {
                        clazz = TXT.class;
                        break;
                    }
                    case 6: {
                        clazz = ASC.class;
                        break;
                    }
                    case 7: {
                        clazz = Records.class;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                Spi spi = serviceRegistry.getServiceProviderByClass(clazz);
                if (spi != null) {
                    serviceRegistry.deregisterServiceProvider(spi, ImageReaderSpi.class);
                }
                ++n;
            }
        }
    }
}

