/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.plugin;

import java.util.Arrays;
import javax.imageio.IIOException;
import org.apache.sis.util.ArraysExt;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;

final class TextRecordList {
    private final double[] min;
    private final double[] max;
    private final int[] pointCount;
    private float[] data;
    final int xColumn;
    final int yColumn;
    final int columnCount;
    private int upper;
    private final float gridTolerance;

    public TextRecordList(double[] dArray, int n, int n2, int n3, float f) {
        this.min = (double[])dArray.clone();
        this.max = (double[])dArray.clone();
        this.xColumn = n2;
        this.yColumn = n3;
        this.columnCount = dArray.length;
        for (int i = 0; i < dArray.length; ++i) {
            if (!Double.isNaN(dArray[i])) continue;
            this.min[i] = Double.POSITIVE_INFINITY;
            this.max[i] = Double.NEGATIVE_INFINITY;
        }
        this.data = new float[this.columnCount * n];
        this.pointCount = new int[dArray.length];
        this.gridTolerance = f;
    }

    public void add(double[] dArray) {
        int n = Math.min(this.columnCount, dArray.length);
        int n2 = this.upper + this.columnCount;
        if (n2 >= this.data.length) {
            this.data = Arrays.copyOf(this.data, n2 * 2);
        }
        for (int i = 0; i < n; ++i) {
            double d = dArray[i];
            if (d < this.min[i]) {
                this.min[i] = d;
            }
            if (d > this.max[i]) {
                this.max[i] = d;
            }
            this.data[this.upper + i] = (float)d;
        }
        Arrays.fill(this.data, this.upper + n, n2, Float.NaN);
        this.upper = n2;
    }

    public void trimToSize() {
        this.data = ArraysExt.resize((float[])this.data, (int)this.upper);
    }

    final float[] getData() {
        return this.data;
    }

    final int getDataCount() {
        return this.upper;
    }

    public int getLineCount() {
        assert (this.upper % this.columnCount == 0);
        return this.upper / this.columnCount;
    }

    public int getNumBands() {
        return this.columnCount - (this.xColumn == this.yColumn ? 1 : 2);
    }

    public int getColumnForBand(int n) {
        if (n >= this.xColumn) {
            ++n;
        }
        if (n >= this.yColumn) {
            ++n;
        }
        return n;
    }

    public double getMinimum(int n) {
        double d = this.min[n];
        return d <= this.max[n] ? d : Double.NaN;
    }

    public double getMaximum(int n) {
        double d = this.max[n];
        return this.min[n] <= d ? d : Double.NaN;
    }

    private float getInterval(int n) throws IIOException {
        float f;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        float[] fArray = new float[this.getLineCount()];
        for (n4 = n; n4 < this.upper; n4 += this.columnCount) {
            fArray[n5++] = this.data[n4];
        }
        assert (n5 == fArray.length);
        Arrays.sort(fArray);
        n4 = n5 - 1;
        int n6 = n5;
        while (--n6 >= 1) {
            if (fArray[n4] == fArray[n6 - 1]) continue;
            if (n4 != n6) {
                System.arraycopy(fArray, n4, fArray, n6, n5 - n4);
                n3 = n5;
                Arrays.fill(fArray, n5 -= n4 - n6, n3, Float.NaN);
            }
            n4 = n6 - 1;
        }
        if (n4 != n6) {
            System.arraycopy(fArray, n4, fArray, n6, n5 - n4);
            n3 = n5;
            Arrays.fill(fArray, n5 -= n4 - n6, n3, Float.NaN);
        }
        float f2 = Float.POSITIVE_INFINITY;
        for (n2 = 1; n2 < n5; ++n2) {
            f = fArray[n2] - fArray[n2 - 1];
            assert (f > 0.0f);
            if (!(f < f2)) continue;
            f2 = f;
        }
        for (n2 = 1; n2 < n5; ++n2) {
            f = (fArray[n2] - fArray[n2 - 1]) / f2;
            float f3 = (float)Math.rint(f);
            if (!(Math.abs(f - f3) > f3 * this.gridTolerance)) continue;
            throw new IIOException(Errors.format((int)144));
        }
        return f2;
    }

    public int getPointCount(int n) throws IIOException {
        int n2 = this.pointCount[n];
        if (n2 == 0) {
            this.pointCount[n] = n2 = (int)Math.round((this.getMaximum(n) - this.getMinimum(n)) / (double)this.getInterval(n)) + 1;
        }
        return n2;
    }

    public String toString() {
        Object object;
        Object object2;
        int n = this.pointCount[this.xColumn];
        int n2 = this.pointCount[this.yColumn];
        try {
            object2 = this.getPointCount(this.xColumn);
        }
        catch (IIOException iIOException) {
            object2 = iIOException.getLocalizedMessage();
        }
        try {
            object = this.getPointCount(this.yColumn);
        }
        catch (IIOException iIOException) {
            object = iIOException.getLocalizedMessage();
        }
        this.pointCount[this.xColumn] = n;
        this.pointCount[this.yColumn] = n2;
        return Vocabulary.format((int)235, (Object)this.upper, (Object)object2, (Object)object);
    }
}

