/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.plugin;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import org.geotoolkit.image.io.SampleConverter;
import org.geotoolkit.image.io.TextImageReader;
import org.geotoolkit.image.io.metadata.SpatialMetadata;
import org.geotoolkit.image.io.plugin.TextMatrixImageReader;
import org.geotoolkit.image.io.plugin.TextRecordList;
import org.geotoolkit.internal.image.io.DimensionAccessor;
import org.geotoolkit.internal.image.io.GridDomainAccessor;
import org.geotoolkit.internal.io.LineReader;
import org.geotoolkit.io.LineFormat;
import org.geotoolkit.resources.Descriptions;
import org.geotoolkit.resources.Errors;

public class TextRecordImageReader
extends TextImageReader {
    private static final float EPS = 1.0E-5f;
    private static final int PROGRESS_INTERVAL = 4096;
    private static final boolean CLEAR = true;
    private TextRecordList[] data;
    private int nextImageIndex;

    public TextRecordImageReader(Spi spi) {
        super(spi);
    }

    private float getGridTolerance() {
        return this.originatingProvider instanceof Spi ? ((Spi)this.originatingProvider).gridTolerance : 1.0E-5f;
    }

    protected int getColumnX(int n) throws IOException {
        return this.originatingProvider instanceof Spi ? ((Spi)this.originatingProvider).xColumn : 0;
    }

    protected int getColumnY(int n) throws IOException {
        return this.originatingProvider instanceof Spi ? ((Spi)this.originatingProvider).yColumn : 1;
    }

    private static void ensurePositive(String string, int n) throws IIOException {
        if (n < 0) {
            throw new IIOException(Errors.format((int)123, (Object)string, (Object)n));
        }
    }

    @Override
    public int getNumBands(int n) throws IOException {
        return this.getRecords(n, false).getNumBands();
    }

    @Override
    public int getWidth(int n) throws IOException {
        TextRecordList textRecordList = this.getRecords(n, false);
        return textRecordList.getPointCount(textRecordList.xColumn);
    }

    @Override
    public int getHeight(int n) throws IOException {
        TextRecordList textRecordList = this.getRecords(n, false);
        return textRecordList.getPointCount(textRecordList.yColumn);
    }

    private long getStreamLength(int n, int n2) throws IOException {
        int n3;
        long l = this.getStreamLength();
        if (l > 0L && (n3 = this.getNumImages(false)) > 0) {
            l = l * (long)(n2 - n + 1) / (long)n3;
        }
        return l;
    }

    private static long getStreamPosition(Reader reader) throws IOException {
        return reader instanceof LineReader ? ((LineReader)reader).getPosition() : -1L;
    }

    @Override
    protected SpatialMetadata createMetadata(int n) throws IOException {
        if (n < 0) {
            return null;
        }
        SpatialMetadata spatialMetadata = new SpatialMetadata(false, (ImageReader)this, null);
        TextRecordList textRecordList = this.getRecords(n, false);
        int n2 = textRecordList.xColumn;
        int n3 = textRecordList.yColumn;
        int n4 = textRecordList.getPointCount(n2);
        int n5 = textRecordList.getPointCount(n3);
        double d = textRecordList.getMinimum(n2);
        double d2 = textRecordList.getMinimum(n3);
        double d3 = textRecordList.getMaximum(n2);
        double d4 = textRecordList.getMaximum(n3);
        double d5 = this.getPadValue(n);
        GridDomainAccessor gridDomainAccessor = new GridDomainAccessor(spatialMetadata);
        gridDomainAccessor.setAll(d, d4, d3, d2, n4, n5, true, null);
        DimensionAccessor dimensionAccessor = new DimensionAccessor(spatialMetadata);
        int n6 = textRecordList.getNumBands();
        for (int i = 0; i < n6; ++i) {
            int n7 = textRecordList.getColumnForBand(i);
            dimensionAccessor.selectChild(dimensionAccessor.appendChild());
            dimensionAccessor.setValueRange(textRecordList.getMinimum(n7), textRecordList.getMaximum(n7));
            dimensionAccessor.setFillSampleValues(d5);
        }
        return spatialMetadata;
    }

    protected void round(double[] dArray) {
    }

    private TextRecordList getRecords(int n, boolean bl) throws IOException {
        Object object;
        this.clearAbortRequest();
        this.checkImageIndex(n);
        if (n >= this.nextImageIndex) {
            this.processImageStarted(n);
            object = this.getReader();
            long l = TextRecordImageReader.getStreamPosition((Reader)object);
            long l2 = this.getStreamLength(this.nextImageIndex, n);
            while (this.nextImageIndex <= n) {
                String string;
                TextRecordList textRecordList;
                if (this.seekForwardOnly) {
                    this.minIndex = this.nextImageIndex;
                }
                if (this.nextImageIndex != 0 && this.data != null && (textRecordList = this.data[this.nextImageIndex - 1]) != null) {
                    if (this.seekForwardOnly) {
                        this.data[this.nextImageIndex - 1] = null;
                    } else {
                        textRecordList.trimToSize();
                    }
                }
                int n2 = 0;
                int n3 = 1;
                double[] dArray = null;
                TextRecordList textRecordList2 = null;
                boolean bl2 = this.nextImageIndex == n || !this.seekForwardOnly;
                int n4 = this.getColumnX(this.nextImageIndex);
                TextRecordImageReader.ensurePositive("x", n4);
                int n5 = this.getColumnY(this.nextImageIndex);
                TextRecordImageReader.ensurePositive("y", n5);
                double d = this.getPadValue(this.nextImageIndex);
                LineFormat lineFormat = this.getLineFormat(this.nextImageIndex);
                while ((string = ((BufferedReader)object).readLine()) != null) {
                    if (this.abortRequested()) {
                        this.processReadAborted();
                        if (!bl || textRecordList2 == null) {
                            throw new IIOException(Errors.format((int)20));
                        }
                        return textRecordList2;
                    }
                    ++n2;
                    if (this.isComment(string)) continue;
                    try {
                        if (lineFormat.setLine(string) == 0) continue;
                        dArray = lineFormat.getValues(dArray);
                    }
                    catch (ParseException parseException) {
                        throw new IIOException(this.getPositionString(parseException.getLocalizedMessage()), parseException);
                    }
                    for (int i = 0; i < dArray.length; ++i) {
                        if (i == n4 || i == n5 || dArray[i] != d) continue;
                        dArray[i] = Double.NaN;
                    }
                    this.round(dArray);
                    if (bl2) {
                        if (textRecordList2 == null) {
                            textRecordList2 = new TextRecordList(dArray, Math.max(8, (int)(l2 / (long)(string.length() + 1)) + 1), n4, n5, this.getGridTolerance());
                        }
                        textRecordList2.add(dArray);
                    }
                    if (n2 < n3) continue;
                    long l3 = TextRecordImageReader.getStreamPosition((Reader)object) - l;
                    this.processImageProgress((float)l3 * (100.0f / (float)l2));
                    n3 += (int)(4096L * (long)n2 / l3);
                }
                if (textRecordList2 != null) {
                    int n6 = textRecordList2.getLineCount();
                    if (n6 < 2) {
                        throw new IIOException(this.getPositionString(Errors.format((int)65)));
                    }
                    if (this.data == null) {
                        this.data = new TextRecordList[n + 1];
                    } else if (this.data.length <= n) {
                        this.data = Arrays.copyOf(this.data, n * 2);
                    }
                    this.data[this.nextImageIndex] = textRecordList2;
                }
                ++this.nextImageIndex;
            }
            this.processImageComplete();
        }
        if (this.data != null && n < this.data.length && (object = this.data[n]) != null) {
            return object;
        }
        throw new IndexOutOfBoundsException(String.valueOf(n));
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int[] nArray;
        int[] nArray2;
        TextRecordList textRecordList = this.getRecords(n, true);
        int n8 = textRecordList.xColumn;
        int n9 = textRecordList.yColumn;
        int n10 = textRecordList.getPointCount(n8);
        int n11 = textRecordList.getPointCount(n9);
        int n12 = textRecordList.getNumBands();
        if (imageReadParam != null) {
            nArray2 = imageReadParam.getSourceBands();
            nArray = imageReadParam.getDestinationBands();
            n7 = imageReadParam.getSourceXSubsampling();
            n6 = imageReadParam.getSourceYSubsampling();
        } else {
            nArray2 = null;
            nArray = null;
            n7 = 1;
            n6 = 1;
        }
        int n13 = nArray != null ? nArray.length : (nArray2 != null ? nArray2.length : n12);
        SampleConverter[] sampleConverterArray = new SampleConverter[n13];
        BufferedImage bufferedImage = this.getDestination(n, imageReadParam, n10, n11, sampleConverterArray);
        TextRecordImageReader.checkReadParamBandSettings(imageReadParam, n12, bufferedImage.getSampleModel().getNumBands());
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        TextRecordImageReader.computeRegions(imageReadParam, n10, n11, bufferedImage, rectangle, rectangle2);
        int n14 = rectangle.x;
        int n15 = rectangle.y;
        int n16 = rectangle.width;
        int n17 = rectangle.height;
        int n18 = rectangle2.x;
        int n19 = rectangle2.y;
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n20 = textRecordList.columnCount;
        int n21 = textRecordList.getDataCount();
        float[] fArray = textRecordList.getData();
        double d = textRecordList.getMinimum(n8);
        double d2 = textRecordList.getMinimum(n9);
        double d3 = textRecordList.getMaximum(n8);
        double d4 = textRecordList.getMaximum(n9);
        double d5 = (double)(n10 - 1) / (d3 - d);
        double d6 = (double)(n11 - 1) / (d4 - d2);
        int n22 = rectangle2.width + n18;
        int n23 = rectangle2.height + n19;
        int n24 = n5 = nArray != null ? nArray.length : n13;
        while (--n5 >= 0) {
            n4 = nArray != null ? nArray[n5] : n5;
            for (n3 = n19; n3 < n23; ++n3) {
                for (n2 = n18; n2 < n22; ++n2) {
                    writableRaster.setSample(n2, n3, n4, Float.NaN);
                }
            }
        }
        int[] nArray3 = new int[nArray2 != null ? nArray2.length : n13];
        for (n23 = 0; n23 < nArray3.length; ++n23) {
            nArray3[n23] = textRecordList.getColumnForBand(nArray2 != null ? nArray2[n23] : n23);
        }
        for (n23 = 0; n23 < n21; n23 += n20) {
            n5 = (int)Math.round(((double)fArray[n23 + n8] - d) * d5) - n14;
            if (n5 < 0 || n5 >= n16 || n5 % n7 != 0 || (n4 = (int)Math.round((d4 - (double)fArray[n23 + n9]) * d6) - n15) < 0 || n4 >= n17 || n4 % n6 != 0) continue;
            n5 = n5 / n7 + n18;
            n4 = n4 / n6 + n19;
            for (n3 = 0; n3 < nArray3.length; ++n3) {
                n2 = nArray != null ? nArray[n3] : n3;
                writableRaster.setSample(n5, n4, n2, sampleConverterArray[n3].convert(fArray[n23 + nArray3[n3]]));
            }
        }
        return bufferedImage;
    }

    @Override
    protected void close() throws IOException {
        this.data = null;
        this.nextImageIndex = 0;
        super.close();
    }

    public static class Spi
    extends TextImageReader.Spi {
        private static final String[] NAMES = new String[]{"records"};
        private static final String[] MIME_TYPES = new String[]{"text/plain"};
        protected int xColumn;
        protected int yColumn;
        protected float gridTolerance = 1.0E-5f;

        public Spi() {
            this.names = NAMES;
            this.MIMETypes = MIME_TYPES;
            this.pluginClassName = "org.geotoolkit.image.io.plugin.TextRecordImageReader";
            this.xColumn = 0;
            this.yColumn = 1;
            this.gridTolerance = 1.0E-5f;
        }

        @Override
        public String getDescription(Locale locale) {
            return Descriptions.getResources((Locale)locale).getString(0);
        }

        @Override
        public ImageReader createReaderInstance(Object object) throws IOException {
            return new TextRecordImageReader(this);
        }

        @Override
        protected boolean isValidContent(double[][] dArray) {
            if (dArray.length < 12 || !super.isValidContent(dArray)) {
                return false;
            }
            TextRecordList textRecordList = new TextRecordList(dArray[0], dArray.length, this.xColumn, this.yColumn, this.gridTolerance);
            for (int i = 1; i < dArray.length; ++i) {
                textRecordList.add(dArray[i]);
            }
            try {
                textRecordList.getPointCount(textRecordList.xColumn);
                textRecordList.getPointCount(textRecordList.yColumn);
            }
            catch (IIOException iIOException) {
                return false;
            }
            return true;
        }

        @Override
        protected boolean isValidColumnCount(int n) {
            return n >= (this.xColumn == this.yColumn ? 2 : 3);
        }

        @Override
        public void onRegistration(ServiceRegistry serviceRegistry, Class<?> clazz) {
            TextMatrixImageReader.Spi spi;
            super.onRegistration(serviceRegistry, clazz);
            if (clazz.equals(ImageReaderSpi.class) && (spi = serviceRegistry.getServiceProviderByClass(TextMatrixImageReader.Spi.class)) != null) {
                serviceRegistry.setOrdering(ImageReaderSpi.class, this, spi);
            }
        }
    }
}

