/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.plugin;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferFloat;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import org.apache.sis.util.ArraysExt;
import org.geotoolkit.image.io.SampleConverter;
import org.geotoolkit.image.io.TextImageReader;
import org.geotoolkit.image.io.metadata.SpatialMetadata;
import org.geotoolkit.internal.image.io.DimensionAccessor;
import org.geotoolkit.io.LineFormat;
import org.geotoolkit.resources.Descriptions;

public class TextMatrixImageReader
extends TextImageReader {
    private float[] data;
    private int width;
    private int height;
    private int expectedHeight;
    private boolean completed;

    protected TextMatrixImageReader(Spi spi) {
        super(spi);
    }

    private boolean load(int n, boolean bl) throws IOException {
        String string;
        this.clearAbortRequest();
        if (bl) {
            this.processImageStarted(n);
        }
        float[] fArray = this.data != null ? new float[this.width] : null;
        int n2 = this.width * this.height;
        BufferedReader bufferedReader = this.getReader();
        LineFormat lineFormat = this.getLineFormat(n);
        while ((string = bufferedReader.readLine()) != null) {
            if (this.isComment(string)) continue;
            try {
                lineFormat.setLine(string);
                fArray = lineFormat.getValues(fArray);
            }
            catch (ParseException parseException) {
                throw new IIOException(this.getPositionString(parseException.getLocalizedMessage()), parseException);
            }
            this.width = fArray.length;
            int n3 = n2 + this.width;
            if (this.data == null) {
                long l = this.getStreamLength();
                if (l >= 0L) {
                    int n4 = string.length() + 1;
                    this.expectedHeight = (int)((l + (long)(n4 / 2)) / (long)n4);
                }
                this.data = new float[Math.max(1024, this.width * this.expectedHeight)];
            } else if (n3 > this.data.length) {
                this.data = Arrays.copyOf(this.data, n3 * 2);
            }
            System.arraycopy(fArray, 0, this.data, n2, this.width);
            n2 = n3;
            ++this.height;
            if (!bl) {
                return false;
            }
            if (this.height <= this.expectedHeight) {
                this.processImageProgress((float)this.height * 100.0f / (float)this.expectedHeight);
            }
            if (!this.abortRequested()) continue;
            this.processReadAborted();
            return true;
        }
        this.data = ArraysExt.resize((float[])this.data, (int)n2);
        this.expectedHeight = this.height;
        this.completed = true;
        if (bl) {
            this.processImageComplete();
        }
        return false;
    }

    @Override
    public int getWidth(int n) throws IOException {
        this.checkImageIndex(n);
        if (this.data == null && !this.completed) {
            this.load(n, false);
        }
        return this.width;
    }

    @Override
    public int getHeight(int n) throws IOException {
        this.checkImageIndex(n);
        if (!this.completed) {
            this.load(n, true);
        }
        return this.height;
    }

    @Override
    protected SpatialMetadata createMetadata(int n) throws IOException {
        if (n >= 0) {
            if ((this.data == null || !this.completed) && this.load(n, true)) {
                return null;
            }
            float f = (float)this.getPadValue(n);
            float f2 = Float.POSITIVE_INFINITY;
            float f3 = Float.NEGATIVE_INFINITY;
            for (int i = 0; i < this.data.length; ++i) {
                float f4 = this.data[i];
                if (f4 == f) continue;
                if (f4 < f2) {
                    f2 = f4;
                }
                if (!(f4 > f3)) continue;
                f3 = f4;
            }
            SpatialMetadata spatialMetadata = new SpatialMetadata(false, (ImageReader)this, null);
            DimensionAccessor dimensionAccessor = new DimensionAccessor(spatialMetadata);
            dimensionAccessor.selectChild(dimensionAccessor.appendChild());
            if (f2 < f3) {
                dimensionAccessor.setValueRange(f2, f3);
            }
            if (!Float.isNaN(f)) {
                dimensionAccessor.setFillSampleValues(f);
            }
            return spatialMetadata;
        }
        return super.createMetadata(n);
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        boolean bl;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int[] nArray;
        int[] nArray2;
        this.checkImageIndex(n);
        TextMatrixImageReader.checkReadParamBandSettings(imageReadParam, 1, 1);
        if (imageReadParam != null) {
            nArray2 = imageReadParam.getSourceBands();
            nArray = imageReadParam.getDestinationBands();
            Point point = imageReadParam.getDestinationOffset();
            n7 = imageReadParam.getSourceXSubsampling();
            n6 = imageReadParam.getSourceYSubsampling();
            n5 = imageReadParam.getSubsamplingXOffset();
            n4 = imageReadParam.getSubsamplingYOffset();
            n3 = point.x;
            n2 = point.y;
        } else {
            nArray2 = null;
            nArray = null;
            n7 = 1;
            n6 = 1;
            n5 = 0;
            n4 = 0;
            n3 = 0;
            n2 = 0;
        }
        int n8 = nArray == null ? 0 : nArray[0];
        Rectangle rectangle = TextMatrixImageReader.getSourceRegion(imageReadParam, this.width, this.height);
        boolean bl2 = bl = n7 == 1 && n6 == 1 && n5 == 0 && n4 == 0 && n3 == 0 && n2 == 0 && rectangle.x == 0 && rectangle.width == this.width && rectangle.y == 0 && rectangle.height == this.height;
        if ((this.data == null || !this.completed) && this.load(n, true)) {
            return null;
        }
        float[] fArray = this.data;
        int n9 = this.width;
        int n10 = this.height;
        SampleConverter[] sampleConverterArray = new SampleConverter[1];
        ImageTypeSpecifier imageTypeSpecifier = this.getImageType(n, imageReadParam, sampleConverterArray);
        SampleConverter sampleConverter = sampleConverterArray[0];
        if (bl && (imageReadParam == null || imageReadParam.getDestination() == null) && imageTypeSpecifier.getSampleModel().getDataType() == 4) {
            if (!SampleConverter.IDENTITY.equals(sampleConverter)) {
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = sampleConverter.convert(fArray[i]);
                }
            }
            SampleModel sampleModel = imageTypeSpecifier.getSampleModel(n9, n10);
            DataBufferFloat dataBufferFloat = new DataBufferFloat(fArray, fArray.length);
            WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, dataBufferFloat, null);
            this.data = null;
            this.minIndex = n + 1;
            return new BufferedImage(imageTypeSpecifier.getColorModel(), writableRaster, false, null);
        }
        BufferedImage bufferedImage = TextMatrixImageReader.getDestination(imageReadParam, Collections.singleton(imageTypeSpecifier).iterator(), n9, n10);
        WritableRaster writableRaster = bufferedImage.getRaster();
        Rectangle rectangle2 = new Rectangle();
        TextMatrixImageReader.computeRegions(imageReadParam, n9, n10, bufferedImage, rectangle, rectangle2);
        int n11 = rectangle2.x;
        int n12 = rectangle2.y;
        int n13 = rectangle2.width + n11;
        int n14 = rectangle2.height + n12;
        int n15 = rectangle.y;
        for (int i = n12; i < n14; ++i) {
            assert (n15 < rectangle.y + rectangle.height);
            int n16 = n15 * n9;
            int n17 = rectangle.x;
            for (int j = n11; j < n13; ++j) {
                assert (n17 < rectangle.x + rectangle.width);
                float f = sampleConverter.convert(fArray[n16 + n17]);
                writableRaster.setSample(j, i, n8, f);
                n17 += n7;
            }
            n15 += n6;
        }
        return bufferedImage;
    }

    @Override
    protected void close() throws IOException {
        this.completed = false;
        this.data = null;
        this.width = 0;
        this.height = 0;
        this.expectedHeight = 0;
        super.close();
    }

    public static class Spi
    extends TextImageReader.Spi {
        static final String[] NAMES = new String[]{"matrix"};
        static final String[] MIME_TYPES = new String[]{"text/plain", "text/x-matrix"};
        private static final String[] WRITERS = new String[]{"org.geotoolkit.image.io.plugin.TextMatrixImageWriter$Spi"};

        public Spi() {
            this.names = NAMES;
            this.MIMETypes = MIME_TYPES;
            this.pluginClassName = "org.geotoolkit.image.io.plugin.TextMatrixImageReader";
            this.writerSpiNames = WRITERS;
            this.nativeStreamMetadataFormatName = null;
        }

        @Override
        public String getDescription(Locale locale) {
            return Descriptions.getResources((Locale)locale).getString(1);
        }

        @Override
        public ImageReader createReaderInstance(Object object) throws IOException {
            return new TextMatrixImageReader(this);
        }
    }
}

