/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.plugin;

import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.util.ArraysExt;
import org.geotoolkit.image.SampleModels;
import org.geotoolkit.image.io.SpatialImageReader;
import org.geotoolkit.image.io.UnsupportedImageFormatException;
import org.geotoolkit.lang.SystemOverride;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.logging.Logging;

public class RawTiffImageReader
extends SpatialImageReader {
    private static final int IFD_SIZE = 1024;
    private static final int SIZE_ENTRY = 12;
    private static final int SIZE_BIG_ENTRY = 20;
    private static final int SIZE_SHORT = 2;
    private static final int SIZE_BIG_SHORT = 8;
    private static final int SIZE_INT = 4;
    private static final int SIZE_BIG_INT = 8;
    private static final short TYPE_BYTE = 6;
    private static final short TYPE_UBYTE = 1;
    private static final short TYPE_SHORT = 8;
    private static final short TYPE_USHORT = 3;
    private static final short TYPE_INT = 9;
    private static final short TYPE_UINT = 4;
    private static final short TYPE_IFD = 13;
    private static final short TYPE_LONG = 17;
    private static final short TYPE_ULONG = 16;
    private static final short TYPE_IFD8 = 18;
    private static final short TYPE_FLOAT = 11;
    private static final short TYPE_DOUBLE = 12;
    private static final int[] TYPE_SIZE;
    private FileChannel channel;
    private final ByteBuffer buffer = ByteBuffer.allocateDirect(8196);
    private long positionBuffer;
    private long filePosition;
    private long[] positionIFD = new long[4];
    private int countIFD;
    private boolean isBigTIFF;
    private int currentImage = -1;
    private int imageWidth;
    private int imageHeight;
    private int tileWidth;
    private int tileHeight;
    private int samplesPerPixel;
    private long[] bitsPerSample;
    private long[] tileOffsets;
    private ImageTypeSpecifier rawImageType;
    private static final Comparator<long[]> OFFSET_COMPARATOR;

    public RawTiffImageReader(Spi spi) {
        super(spi != null ? spi : new Spi());
    }

    @Override
    public boolean isRandomAccessEasy(int n) throws IOException {
        return true;
    }

    private void open() throws IllegalStateException, IOException {
        if (this.channel == null) {
            ByteOrder byteOrder;
            if (this.input == null) {
                throw new IllegalStateException(this.error(156));
            }
            FileInputStream fileInputStream = this.input instanceof String ? new FileInputStream((String)this.input) : new FileInputStream((File)this.input);
            this.channel = fileInputStream.getChannel();
            this.buffer.clear();
            this.readFully(16, 1024);
            byte by = this.buffer.get();
            if (by != this.buffer.get()) {
                throw this.invalidFile("ByteOrder");
            }
            if (by == 77) {
                byteOrder = ByteOrder.BIG_ENDIAN;
            } else if (by == 73) {
                byteOrder = ByteOrder.LITTLE_ENDIAN;
            } else {
                throw this.invalidFile("ByteOrder");
            }
            short s = this.buffer.order(byteOrder).getShort();
            this.isBigTIFF = s == 43;
            if (this.isBigTIFF) {
                if (this.buffer.getShort() != 8 || this.buffer.getShort() != 0) {
                    throw this.invalidFile("OffsetSize");
                }
            } else if (s != 42) {
                throw this.invalidFile("MagicNumber");
            }
            this.countIFD = 0;
            this.nextImageFileDirectory();
            this.currentImage = -1;
        }
    }

    private void ensureBufferContains(long l, int n, int n2) throws IOException {
        long l2 = l - this.positionBuffer;
        if (l2 >= 0L && l2 < (long)this.buffer.limit()) {
            if (this.buffer.position((int)l2).remaining() < n) {
                int n3 = this.buffer.compact().position();
                if ((l += (long)n3) != this.filePosition) {
                    this.channel.position(l);
                }
                this.readFully(n - n3, Math.max(n, n2) - n3);
            }
        } else {
            this.buffer.clear();
            if (l != this.filePosition) {
                this.channel.position(l);
            }
            this.readFully(n, Math.max(n, n2));
        }
    }

    private void readFully(int n, int n2) throws IOException {
        if ((n2 += this.buffer.position()) < this.buffer.limit()) {
            this.buffer.limit(n2);
        }
        while (n > 0) {
            assert (this.buffer.hasRemaining());
            int n3 = this.channel.read(this.buffer);
            if (n3 < 0) {
                throw new EOFException();
            }
            n -= n3;
        }
        this.filePosition = this.channel.position();
        this.positionBuffer = this.filePosition - (long)this.buffer.position();
        this.buffer.rewind();
    }

    private boolean nextImageFileDirectory() {
        assert (this.countIFD >= 0);
        long l = this.readInt();
        if (l != 0L) {
            if (this.countIFD == this.positionIFD.length) {
                this.positionIFD = Arrays.copyOf(this.positionIFD, Math.max(4, this.countIFD * 2));
            }
            this.positionIFD[this.countIFD++] = l;
            return true;
        }
        this.positionIFD = ArraysExt.resize((long[])this.positionIFD, (int)this.countIFD);
        this.countIFD = -1;
        return false;
    }

    private long readInt() {
        return this.isBigTIFF ? this.buffer.getLong() : (long)this.buffer.getInt() & 0xFFFFFFFFL;
    }

    private long readShort() {
        return this.isBigTIFF ? this.buffer.getLong() : (long)this.buffer.getShort() & 0xFFFFL;
    }

    @Override
    public int getNumImages(boolean bl) throws IOException {
        this.open();
        if (this.countIFD >= 0) {
            int n;
            int n2;
            int n3;
            if (!bl) {
                return -1;
            }
            if (this.isBigTIFF) {
                n3 = 20;
                n2 = 8;
                n = 8;
            } else {
                n3 = 12;
                n2 = 2;
                n = 4;
            }
            do {
                long l = this.positionIFD[this.countIFD - 1];
                this.ensureBufferContains(l, n2, 1024);
                long l2 = this.readShort();
                this.ensureBufferContains((l += (long)n2) + l2 * (long)n3, n, 1024);
            } while (this.nextImageFileDirectory());
        }
        return this.positionIFD.length;
    }

    private void selectImage(int n) throws IOException, IndexOutOfBoundsException {
        if (n != this.currentImage) {
            this.open();
            if (n >= this.minIndex) {
                long l;
                long l2;
                int n2;
                int n3;
                int n4;
                if (this.isBigTIFF) {
                    n4 = 20;
                    n3 = 8;
                    n2 = 8;
                } else {
                    n4 = 12;
                    n3 = 2;
                    n2 = 4;
                }
                if (this.countIFD >= 0) {
                    for (int i = n - this.countIFD; i >= 0; --i) {
                        l2 = this.positionIFD[this.countIFD - 1];
                        this.ensureBufferContains(l2, n3, 1024);
                        l = this.readShort();
                        this.ensureBufferContains((l2 += (long)n3) + l * (long)n4, n2, 1024);
                        if (this.nextImageFileDirectory()) continue;
                        throw new IndexOutOfBoundsException(this.error(96, n));
                    }
                }
                if (n < this.positionIFD.length) {
                    this.imageWidth = -1;
                    this.imageHeight = -1;
                    this.tileWidth = -1;
                    this.tileHeight = -1;
                    this.samplesPerPixel = 0;
                    this.bitsPerSample = null;
                    this.tileOffsets = null;
                    this.rawImageType = null;
                    ArrayList<long[]> arrayList = new ArrayList<long[]>(4);
                    l2 = this.positionIFD[n];
                    this.ensureBufferContains(l2, n3 + n2, 1024);
                    l = this.readShort();
                    l2 += (long)n3;
                    int n5 = 0;
                    while ((long)n5 < l) {
                        this.ensureBufferContains(l2, n4 + n2, 1024);
                        this.parseDirectoryEntries(arrayList);
                        l2 += (long)n4;
                        ++n5;
                    }
                    this.readDeferredArrays((long[][])arrayList.toArray((T[])new long[arrayList.size()][]));
                    this.ensureDefined(this.imageWidth, "imageWidth");
                    this.ensureDefined(this.imageHeight, "imageHeight");
                    this.ensureDefined(this.samplesPerPixel, "samplesPerPixel");
                    this.ensureDefined(this.tileWidth, "tileWidth");
                    this.ensureDefined(this.tileHeight, "tileHeight");
                    this.ensureDefined(this.tileOffsets, "tileOffsets");
                    this.currentImage = n;
                    return;
                }
            }
            throw new IndexOutOfBoundsException(this.error(96, n));
        }
    }

    private void ensureDefined(int n, String string) throws IIOException {
        if (n < 0) {
            throw new IIOException(this.error(166, string));
        }
    }

    private void ensureDefined(long[] lArray, String string) throws IIOException {
        if (lArray == null) {
            throw new IIOException(this.error(166, string));
        }
    }

    private void parseDirectoryEntries(Collection<long[]> collection) throws IIOException {
        short s = this.buffer.getShort();
        switch (s) {
            case 256: {
                this.imageWidth = this.entryValue("imageWidth");
                break;
            }
            case 257: {
                this.imageHeight = this.entryValue("imageHeight");
                break;
            }
            case 258: {
                this.bitsPerSample = this.entryValues("bitsPerSample", collection);
                break;
            }
            case 277: {
                this.samplesPerPixel = this.entryValue("samplesPerPixel");
                break;
            }
            case 322: {
                this.tileWidth = this.entryValue("tileWidth");
                break;
            }
            case 323: {
                this.tileHeight = this.entryValue("tileHeight");
                break;
            }
            case 324: {
                this.tileOffsets = this.entryValues("tileOffsets", collection);
                break;
            }
            case 284: {
                int n = this.entryValue("PlanarConfiguration");
                if (n == 1) break;
                throw new UnsupportedImageFormatException(this.error(12, "planarConfiguration", n));
            }
            case 262: {
                int n = this.entryValue("photometricInterpretation");
                if (n == 2) break;
                throw new UnsupportedImageFormatException(this.error(12, "photometricInterpretation", n));
            }
            case 259: {
                Object object;
                int n = this.entryValue("compression");
                if (n == 1) break;
                switch (n) {
                    case 6: {
                        object = "JPEG";
                        break;
                    }
                    case 7: {
                        object = "LZW";
                        break;
                    }
                    default: {
                        object = n;
                    }
                }
                throw new UnsupportedImageFormatException(this.error(12, "compression", object));
            }
        }
    }

    private long read(short s) throws IIOException {
        switch (s) {
            case 6: {
                return this.buffer.get();
            }
            case 1: {
                return (long)this.buffer.get() & 0xFFL;
            }
            case 8: {
                return this.buffer.getShort();
            }
            case 3: {
                return (long)this.buffer.getShort() & 0xFFFFL;
            }
            case 9: {
                return this.buffer.getInt();
            }
            case 4: 
            case 13: {
                return (long)this.buffer.getInt() & 0xFFFFFFFFL;
            }
            case 17: {
                return this.buffer.getLong();
            }
            case 16: 
            case 18: {
                long l = this.buffer.getLong();
                if (l < 0L) {
                    throw new UnsupportedImageFormatException(this.error(239));
                }
                return l;
            }
        }
        throw new AssertionError(s);
    }

    private int entryValue(String string) throws IIOException {
        short s = this.buffer.getShort();
        if (this.readInt() != 1L) {
            throw new IIOException(this.error(56, string));
        }
        switch (s) {
            case 6: {
                return this.buffer.get();
            }
            case 1: {
                return this.buffer.get() & 0xFF;
            }
            case 8: {
                return this.buffer.getShort();
            }
            case 3: {
                return this.buffer.getShort() & 0xFFFF;
            }
            case 4: 
            case 9: {
                return this.buffer.getInt();
            }
        }
        throw new IIOException(this.error(13, string, s));
    }

    private long[] entryValues(String string, Collection<long[]> collection) throws IIOException {
        int n;
        int n2;
        short s = this.buffer.getShort();
        long l = this.readInt();
        if (l > Integer.MAX_VALUE) {
            throw new IIOException(this.error(66));
        }
        int n3 = n2 = this.isBigTIFF ? 8 : 4;
        if (s < 0 || s == 11 || s == 12 || (n = TYPE_SIZE[s]) == 0) {
            throw new IIOException(this.error(13, string, s));
        }
        long[] lArray = new long[(int)l];
        if (lArray.length * n <= n2) {
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = this.read(s);
            }
        } else {
            lArray[0] = this.readInt();
            lArray[1] = s;
            collection.add(lArray);
        }
        return lArray;
    }

    private void readDeferredArrays(long[][] lArray) throws IOException {
        Arrays.sort(lArray, OFFSET_COMPARATOR);
        for (long[] lArray2 : lArray) {
            short s = (short)lArray2[1];
            assert ((long)s == lArray2[1]);
            int n = TYPE_SIZE[s];
            long l = lArray2[0];
            int n2 = 0;
            while (n2 < lArray2.length) {
                int n3 = lArray2.length - n2;
                int n4 = n3 * n;
                this.ensureBufferContains(l, Math.min(n4, this.buffer.capacity()), Math.max(n4, 1024));
                n3 = Math.min(n3, this.buffer.remaining() / n);
                l += (long)(n3 * n);
                while (--n3 >= 0) {
                    lArray2[n2++] = this.read(s);
                }
            }
        }
    }

    @Override
    public int getNumBands(int n) throws IOException {
        this.selectImage(n);
        return this.samplesPerPixel;
    }

    @Override
    public int getWidth(int n) throws IOException {
        this.selectImage(n);
        return this.imageWidth;
    }

    @Override
    public int getHeight(int n) throws IOException {
        this.selectImage(n);
        return this.imageHeight;
    }

    @Override
    public int getTileWidth(int n) throws IOException {
        this.selectImage(n);
        return this.tileWidth >= 0 ? this.tileWidth : this.imageWidth;
    }

    @Override
    public int getTileHeight(int n) throws IOException {
        this.selectImage(n);
        return this.tileHeight >= 0 ? this.tileHeight : this.imageHeight;
    }

    @Override
    public boolean isImageTiled(int n) throws IOException {
        this.selectImage(n);
        return this.tileWidth >= 0 && this.tileHeight >= 0;
    }

    private Tile[] getTiles(Rectangle rectangle, int n, int n2, int n3, int n4) {
        int n5 = rectangle.x / this.tileWidth;
        int n6 = rectangle.y / this.tileHeight;
        int n7 = (rectangle.x + rectangle.width + this.tileWidth - 2) / this.tileWidth;
        int n8 = (rectangle.y + rectangle.height + this.tileHeight - 2) / this.tileHeight;
        int n9 = (this.imageWidth + this.tileWidth - 1) / this.tileWidth;
        Object[] objectArray = new Tile[(n7 - n5) * (n8 - n6)];
        int n10 = 0;
        for (int i = n6; i < n8; ++i) {
            int n11 = i * this.tileHeight - rectangle.y;
            int n12 = (Math.max(0, n11) + n2 - 1) / n2;
            int n13 = (Math.min(rectangle.height, n11 + this.tileHeight) - 1) / n2 + 1 - n12;
            int n14 = (n12 * n2 - n11) * n4;
            for (int j = n5; j < n7; ++j) {
                int n15 = j * this.tileWidth - rectangle.x;
                int n16 = (Math.max(0, n15) + n - 1) / n;
                int n17 = (Math.min(rectangle.width, n15 + this.tileWidth) - 1) / n + 1 - n16;
                int n18 = (n16 * n - n15) * n3 + n14;
                int n19 = i * n9 + j;
                objectArray[n10++] = new Tile(n16, n12, n17, n13, this.tileOffsets[n19] + (long)n18);
            }
        }
        assert (n10 == objectArray.length);
        Arrays.sort(objectArray);
        return objectArray;
    }

    @Override
    public boolean hasColors(int n) throws IOException {
        this.selectImage(n);
        return true;
    }

    @Override
    protected int getRawDataType(int n) throws IOException {
        return this.getRawImageType(n).getSampleModel().getDataType();
    }

    @Override
    public ImageTypeSpecifier getRawImageType(int n) throws IOException {
        this.selectImage(n);
        if (this.rawImageType == null) {
            int n2;
            int[] nArray;
            int n3;
            ColorSpace colorSpace = ColorSpace.getInstance(1000);
            long[] lArray = this.bitsPerSample;
            if (lArray != null) {
                n3 = 0;
                nArray = new int[lArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    long l = lArray[i];
                    nArray[i] = (int)l;
                    if ((long)nArray[i] != l) {
                        throw new UnsupportedImageFormatException(this.error(12, "bitsPerSample", l));
                    }
                    if (i != 0 && l != (long)n3) {
                        throw new UnsupportedImageFormatException(this.error(95));
                    }
                    n3 = (int)l;
                }
                switch (n3) {
                    case 8: {
                        n2 = 0;
                        break;
                    }
                    case 16: {
                        n2 = 1;
                        break;
                    }
                    case 32: {
                        n2 = 3;
                        break;
                    }
                    default: {
                        throw new UnsupportedImageFormatException(this.error(12, "bitsPerSample", n3));
                    }
                }
            } else {
                n2 = 0;
                nArray = new int[this.samplesPerPixel != 0 ? this.samplesPerPixel : colorSpace.getNumComponents()];
                Arrays.fill(nArray, 8);
            }
            n3 = nArray.length > colorSpace.getNumComponents() ? 1 : 0;
            ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, nArray, n3 != 0, false, n3 != 0 ? 3 : 1, n2);
            this.rawImageType = new ImageTypeSpecifier(componentColorModel, ((ColorModel)componentColorModel).createCompatibleSampleModel(this.imageWidth, this.imageHeight));
        }
        return this.rawImageType;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        return Collections.singleton(this.getRawImageType(n)).iterator();
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.selectImage(n);
        BufferedImage bufferedImage = RawTiffImageReader.getDestination(imageReadParam, this.getImageTypes(n), this.imageWidth, this.imageHeight);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        RawTiffImageReader.computeRegions(imageReadParam, this.imageWidth, this.imageHeight, bufferedImage, rectangle, rectangle2);
        this.read(bufferedImage.getRaster(), imageReadParam, rectangle, rectangle2);
        return bufferedImage;
    }

    private void read(WritableRaster writableRaster, ImageReadParam imageReadParam, Rectangle rectangle, Rectangle rectangle2) throws IOException {
        Buffer buffer;
        int n;
        int n2;
        int[] nArray;
        int[] nArray2;
        this.clearAbortRequest();
        int n3 = writableRaster.getNumBands();
        RawTiffImageReader.checkReadParamBandSettings(imageReadParam, this.samplesPerPixel, n3);
        if (imageReadParam != null) {
            nArray2 = imageReadParam.getSourceBands();
            nArray = imageReadParam.getDestinationBands();
            n2 = imageReadParam.getSourceXSubsampling();
            n = imageReadParam.getSourceYSubsampling();
        } else {
            nArray2 = null;
            nArray = null;
            n2 = 1;
            n = 1;
        }
        if (nArray2 != null || nArray != null) {
            throw new IIOException("Source and target bands not yet supported.");
        }
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        int[] nArray3 = dataBuffer.getOffsets();
        int n4 = dataBuffer.getDataType();
        int n5 = DataBuffer.getDataTypeSize(n4) / 8;
        int n6 = n5 * this.samplesPerPixel;
        int n7 = n5 * n3;
        int n8 = n6 * this.tileWidth;
        int n9 = SampleModels.getScanlineStride((SampleModel)writableRaster.getSampleModel());
        int n10 = this.buffer.position();
        int n11 = this.buffer.limit();
        this.buffer.clear();
        switch (n4) {
            case 0: {
                buffer = this.buffer.duplicate();
                break;
            }
            case 1: 
            case 2: {
                buffer = this.buffer.asShortBuffer();
                break;
            }
            case 3: {
                buffer = this.buffer.asIntBuffer();
                break;
            }
            case 4: {
                buffer = this.buffer.asFloatBuffer();
                break;
            }
            case 5: {
                buffer = this.buffer.asDoubleBuffer();
                break;
            }
            default: {
                throw new IIOException(this.error(239, dataBuffer.getClass()));
            }
        }
        this.buffer.limit(n11).position(n10);
        n10 = n2 * n6;
        for (n11 = 0; n11 < nArray3.length; ++n11) {
            Object[] objectArray;
            switch (n4) {
                case 0: {
                    objectArray = ((DataBufferByte)dataBuffer).getData(n11);
                    break;
                }
                case 1: {
                    objectArray = ((DataBufferUShort)dataBuffer).getData(n11);
                    break;
                }
                case 2: {
                    objectArray = ((DataBufferShort)dataBuffer).getData(n11);
                    break;
                }
                case 3: {
                    objectArray = ((DataBufferInt)dataBuffer).getData(n11);
                    break;
                }
                case 4: {
                    objectArray = ((DataBufferFloat)dataBuffer).getData(n11);
                    break;
                }
                case 5: {
                    objectArray = ((DataBufferDouble)dataBuffer).getData(n11);
                    break;
                }
                default: {
                    throw new AssertionError(n4);
                }
            }
            int n12 = nArray3[n11] + n9 * rectangle2.y + n7 * rectangle2.x;
            for (Tile tile : this.getTiles(rectangle, n2, n, n6, n8)) {
                int n13 = n12 + n9 * tile.y + n7 * tile.x;
                int n14 = (tile.height - 1) * n8 * n + (tile.width - 1) * n6 * n2 + n6;
                int n15 = tile.width;
                if (tile.width * n7 == n9 && tile.width * n6 == n8 && n == 1) {
                    n15 *= tile.height;
                }
                int n16 = n15;
                int n17 = 0;
                int n18 = 0;
                int n19 = n13;
                while (n18 < n14) {
                    int n20;
                    int n21;
                    int n22;
                    assert (n16 >= 0) : n16;
                    if (n16 == 0) {
                        n16 = n15;
                        n18 = ++n17 * n8 * n;
                        n19 = n17 * n9 + n13;
                        this.ensureBufferContains(tile.position + (long)n18, n6, n14 - n18);
                    } else {
                        n22 = n14 - n18;
                        this.ensureBufferContains(tile.position + (long)n18, Math.min(n22, this.buffer.capacity()), n22);
                    }
                    assert (this.buffer.position() % n5 == 0) : this.buffer;
                    n22 = this.buffer.position() / n5;
                    int n23 = Math.min(n16, (this.buffer.remaining() + n10 - n6) / n10);
                    n16 -= n23;
                    n18 += n23 * n10;
                    if (n2 == 1) {
                        n20 = n21 = n23 * n3;
                        n23 = 1;
                    } else {
                        n20 = n3 * n2;
                        n21 = n3;
                    }
                    do {
                        buffer.position(n22);
                        switch (n4) {
                            case 0: {
                                ((ByteBuffer)buffer).get((byte[])objectArray, n19, n21);
                                break;
                            }
                            case 1: 
                            case 2: {
                                ((ShortBuffer)buffer).get((short[])objectArray, n19, n21);
                                break;
                            }
                            case 3: {
                                ((IntBuffer)buffer).get((int[])objectArray, n19, n21);
                                break;
                            }
                            case 4: {
                                ((FloatBuffer)buffer).get((float[])objectArray, n19, n21);
                                break;
                            }
                            case 5: {
                                ((DoubleBuffer)buffer).get((double[])objectArray, n19, n21);
                                break;
                            }
                            default: {
                                throw new AssertionError(n4);
                            }
                        }
                        n22 += n20;
                        n19 += n21;
                    } while (--n23 != 0);
                }
            }
        }
    }

    private IIOException invalidFile(String string) {
        return new IIOException("Invalid value for record " + string);
    }

    private String error(int n) {
        return Errors.getResources((Locale)this.getLocale()).getString(n);
    }

    private String error(int n, Object object) {
        return Errors.getResources((Locale)this.getLocale()).getString(n, object);
    }

    private String error(int n, Object object, Object object2) {
        return Errors.getResources((Locale)this.getLocale()).getString(n, object, object2);
    }

    @Override
    protected void close() throws IOException {
        super.close();
        this.positionBuffer = 0L;
        this.filePosition = 0L;
        this.countIFD = 0;
        this.currentImage = -1;
        this.bitsPerSample = null;
        this.tileOffsets = null;
        this.rawImageType = null;
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    static {
        int[] nArray = TYPE_SIZE = new int[19];
        nArray[1] = 1;
        nArray[6] = 1;
        nArray[3] = 2;
        nArray[8] = 2;
        nArray[13] = 4;
        nArray[4] = 4;
        nArray[9] = 4;
        nArray[18] = 8;
        nArray[16] = 8;
        nArray[17] = 8;
        nArray[11] = 4;
        nArray[12] = 8;
        OFFSET_COMPARATOR = new Comparator<long[]>(){

            @Override
            public int compare(long[] lArray, long[] lArray2) {
                return MathFunctions.sgn((long)(lArray[0] - lArray2[0]));
            }
        };
    }

    public static class Spi
    extends SpatialImageReader.Spi
    implements SystemOverride {
        private static final String[] SUFFIXES = new String[]{"tiff", "tif"};
        private static final String[] MIME_TYPES = new String[]{"image/tiff"};
        private static final Class<?>[] INPUT_TYPES = new Class[]{File.class, String.class};

        public Spi() {
            this.names = SUFFIXES;
            this.suffixes = SUFFIXES;
            this.inputTypes = INPUT_TYPES;
            this.MIMETypes = MIME_TYPES;
            this.pluginClassName = "org.geotoolkit.image.io.plugin.RawTiffImageReader";
            this.nativeStreamMetadataFormatName = null;
            this.nativeImageMetadataFormatName = null;
        }

        @Override
        public String getDescription(Locale locale) {
            return "TIFF image reader";
        }

        @Override
        public boolean canDecodeInput(Object object) throws IOException {
            return false;
        }

        @Override
        public ImageReader createReaderInstance(Object object) throws IOException {
            return new RawTiffImageReader(this);
        }

        @Override
        public void onRegistration(ServiceRegistry serviceRegistry, Class<?> clazz) {
            super.onRegistration(serviceRegistry, clazz);
            if (clazz.equals(ImageReaderSpi.class)) {
                Iterator<ImageReaderSpi> iterator = serviceRegistry.getServiceProviders(ImageReaderSpi.class, false);
                while (iterator.hasNext()) {
                    ImageReaderSpi imageReaderSpi = iterator.next();
                    if (imageReaderSpi == this || !ArraysExt.contains((Object[])imageReaderSpi.getFormatNames(), (Object)"tiff")) continue;
                    ImageReaderSpi imageReaderSpi2 = this;
                    try {
                        if (Boolean.getBoolean("geotk.system.override")) {
                            imageReaderSpi2 = imageReaderSpi;
                            imageReaderSpi = this;
                        }
                    }
                    catch (SecurityException securityException) {
                        Logging.recoverableException(Spi.class, (String)"onRegistration", (Throwable)securityException);
                    }
                    serviceRegistry.setOrdering(ImageReaderSpi.class, imageReaderSpi, imageReaderSpi2);
                }
            }
        }
    }

    private static final class Tile
    extends Rectangle
    implements Comparable<Tile> {
        final long position;

        Tile(int n, int n2, int n3, int n4, long l) {
            super(n, n2, n3, n4);
            this.position = l;
            assert (!this.isEmpty() && n >= 0 && n2 >= 0) : this;
        }

        @Override
        public int compareTo(Tile tile) {
            return MathFunctions.sgn((long)(this.position - tile.position));
        }
    }
}

