/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.plugin;

import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.media.jai.iterator.RectIter;
import org.apache.sis.util.Localized;
import org.geotoolkit.image.ImageDimension;
import org.geotoolkit.image.io.ImageMetadataException;
import org.geotoolkit.image.io.TextImageWriter;
import org.geotoolkit.image.io.WarningProducer;
import org.geotoolkit.image.io.metadata.MetadataHelper;
import org.geotoolkit.image.io.metadata.SampleDimension;
import org.geotoolkit.image.io.metadata.SpatialMetadata;
import org.geotoolkit.image.io.plugin.AsciiGridReader;
import org.geotoolkit.internal.image.io.Warnings;
import org.geotoolkit.util.Strings;
import org.geotoolkit.util.collection.XCollections;
import org.opengis.coverage.grid.RectifiedGrid;
import org.opengis.metadata.spatial.Georectified;
import org.opengis.metadata.spatial.PixelOrientation;

public class AsciiGridWriter
extends TextImageWriter {
    private static final String DEFAULT_FILL = "-9999";
    private boolean strictCellSize;

    protected AsciiGridWriter(Spi spi) {
        super(spi);
    }

    public void setStrictCellSize(boolean bl) {
        this.strictCellSize = bl;
    }

    public boolean getStrictCellSize() {
        return this.strictCellSize;
    }

    private String prepareHeader(SpatialMetadata spatialMetadata, Map<String, String> map, ImageWriteParam imageWriteParam) throws IOException {
        double d;
        double[] dArray;
        SampleDimension sampleDimension;
        Object object;
        MetadataHelper metadataHelper = new MetadataHelper((Localized)this);
        Georectified georectified = spatialMetadata.getInstanceForType(Georectified.class);
        RectifiedGrid rectifiedGrid = spatialMetadata.getInstanceForType(RectifiedGrid.class);
        PixelOrientation pixelOrientation = georectified != null ? georectified.getPointInPixel() : null;
        AffineTransform affineTransform = metadataHelper.getAffineTransform(rectifiedGrid, imageWriteParam);
        String string = "XLLCORNER";
        String string2 = "YLLCORNER";
        if (pixelOrientation != null && !pixelOrientation.equals((Object)PixelOrientation.UPPER_LEFT)) {
            if (pixelOrientation.equals((Object)PixelOrientation.CENTER)) {
                string = "XLLCENTER";
                string2 = "YLLCENTER";
            } else if (pixelOrientation.equals((Object)PixelOrientation.valueOf((String)"UPPER"))) {
                string2 = "YLLCENTER";
            } else if (pixelOrientation.equals((Object)PixelOrientation.valueOf((String)"LEFT"))) {
                string = "XLLCENTER";
            } else {
                throw new ImageMetadataException(Warnings.message((Localized)this, 12, "pointInPixel", pixelOrientation));
            }
        }
        map.put(string, String.valueOf(affineTransform.getTranslateX()));
        map.put(string2, String.valueOf(affineTransform.getTranslateY()));
        try {
            map.put("CELLSIZE", String.valueOf(metadataHelper.getCellSize(affineTransform)));
        }
        catch (IIOException iIOException) {
            if (this.strictCellSize || (object = metadataHelper.getCellDimension(affineTransform)) == null) {
                throw iIOException;
            }
            Warnings.log((WarningProducer)this, null, AsciiGridWriter.class, "writeHeader", iIOException);
            map.put("DX", String.valueOf(((Dimension2D)object).getWidth()));
            map.put("DY", String.valueOf(((Dimension2D)object).getHeight()));
        }
        String string3 = DEFAULT_FILL;
        object = spatialMetadata.getListForType(SampleDimension.class);
        if (!XCollections.isNullOrEmpty((Collection)object) && (sampleDimension = (SampleDimension)object.get(0)) != null && (dArray = sampleDimension.getFillSampleValues()) != null && dArray.length != 0 && !Double.isNaN(d = dArray[0])) {
            string3 = Strings.trimFractionalPart((String)String.valueOf(d));
            map.put("NODATA_VALUE", string3);
        }
        return string3;
    }

    private void writeHeader(Map<String, String> map, BufferedWriter bufferedWriter) throws IOException {
        int n = 0;
        for (String object : map.keySet()) {
            int entry = object.length();
            if (entry <= n) continue;
            n = entry;
        }
        boolean bl = true;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!bl) {
                bufferedWriter.write(10);
            }
            bl = false;
            String string = entry.getKey();
            bufferedWriter.write(string);
            bufferedWriter.write(Strings.spaces((int)(2 + Math.max(0, n - string.length()))));
            bufferedWriter.write(entry.getValue());
        }
    }

    @Override
    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.processImageStarted();
        BufferedWriter bufferedWriter = this.getWriter(imageWriteParam);
        ImageDimension imageDimension = AsciiGridWriter.computeSize(iIOImage, imageWriteParam);
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(8);
        linkedHashMap.put("NCOLS", String.valueOf(imageDimension.width));
        linkedHashMap.put("NROWS", String.valueOf(imageDimension.height));
        SpatialMetadata spatialMetadata = this.convertImageMetadata(iIOImage.getMetadata(), null, imageWriteParam);
        String string = DEFAULT_FILL;
        if (spatialMetadata != null) {
            string = this.prepareHeader(spatialMetadata, linkedHashMap, imageWriteParam);
        }
        this.writeHeader(linkedHashMap, bufferedWriter);
        RectIter rectIter = AsciiGridWriter.createRectIter(iIOImage, imageWriteParam);
        int n = AsciiGridWriter.getSampleModel(iIOImage, imageWriteParam).getDataType();
        float f = 100.0f / (float)imageDimension.getNumSampleValues();
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        if (!rectIter.finishedBands()) {
            do {
                if (bl) {
                    bufferedWriter.write(10);
                }
                if (!rectIter.finishedLines()) {
                    do {
                        if (n2 >= n3) {
                            this.processImageProgress(f * (float)n2);
                            n3 = n2 + 2000;
                        }
                        if (this.abortRequested()) {
                            this.processWriteAborted();
                            return;
                        }
                        int n4 = 10;
                        if (!rectIter.finishedPixels()) {
                            do {
                                String string2;
                                switch (n) {
                                    case 5: {
                                        double d = rectIter.getSampleDouble();
                                        string2 = Double.isNaN(d) ? string : Double.toString(d);
                                        break;
                                    }
                                    case 4: {
                                        float f2 = rectIter.getSampleFloat();
                                        string2 = Float.isNaN(f2) ? string : Float.toString(f2);
                                        break;
                                    }
                                    default: {
                                        string2 = Integer.toString(rectIter.getSample());
                                        break;
                                    }
                                    case 0: 
                                    case 1: {
                                        string2 = Integer.toString(rectIter.getSample() & Integer.MAX_VALUE);
                                    }
                                }
                                bufferedWriter.write(n4);
                                bufferedWriter.write(string2);
                                n4 = 32;
                            } while (!rectIter.nextPixelDone());
                        }
                        n2 += imageDimension.width;
                        rectIter.startPixels();
                    } while (!rectIter.nextLineDone());
                }
                rectIter.startLines();
                bl = true;
            } while (!rectIter.nextBandDone());
        }
        bufferedWriter.write(10);
        bufferedWriter.flush();
        this.processImageComplete();
    }

    public static class Spi
    extends TextImageWriter.Spi {
        private static final String[] READERS = new String[]{"org.geotoolkit.image.io.plugin.AsciiGridReader$Spi"};

        public Spi() {
            this.names = AsciiGridReader.Spi.NAMES;
            this.MIMETypes = AsciiGridReader.Spi.MIME_TYPES;
            this.pluginClassName = "org.geotoolkit.image.io.plugin.AsciiGridWriter";
            this.readerSpiNames = READERS;
            this.locale = Locale.US;
            this.charset = Charset.forName("US-ASCII");
            this.lineSeparator = "\n";
            this.nativeStreamMetadataFormatName = null;
        }

        @Override
        public String getDescription(Locale locale) {
            return "ASCII grid";
        }

        @Override
        public ImageWriter createWriterInstance(Object object) throws IOException {
            return new AsciiGridWriter(this);
        }
    }
}

