/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.imageio.spi.ImageReaderSpi;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.gui.swing.tree.DefaultTreeModel;
import org.geotoolkit.gui.swing.tree.TreeNodeFilter;
import org.geotoolkit.gui.swing.tree.Trees;
import org.geotoolkit.image.io.mosaic.GridNode;
import org.geotoolkit.image.io.mosaic.RTree;
import org.geotoolkit.image.io.mosaic.ReaderInputPair;
import org.geotoolkit.image.io.mosaic.Tile;
import org.geotoolkit.image.io.mosaic.TileManager;
import org.geotoolkit.util.collection.FrequencySortedSet;
import org.geotoolkit.util.collection.UnmodifiableArrayList;
import org.geotoolkit.util.collection.XCollections;

final class TreeTileManager
extends TileManager
implements TreeNodeFilter {
    private static final long serialVersionUID = -6070623930537957163L;
    private static final int CONCURRENT_THREADS = 4;
    private final Tile[] tiles;
    private transient Collection<Tile> allTiles;
    private transient RTree[] trees;
    private transient Rectangle region;
    private transient Dimension tileSize;

    protected TreeTileManager(Tile[] tileArray) {
        ArgumentChecks.ensureNonNull((String)"tiles", (Object)tileArray);
        LinkedHashMap<ReaderInputPair, ArrayList<Tile>> linkedHashMap = new LinkedHashMap<ReaderInputPair, ArrayList<Tile>>(tileArray.length + tileArray.length / 4 + 1);
        this.providers = new FrequencySortedSet(4, true);
        for (Tile objectArray : tileArray) {
            objectArray.checkGeometryValidity();
            ImageReaderSpi imageReaderSpi = objectArray.getImageReaderSpi();
            ReaderInputPair readerInputPair = new ReaderInputPair(imageReaderSpi, objectArray.getInput());
            Object object = (ArrayList<Tile>)linkedHashMap.get(readerInputPair);
            if (object == null) {
                object = new ArrayList<Tile>(1);
                linkedHashMap.put(readerInputPair, (ArrayList<Tile>)object);
                this.providers.add(imageReaderSpi);
            }
            object.add(objectArray);
        }
        this.providers = XCollections.unmodifiableSet((Set)this.providers);
        Object[] objectArray = linkedHashMap.values().toArray(new List[linkedHashMap.size()]);
        Comparator comparator = XCollections.listComparator();
        Arrays.sort(objectArray, comparator);
        int n = 0;
        for (Object object : objectArray) {
            switch (object.size()) {
                case 0: {
                    throw new AssertionError();
                }
                case 1: {
                    break;
                }
                default: {
                    Collections.sort(object);
                }
            }
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Tile tile = (Tile)iterator.next();
                tileArray[n++] = tile;
            }
        }
        this.tiles = tileArray;
        this.allTiles = UnmodifiableArrayList.wrap((Object[])tileArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final synchronized Rectangle getRegion() throws IOException {
        if (this.region == null) {
            RTree rTree = this.getTree();
            try {
                this.region = rTree.getBounds();
            }
            finally {
                this.release(rTree);
            }
        }
        return this.region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final synchronized Dimension getTileSize() throws IOException {
        if (this.tileSize == null) {
            RTree rTree = this.getTree();
            try {
                this.tileSize = rTree.getTileSize();
            }
            finally {
                this.release(rTree);
            }
        }
        return this.tileSize;
    }

    @Override
    final boolean isImageTiled() throws IOException {
        return this.tiles.length >= 2;
    }

    private synchronized RTree getTree() throws IOException {
        RTree rTree;
        if (this.trees == null) {
            GridNode gridNode = new GridNode(this.tiles);
            rTree = new RTree(gridNode);
            RTree[] rTreeArray = new RTree[4];
            rTreeArray[0] = rTree;
            assert (gridNode.containsAll(this.allTiles));
            this.trees = rTreeArray;
        }
        for (int i = 0; i < this.trees.length; ++i) {
            rTree = this.trees[i];
            if (rTree == null) {
                this.trees[i] = rTree = this.trees[0].clone();
            } else if (rTree.inUse) continue;
            rTree.inUse = true;
            return rTree;
        }
        return this.trees[0].clone();
    }

    private synchronized void release(RTree rTree) {
        if (rTree != null) {
            rTree.inUse = false;
        }
    }

    @Override
    public Set<ImageReaderSpi> getImageReaderSpis() throws IOException {
        return this.providers;
    }

    @Override
    public Collection<Tile> getTiles() {
        return this.allTiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Tile> getTiles(Rectangle rectangle, Dimension dimension, boolean bl) throws IOException {
        List<Tile> list;
        RTree rTree = this.getTree();
        try {
            rTree.regionOfInterest = rectangle;
            rTree.subsampling = dimension;
            rTree.subsamplingChangeAllowed = bl;
            list = rTree.searchTiles();
        }
        finally {
            rTree.regionOfInterest = null;
            rTree.subsampling = null;
            this.release(rTree);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean intersects(Rectangle rectangle, Dimension dimension) throws IOException {
        boolean bl;
        RTree rTree = this.getTree();
        try {
            rTree.regionOfInterest = rectangle;
            rTree.subsampling = dimension;
            bl = rTree.intersects();
        }
        finally {
            rTree.regionOfInterest = null;
            rTree.subsampling = null;
            this.release(rTree);
        }
        return bl;
    }

    public int hashCode() {
        return 0xDF4CA8D5 ^ Arrays.hashCode(this.tiles);
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            TreeTileManager treeTileManager = (TreeTileManager)object;
            return Arrays.equals(this.tiles, treeTileManager.tiles);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        String string;
        RTree rTree;
        try {
            rTree = this.getTree();
        }
        catch (IOException iOException) {
            return super.toString();
        }
        try {
            string = Trees.toString((TreeNode)((Object)rTree.root));
        }
        finally {
            this.release(rTree);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeModel toTree() throws IOException {
        RTree rTree = this.getTree();
        try {
            DefaultTreeModel defaultTreeModel = new DefaultTreeModel((TreeNode)Trees.copy((TreeNode)((Object)rTree.root), (TreeNodeFilter)this));
            return defaultTreeModel;
        }
        finally {
            this.release(rTree);
        }
    }

    public boolean accept(TreeNode treeNode) {
        return true;
    }

    public Object convertUserObject(TreeNode treeNode, Object object) {
        if (object == null) {
            object = new Rectangle((Rectangle)((Object)treeNode));
        }
        return object;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.allTiles = UnmodifiableArrayList.wrap((Object[])this.tiles);
        this.providers = new FrequencySortedSet(4, true);
        for (Tile tile : this.tiles) {
            this.providers.add(tile.getImageReaderSpi());
        }
        this.providers = XCollections.unmodifiableSet((Set)this.providers);
    }
}

