/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.mosaic;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.geotoolkit.gui.swing.tree.Trees;
import org.geotoolkit.image.io.mosaic.Tile;
import org.geotoolkit.util.Utilities;

class TreeNode
extends Rectangle
implements Iterable<TreeNode>,
org.geotoolkit.gui.swing.tree.TreeNode {
    private static final long serialVersionUID = 1669511478839242773L;
    protected Tile tile;
    private TreeNode parent;
    private TreeNode firstChildren;
    private TreeNode lastChildren;
    private TreeNode previousSibling;
    private TreeNode nextSibling;

    protected TreeNode() {
        super(-1, -1);
    }

    protected TreeNode(Rectangle rectangle) {
        super(rectangle);
    }

    public void addChild(TreeNode treeNode) throws ClassCastException {
        if (treeNode != null) {
            assert (treeNode.isRoot() && (this.tile == null || this.contains(treeNode))) : treeNode;
            treeNode.parent = this;
            if (this.lastChildren == null) {
                this.lastChildren = this.firstChildren = treeNode;
            } else {
                treeNode.previousSibling = this.lastChildren;
                this.lastChildren.nextSibling = treeNode;
                this.lastChildren = treeNode;
            }
        }
    }

    public void removeChildren() {
        TreeNode treeNode = this.firstChildren;
        while (treeNode != null) {
            assert (treeNode.parent == this);
            TreeNode treeNode2 = treeNode.nextSibling;
            treeNode.previousSibling = null;
            treeNode.nextSibling = null;
            treeNode.parent = null;
            treeNode = treeNode2;
        }
        this.lastChildren = null;
        this.firstChildren = null;
    }

    public void remove() {
        if (this.previousSibling != null) {
            this.previousSibling.nextSibling = this.nextSibling;
        }
        if (this.nextSibling != null) {
            this.nextSibling.previousSibling = this.previousSibling;
        }
        if (this.parent != null) {
            if (this.parent.firstChildren == this) {
                this.parent.firstChildren = this.nextSibling;
            }
            if (this.parent.lastChildren == this) {
                this.parent.lastChildren = this.previousSibling;
            }
            this.parent = null;
        }
        this.previousSibling = null;
        this.nextSibling = null;
    }

    final int getTileCount() {
        int n = this.tile != null ? 1 : 0;
        TreeNode treeNode = this.firstChildren;
        while (treeNode != null) {
            n += treeNode.getTileCount();
            treeNode = treeNode.nextSibling;
        }
        return n;
    }

    public final Tile getUserObject() {
        return this.tile;
    }

    public final TreeNode getParent() {
        return this.parent;
    }

    public final boolean isRoot() {
        return this.parent == null && this.previousSibling == null && this.nextSibling == null;
    }

    public final boolean isLeaf() {
        assert (this.firstChildren == null == (this.lastChildren == null));
        return this.firstChildren == null;
    }

    public final boolean getAllowsChildren() {
        return !super.isEmpty();
    }

    public final boolean hasOverlaps() {
        TreeNode treeNode = this.firstChildren;
        while (treeNode != null) {
            TreeNode treeNode2 = treeNode;
            while ((treeNode2 = treeNode2.nextSibling) != null) {
                if (!treeNode.intersects(treeNode2)) continue;
                return true;
            }
            treeNode = treeNode.nextSibling;
        }
        return false;
    }

    public final TreeNode getChild() {
        return this.firstChildren == this.lastChildren ? this.firstChildren : null;
    }

    public final int getChildCount() {
        int n = 0;
        TreeNode treeNode = this.firstChildren;
        while (treeNode != null) {
            treeNode = treeNode.nextSibling;
            ++n;
        }
        return n;
    }

    public final TreeNode getChildAt(int n) {
        TreeNode treeNode = this.firstChildren;
        while (treeNode != null) {
            if (n == 0) {
                return treeNode;
            }
            treeNode = treeNode.nextSibling;
            --n;
        }
        throw new IndexOutOfBoundsException();
    }

    public final int getIndex(javax.swing.tree.TreeNode treeNode) {
        int n = 0;
        TreeNode treeNode2 = this.firstChildren;
        while (treeNode2 != null) {
            if (treeNode2 == treeNode) {
                assert (this.getChildAt(n) == treeNode) : n;
                return n;
            }
            treeNode2 = treeNode2.nextSibling;
            ++n;
        }
        return -1;
    }

    final TreeNode firstChildren() {
        return this.firstChildren;
    }

    final TreeNode nextSibling() {
        return this.nextSibling;
    }

    public final Enumeration<TreeNode> children() {
        return new Iter(this.firstChildren);
    }

    @Override
    public final Iterator<TreeNode> iterator() {
        return new Iter(this.firstChildren);
    }

    public final boolean remove(Tile tile) throws IOException {
        return this.contains(tile.getAbsoluteRegion(), tile, true);
    }

    public final boolean containsAll(Collection<Tile> collection) throws IOException {
        for (Tile tile : collection) {
            if (this.contains(tile.getAbsoluteRegion(), tile, false)) continue;
            return false;
        }
        return true;
    }

    private boolean contains(Rectangle rectangle, Tile tile, boolean bl) {
        if (this.equals(rectangle)) {
            if (bl) {
                this.tile = null;
            }
            return true;
        }
        if (super.contains(rectangle)) {
            TreeNode treeNode = this.firstChildren;
            while (treeNode != null) {
                if (treeNode.contains(rectangle, tile, bl)) {
                    if (bl && treeNode.tile == null && treeNode.isLeaf()) {
                        treeNode.remove();
                    }
                    return true;
                }
                treeNode = treeNode.nextSibling;
            }
        }
        return false;
    }

    public final Collection<Tile> containedIn(Rectangle rectangle) {
        LinkedList<Tile> linkedList = new LinkedList<Tile>();
        this.containedIn(rectangle, linkedList);
        return linkedList;
    }

    private void containedIn(Rectangle rectangle, Collection<Tile> collection) {
        if (rectangle.contains(this)) {
            this.copy(collection);
        } else if (rectangle.intersects(this)) {
            TreeNode treeNode = this.firstChildren;
            while (treeNode != null) {
                treeNode.containedIn(rectangle, collection);
                treeNode = treeNode.nextSibling;
            }
        }
    }

    private void copy(Collection<Tile> collection) {
        if (this.tile != null) {
            collection.add(this.tile);
        }
        TreeNode treeNode = this.firstChildren;
        while (treeNode != null) {
            treeNode.copy(collection);
            treeNode = treeNode.nextSibling;
        }
    }

    public final Collection<Tile> intersecting(Rectangle rectangle) {
        LinkedList<Tile> linkedList = new LinkedList<Tile>();
        this.intersecting(rectangle, linkedList);
        return linkedList;
    }

    private void intersecting(Rectangle rectangle, Collection<Tile> collection) {
        if (this.intersects(rectangle)) {
            if (this.tile != null) {
                collection.add(this.tile);
            }
            TreeNode treeNode = this.firstChildren;
            while (treeNode != null) {
                treeNode.intersecting(rectangle, collection);
                treeNode = treeNode.nextSibling;
            }
        }
    }

    final void getTiles(List<Tile> list) {
        if (this.tile != null) {
            list.add(this.tile);
        }
        TreeNode treeNode = this.firstChildren;
        while (treeNode != null) {
            treeNode.getTiles(list);
            treeNode = treeNode.nextSibling;
        }
    }

    @Override
    public final boolean equals(Object object) {
        return object == this || super.equals(object);
    }

    public final boolean deepEquals(TreeNode treeNode) {
        if (treeNode == this) {
            return true;
        }
        if (!this.equals(treeNode) || !Utilities.equals((Object)this.tile, (Object)treeNode.tile)) {
            return false;
        }
        Iterator<TreeNode> iterator = this.iterator();
        Iterator<TreeNode> iterator2 = treeNode.iterator();
        if (iterator.hasNext()) {
            TreeNode treeNode2;
            if (!iterator2.hasNext()) {
                return false;
            }
            TreeNode treeNode3 = iterator.next();
            return treeNode3 == (treeNode2 = iterator2.next()) || treeNode3 != null && treeNode3.deepEquals(treeNode2);
        }
        return !iterator2.hasNext();
    }

    public final String toTree() {
        return Trees.toString((javax.swing.tree.TreeNode)((Object)this));
    }

    @Override
    public final String toString() {
        String string;
        if (this.tile != null) {
            string = this.tile.toString();
        } else {
            string = super.toString();
            string = string.substring(string.lastIndexOf(46) + 1);
        }
        if (!this.isLeaf()) {
            StringBuilder stringBuilder = new StringBuilder(string).append(" (").append(this.getChildCount()).append(" childs");
            if (this.hasOverlaps()) {
                stringBuilder.append(", overlaps");
            }
            string = stringBuilder.append(')').toString();
        }
        return string;
    }

    boolean checkValidity() {
        TreeNode treeNode = this.firstChildren;
        if (treeNode != null) {
            if (treeNode.previousSibling != null) {
                throw new AssertionError(this);
            }
            if (this.isLeaf() || !this.getAllowsChildren()) {
                throw new AssertionError(this);
            }
            int n = 0;
            while (true) {
                if (treeNode.parent != this) {
                    throw new AssertionError(treeNode);
                }
                if (this.getIndex((javax.swing.tree.TreeNode)((Object)treeNode)) != n) {
                    throw new AssertionError(treeNode);
                }
                if (!treeNode.checkValidity()) {
                    return false;
                }
                TreeNode treeNode2 = treeNode.nextSibling;
                if (treeNode2 == null) break;
                if (treeNode2.previousSibling != treeNode) {
                    throw new AssertionError(treeNode);
                }
                if (!this.contains(treeNode) && this.width >= 0 && this.height >= 0) {
                    throw new AssertionError(treeNode);
                }
                treeNode = treeNode2;
                ++n;
            }
        }
        if (treeNode != this.lastChildren) {
            throw new AssertionError(this);
        }
        if (this.tile != null) {
            Rectangle rectangle;
            if (this.isEmpty()) {
                throw new AssertionError(this);
            }
            try {
                rectangle = this.tile.getAbsoluteRegion();
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
            if (!rectangle.contains(this)) {
                throw new AssertionError(this);
            }
        }
        return true;
    }

    private static final class Iter
    implements Iterator<TreeNode>,
    Enumeration<TreeNode> {
        private TreeNode children;
        private TreeNode last;

        public Iter(TreeNode treeNode) {
            this.children = treeNode;
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }

        @Override
        public boolean hasNext() {
            return this.children != null;
        }

        @Override
        public TreeNode next() {
            if (this.children != null) {
                this.last = this.children;
                this.children = this.children.nextSibling;
                return this.last;
            }
            throw new NoSuchElementException();
        }

        @Override
        public TreeNode nextElement() {
            return this.next();
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.last.remove();
            this.last = null;
        }
    }
}

