/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.mosaic;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import org.geotoolkit.image.io.mosaic.Tile;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.logging.Logging;

final class TileReaderPool {
    private Locale locale;
    final Set<ImageReaderSpi> providers;
    private final Map<ImageReaderSpi, ImageReader> readers = new HashMap<ImageReaderSpi, ImageReader>();
    private final Map<ImageReader, Object> readerInputs = new IdentityHashMap<ImageReader, Object>();

    TileReaderPool() {
        this.providers = Collections.unmodifiableSet(this.readers.keySet());
    }

    final void setProviders(Set<ImageReaderSpi> set) {
        Iterator<Map.Entry<ImageReaderSpi, ImageReader>> iterator = this.readers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ImageReaderSpi, ImageReader> entry = iterator.next();
            if (set.contains(entry.getKey())) continue;
            ImageReader object = (ImageReader)entry.getValue();
            if (object != null) {
                Object object2;
                Object object3 = this.readerInputs.remove(object);
                if (object3 != (object2 = object.getInput())) {
                    try {
                        IOUtilities.close((Object)object2);
                    }
                    catch (IOException iOException) {
                        Logging.unexpectedException((Logger)Tile.LOGGER, TileReaderPool.class, (String)"setInput", (Throwable)iOException);
                    }
                }
                object.dispose();
            }
            iterator.remove();
        }
        for (ImageReaderSpi imageReaderSpi : set) {
            if (this.readers.containsKey(imageReaderSpi)) continue;
            this.readers.put(imageReaderSpi, null);
        }
        assert (((Object)set).equals(this.providers));
        assert (this.readers.values().containsAll(this.readerInputs.keySet()));
    }

    private ImageReader createReaderInstance(ImageReaderSpi imageReaderSpi) throws IOException {
        ImageReader imageReader = imageReaderSpi.createReaderInstance();
        if (this.locale != null) {
            try {
                imageReader.setLocale(this.locale);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.recoverableException((Logger)Tile.LOGGER, TileReaderPool.class, (String)"getTileReader", (Throwable)illegalArgumentException);
            }
        }
        return imageReader;
    }

    final ImageReader getTileReader(ImageReaderSpi imageReaderSpi) throws IOException {
        assert (this.readers.containsKey(imageReaderSpi));
        ImageReader imageReader = this.readers.get(imageReaderSpi);
        if (imageReader == null) {
            imageReader = this.createReaderInstance(imageReaderSpi);
            this.readers.put(imageReaderSpi, imageReader);
        }
        return imageReader;
    }

    final Set<ImageReader> getTileReaders() {
        for (Map.Entry<ImageReaderSpi, ImageReader> entry : this.readers.entrySet()) {
            ImageReader imageReader = entry.getValue();
            if (imageReader == null) {
                ImageReaderSpi imageReaderSpi = entry.getKey();
                try {
                    imageReader = this.createReaderInstance(imageReaderSpi);
                }
                catch (IOException iOException) {
                    Logging.unexpectedException((Logger)Tile.LOGGER, TileReaderPool.class, (String)"getTileReaders", (Throwable)iOException);
                    continue;
                }
                entry.setValue(imageReader);
            }
            if (this.readerInputs.containsKey(imageReader)) continue;
            this.readerInputs.put(imageReader, null);
        }
        assert (this.readers.values().containsAll(this.readerInputs.keySet()));
        return this.readerInputs.keySet();
    }

    final ImageReader getTileReader() {
        Set<ImageReader> set = this.getTileReaders();
        for (Class clazz = Classes.findSpecializedClass(set); clazz != null && ImageReader.class.isAssignableFrom(clazz); clazz = clazz.getSuperclass()) {
            for (ImageReader imageReader : set) {
                if (!clazz.equals(imageReader.getClass())) continue;
                return imageReader;
            }
        }
        return null;
    }

    public void setLocale(Locale locale) throws IllegalArgumentException {
        this.locale = locale;
        for (ImageReader imageReader : this.readers.values()) {
            try {
                imageReader.setLocale(locale);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.recoverableException((Logger)Tile.LOGGER, TileReaderPool.class, (String)"setLocale", (Throwable)illegalArgumentException);
            }
        }
    }

    final Object getRawInput(ImageReader imageReader) {
        return this.readerInputs.get(imageReader);
    }

    final void setRawInput(ImageReader imageReader, Object object) {
        this.readerInputs.put(imageReader, object);
    }

    public void close() throws IOException {
        for (Map.Entry<ImageReader, Object> entry : this.readerInputs.entrySet()) {
            ImageReader imageReader = entry.getKey();
            Object object = entry.getValue();
            Object object2 = imageReader.getInput();
            entry.setValue(null);
            imageReader.setInput(null);
            if (object2 == object) continue;
            IOUtilities.close((Object)object2);
        }
    }

    public void dispose() {
        this.readerInputs.clear();
        for (ImageReader imageReader : this.readers.values()) {
            if (imageReader == null) continue;
            imageReader.dispose();
        }
        this.readers.clear();
    }
}

