/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import net.jcip.annotations.Immutable;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.geotoolkit.image.io.ImageReaderAdapter;
import org.geotoolkit.image.io.ImageWriterAdapter;
import org.geotoolkit.image.io.mosaic.MosaicImageReader;
import org.geotoolkit.image.io.mosaic.TileReaderPool;
import org.geotoolkit.internal.image.io.CheckedImageInputStream;
import org.geotoolkit.internal.image.io.Formats;
import org.geotoolkit.internal.image.io.SupportFiles;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.io.TableWriter;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.logging.Logging;

@Immutable
public class Tile
implements Comparable<Tile>,
Serializable {
    private static final long serialVersionUID = -5417183834232374962L;
    static final Logger LOGGER = Logging.getLogger(Tile.class);
    static final int MASK = 65535;
    private final transient ImageReaderSpi provider;
    private final Object input;
    private final short imageIndex;
    private short xSubsampling;
    private short ySubsampling;
    private int x;
    private int y;
    private short width;
    private short height;
    private AffineTransform gridToCRS;

    public Tile(Tile tile, Object object) {
        this(tile, object, null);
    }

    Tile(Tile tile, Object object, Rectangle rectangle) {
        ArgumentChecks.ensureNonNull((String)"tile", (Object)tile);
        if (rectangle != null) {
            if (rectangle.isEmpty()) {
                throw new IllegalArgumentException(Errors.format((int)15, (Object)rectangle));
            }
            this.x = rectangle.x;
            this.y = rectangle.y;
            this.setSize(rectangle.width, rectangle.height);
        } else {
            this.x = tile.x;
            this.y = tile.y;
            this.width = tile.width;
            this.height = tile.height;
        }
        this.input = object != null ? object : tile.input;
        this.provider = tile.provider;
        this.imageIndex = tile.imageIndex;
        this.xSubsampling = tile.xSubsampling;
        this.ySubsampling = tile.ySubsampling;
        this.gridToCRS = tile.gridToCRS;
    }

    public Tile(ImageReaderSpi imageReaderSpi, Object object, int n, Point point, Dimension dimension) {
        if (imageReaderSpi == null) {
            imageReaderSpi = Tile.getImageReaderSpi(object);
        }
        ArgumentChecks.ensureNonNull((String)"provider", (Object)imageReaderSpi);
        ArgumentChecks.ensureNonNull((String)"input", (Object)object);
        ArgumentChecks.ensureNonNull((String)"location", (Object)point);
        this.provider = imageReaderSpi;
        this.input = object;
        this.imageIndex = Tile.toShort(n);
        this.x = point.x;
        this.y = point.y;
        if (dimension != null) {
            Tile.checkSubsampling(dimension);
            this.xSubsampling = Tile.toShort(dimension.width);
            this.ySubsampling = Tile.toShort(dimension.height);
        } else {
            this.ySubsampling = 1;
            this.xSubsampling = 1;
        }
    }

    public Tile(ImageReaderSpi imageReaderSpi, Object object, int n, Rectangle rectangle, Dimension dimension) {
        if (imageReaderSpi == null) {
            imageReaderSpi = Tile.getImageReaderSpi(object);
        }
        ArgumentChecks.ensureNonNull((String)"provider", (Object)imageReaderSpi);
        ArgumentChecks.ensureNonNull((String)"input", (Object)object);
        ArgumentChecks.ensureNonNull((String)"region", (Object)rectangle);
        if (rectangle.isEmpty()) {
            throw new IllegalArgumentException(Errors.format((int)15, (Object)rectangle));
        }
        this.provider = imageReaderSpi;
        this.input = object;
        this.imageIndex = Tile.toShort(n);
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.setSize(rectangle.width, rectangle.height);
        if (dimension != null) {
            Tile.checkSubsampling(dimension);
            this.xSubsampling = Tile.toShort(dimension.width);
            this.ySubsampling = Tile.toShort(dimension.height);
        } else {
            this.ySubsampling = 1;
            this.xSubsampling = 1;
        }
    }

    public Tile(ImageReaderSpi imageReaderSpi, Object object, int n, Rectangle rectangle, AffineTransform affineTransform) {
        if (imageReaderSpi == null) {
            imageReaderSpi = Tile.getImageReaderSpi(object);
        }
        ArgumentChecks.ensureNonNull((String)"provider", (Object)imageReaderSpi);
        ArgumentChecks.ensureNonNull((String)"input", (Object)object);
        ArgumentChecks.ensureNonNull((String)"gridToCRS", (Object)affineTransform);
        this.provider = imageReaderSpi;
        this.input = object;
        this.imageIndex = Tile.toShort(n);
        if (rectangle != null) {
            this.x = rectangle.x;
            this.y = rectangle.y;
            if (!rectangle.isEmpty()) {
                this.setSize(rectangle.width, rectangle.height);
            }
        }
        this.gridToCRS = new AffineTransform(affineTransform);
    }

    public Tile(ImageReaderSpi imageReaderSpi, Object object, int n, Rectangle rectangle) {
        this(imageReaderSpi, object, n, rectangle, (Dimension)null);
    }

    public Tile(ImageReaderSpi imageReaderSpi, File file, int n) throws IOException {
        this(imageReaderSpi, (Object)file, n, null, SupportFiles.parseTFW(file));
    }

    public static boolean ignore(ImageReaderSpi imageReaderSpi) {
        ArgumentChecks.ensureNonNull((String)"provider", (Object)imageReaderSpi);
        return imageReaderSpi instanceof ImageReaderAdapter.Spi;
    }

    static boolean ignore(ImageWriterSpi imageWriterSpi) {
        ArgumentChecks.ensureNonNull((String)"provider", (Object)imageWriterSpi);
        return imageWriterSpi instanceof ImageWriterAdapter.Spi;
    }

    static short toShort(int n) throws IllegalArgumentException {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException(Errors.format((int)246, (Object)n, (Object)0, (Object)65535));
        }
        return (short)n;
    }

    static void checkSubsampling(Dimension dimension) throws IllegalArgumentException {
        ArgumentChecks.ensureStrictlyPositive((String)"width", (int)dimension.width);
        ArgumentChecks.ensureStrictlyPositive((String)"height", (int)dimension.height);
    }

    final void checkGeometryValidity() throws IllegalStateException {
        if (this.xSubsampling == 0 || this.ySubsampling == 0) {
            throw new IllegalStateException("Tile must be processed by TileManagerFactory.");
        }
    }

    static void dispose(ImageReader imageReader) throws IOException {
        Object object = imageReader.getInput();
        imageReader.dispose();
        IOUtilities.close((Object)object);
    }

    private static boolean isValidInput(Class<?>[] classArray, Object object) {
        if (classArray != null) {
            for (Class<?> clazz : classArray) {
                if (clazz == null || !clazz.isInstance(object)) continue;
                return true;
            }
        }
        return false;
    }

    protected ImageReader getImageReader(MosaicImageReader mosaicImageReader, boolean bl, boolean bl2) throws IOException {
        return this.getImageReader(mosaicImageReader != null ? mosaicImageReader.readers : null, bl, bl2);
    }

    final ImageReader getImageReader(TileReaderPool tileReaderPool, boolean bl, boolean bl2) throws IOException {
        Object object;
        ImageReader imageReader;
        ImageReaderSpi imageReaderSpi = this.getImageReaderSpi();
        if (tileReaderPool != null) {
            imageReader = tileReaderPool.getTileReader(imageReaderSpi);
            object = tileReaderPool.getRawInput(imageReader);
        } else {
            imageReader = imageReaderSpi.createReaderInstance();
            object = null;
        }
        Object object2 = this.getInput();
        boolean bl3 = Utilities.equals((Object)object2, (Object)object);
        if (!bl3 || this.getImageIndex() < imageReader.getMinIndex() || !bl && imageReader.isSeekForwardOnly() || !bl2 && imageReader.isIgnoringMetadata()) {
            ImageReaderSpi imageReaderSpi2;
            Object object3 = imageReader.getInput();
            imageReader.setInput(null);
            if (tileReaderPool != null) {
                tileReaderPool.setRawInput(imageReader, null);
            }
            ImageInputStream imageInputStream = null;
            if (object3 instanceof ImageInputStream) {
                imageInputStream = (ImageInputStream)object3;
            }
            if ((imageReaderSpi2 = imageReader.getOriginatingProvider()) == null || Tile.isValidInput(imageReaderSpi2.getInputTypes(), object2)) {
                if (imageInputStream != null) {
                    imageInputStream.close();
                }
                object3 = object2;
            } else {
                if (imageInputStream != null) {
                    if (bl3) {
                        try {
                            imageInputStream.seek(0L);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            Logging.recoverableException((Logger)LOGGER, Tile.class, (String)"getImageReader", (Throwable)indexOutOfBoundsException);
                            imageInputStream.close();
                            imageInputStream = null;
                        }
                    } else {
                        imageInputStream.close();
                        imageInputStream = null;
                    }
                }
                if (imageInputStream == null) {
                    imageInputStream = this.getInputStream();
                }
                object3 = imageInputStream;
            }
            imageReader.setInput(object3, bl, bl2);
            if (tileReaderPool != null) {
                tileReaderPool.setRawInput(imageReader, object2);
            }
        }
        return imageReader;
    }

    public ImageReader getImageReader() throws IOException {
        return this.getImageReader((MosaicImageReader)null, true, true);
    }

    public ImageReaderSpi getImageReaderSpi() {
        return this.provider;
    }

    static ImageReaderSpi getImageReaderSpi(Object object) {
        int n;
        ImageReaderSpi imageReaderSpi = null;
        String string = Tile.getInputName(object);
        if (string != null && (n = string.lastIndexOf(46)) > string.lastIndexOf(47)) {
            String string2 = string.substring(n + 1).trim();
            Iterator<ImageReaderSpi> iterator = IIORegistry.getDefaultInstance().getServiceProviders(ImageReaderSpi.class, true);
            while (iterator.hasNext()) {
                ImageReaderSpi imageReaderSpi2 = iterator.next();
                if (!ArraysExt.containsIgnoreCase((String[])imageReaderSpi2.getFileSuffixes(), (String)string2)) continue;
                if (!Tile.ignore(imageReaderSpi2)) {
                    return imageReaderSpi2;
                }
                if (imageReaderSpi != null) continue;
                imageReaderSpi = imageReaderSpi2;
            }
        }
        return imageReaderSpi;
    }

    static ImageInputStream createImageInputStream(Object object) throws IOException {
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(object);
        assert (CheckedImageInputStream.isValid(imageInputStream = CheckedImageInputStream.wrap(imageInputStream)));
        return imageInputStream;
    }

    private ImageInputStream getInputStream() throws IOException {
        String string;
        Serializable serializable;
        Object object = this.getInput();
        ImageInputStream imageInputStream = Tile.createImageInputStream(object);
        if (imageInputStream != null) {
            return imageInputStream;
        }
        if (object instanceof CharSequence && (imageInputStream = Tile.createImageInputStream(serializable = (string = object.toString()).indexOf("://") >= 1 ? new URL(string) : new File(string))) != null) {
            return imageInputStream;
        }
        if (object instanceof File) {
            imageInputStream = new FileImageInputStream((File)object);
            return imageInputStream;
        }
        throw new FileNotFoundException(Errors.format((int)64, (Object)object));
    }

    public Object getInput() {
        return this.input;
    }

    public String getInputName() {
        String string = Tile.getInputName(this.getInput());
        if (string == null) {
            string = "class " + Classes.getShortClassName((Object)this.input);
        }
        return string;
    }

    private static String getInputName(Object object) {
        if (object instanceof File) {
            return ((File)object).getName();
        }
        if (object instanceof URI) {
            return ((URI)object).getPath();
        }
        if (object instanceof URL) {
            return ((URL)object).getPath();
        }
        if (object instanceof CharSequence) {
            return object.toString();
        }
        return null;
    }

    public String getFormatName() {
        return Formats.getDisplayName(this.getImageReaderSpi());
    }

    public int getImageIndex() {
        return this.imageIndex & 0xFFFF;
    }

    final AffineTransform getPendingGridToCRS(boolean bl) {
        assert (!bl || Thread.holdsLock(this));
        if (this.xSubsampling != 0 || this.ySubsampling != 0) {
            return null;
        }
        AffineTransform affineTransform = this.gridToCRS;
        if (bl) {
            this.gridToCRS = null;
        }
        return affineTransform;
    }

    public synchronized AffineTransform getGridToCRS() throws IllegalStateException {
        this.checkGeometryValidity();
        return this.gridToCRS;
    }

    final synchronized void setGridToCRS(AffineTransform affineTransform) throws IllegalStateException {
        if (this.gridToCRS != null) {
            if (!this.gridToCRS.equals(affineTransform)) {
                throw new IllegalStateException();
            }
        } else {
            this.gridToCRS = affineTransform;
        }
    }

    public synchronized Dimension getSubsampling() throws IllegalStateException {
        this.checkGeometryValidity();
        return new Dimension(this.xSubsampling & 0xFFFF, this.ySubsampling & 0xFFFF);
    }

    final void setSubsampling(Dimension dimension) throws IllegalStateException {
        assert (Thread.holdsLock(this));
        if (this.xSubsampling != 0 || this.ySubsampling != 0) {
            throw new IllegalStateException();
        }
        Tile.checkSubsampling(dimension);
        this.xSubsampling = Tile.toShort(dimension.width);
        this.ySubsampling = Tile.toShort(dimension.height);
    }

    public Dimension getSubsamplingFloor(Dimension dimension) throws IllegalStateException {
        if (dimension != null) {
            int n;
            int n2;
            try {
                n2 = dimension.width % (this.xSubsampling & 0xFFFF);
                n = dimension.height % (this.ySubsampling & 0xFFFF);
            }
            catch (ArithmeticException arithmeticException) {
                throw new IllegalStateException("Tile must be processed by TileManagerFactory.", arithmeticException);
            }
            if (n2 != 0 || n != 0) {
                int n3 = dimension.width - n2;
                int n4 = dimension.height - n;
                if (n3 != 0 && n4 != 0) {
                    return new Dimension(n3, n4);
                }
                return null;
            }
        }
        return dimension;
    }

    final boolean isFinerThan(Dimension dimension) {
        return (this.xSubsampling & 0xFFFF) < dimension.width || (this.ySubsampling & 0xFFFF) < dimension.height;
    }

    final boolean isLargerThan(Tile tile) {
        return this.xSubsampling == tile.xSubsampling && this.ySubsampling == tile.ySubsampling && (this.width & 0xFFFF) * (this.height & 0xFFFF) > (tile.width & 0xFFFF) * (tile.height & 0xFFFF);
    }

    public synchronized Point getLocation() throws IllegalStateException {
        this.checkGeometryValidity();
        return new Point(this.x, this.y);
    }

    final boolean isSizeEquals(int n, int n2) {
        assert (this.getClass() == Tile.class && this.width != 0 && this.height != 0) : this;
        return (this.width & 0xFFFF) == n && (this.height & 0xFFFF) == n2;
    }

    public synchronized Dimension getSize() throws IOException {
        if (this.width == 0 && this.height == 0) {
            int n = this.getImageIndex();
            ImageReader imageReader = this.getImageReader();
            this.setSize(imageReader.getWidth(n), imageReader.getHeight(n));
            Tile.dispose(imageReader);
        }
        return new Dimension(this.width & 0xFFFF, this.height & 0xFFFF);
    }

    public synchronized Rectangle getRegion() throws IllegalStateException, IOException {
        this.checkGeometryValidity();
        if (this.width == 0 && this.height == 0) {
            Dimension dimension = this.getSize();
            this.setSize(dimension.width, dimension.height);
        }
        return new Rectangle(this.x, this.y, this.width & 0xFFFF, this.height & 0xFFFF);
    }

    final Rectangle getAbsoluteRegion() throws IOException {
        Rectangle rectangle = this.getRegion();
        int n = this.xSubsampling & 0xFFFF;
        int n2 = this.ySubsampling & 0xFFFF;
        rectangle.x *= n;
        rectangle.y *= n2;
        rectangle.width *= n;
        rectangle.height *= n2;
        return rectangle;
    }

    final void setAbsoluteRegion(Rectangle rectangle) throws ArithmeticException {
        assert (Thread.holdsLock(this));
        int n = this.xSubsampling & 0xFFFF;
        int n2 = this.ySubsampling & 0xFFFF;
        assert (rectangle.width % n == 0 && rectangle.height % n2 == 0) : rectangle;
        this.x = rectangle.x / n;
        this.y = rectangle.y / n2;
        this.setSize(rectangle.width / n, rectangle.height / n2);
    }

    void setSize(int n, int n2) throws IllegalArgumentException {
        int n3;
        String string;
        this.width = (short)n;
        this.height = (short)n2;
        if ((this.width & 0xFFFF) != n) {
            string = "width";
            n3 = n;
        } else if ((this.height & 0xFFFF) != n2) {
            string = "height";
            n3 = n2;
        } else {
            return;
        }
        this.width = 0;
        this.height = 0;
        throw new IllegalArgumentException(Errors.format((int)255, (Object)string, (Object)n3, (Object)0, (Object)65535));
    }

    final void absoluteToRelative(Rectangle rectangle) throws ArithmeticException {
        int n = this.xSubsampling & 0xFFFF;
        int n2 = this.ySubsampling & 0xFFFF;
        int n3 = rectangle.x;
        int n4 = rectangle.width + n3;
        int n5 = rectangle.y;
        int n6 = rectangle.height + n5;
        if (n3 < 0) {
            n3 -= n - 1;
        }
        if (n4 > 0) {
            n4 += n - 1;
        }
        if (n5 < 0) {
            n5 -= n2 - 1;
        }
        if (n6 > 0) {
            n6 += n2 - 1;
        }
        rectangle.x = n3 /= n;
        rectangle.y = n5 /= n2;
        rectangle.width = (n4 /= n) - n3;
        rectangle.height = (n6 /= n2) - n5;
    }

    final synchronized void translate(int n, int n2) {
        this.x += n;
        this.y += n2;
        this.gridToCRS = null;
    }

    final int countUnwantedPixelsFromAbsolute(Rectangle rectangle, Dimension dimension) throws IOException {
        int n = this.xSubsampling & 0xFFFF;
        int n2 = this.ySubsampling & 0xFFFF;
        assert (dimension.width >= n && dimension.height >= n2) : dimension;
        Rectangle rectangle2 = this.getRegion();
        long l = Math.max((long)rectangle.x, (long)n * (long)rectangle2.x);
        long l2 = Math.max((long)rectangle.y, (long)n2 * (long)rectangle2.y);
        long l3 = Math.min((long)rectangle.x + (long)rectangle.width, (long)n * ((long)rectangle2.x + (long)rectangle2.width));
        long l4 = Math.min((long)rectangle.y + (long)rectangle.height, (long)n2 * ((long)rectangle2.y + (long)rectangle2.height));
        long l5 = Math.max(l3 - l, 0L) * Math.max(l4 - l2, 0L);
        l5 /= (long)(dimension.width * dimension.height);
        l5 = (long)(rectangle2.width * rectangle2.height) - l5;
        assert (l5 >= 0L && l5 <= Integer.MAX_VALUE) : l5;
        return (int)l5;
    }

    private static Object toComparable(Object object) {
        if (object instanceof URL) {
            try {
                object = ((URL)object).toURI();
            }
            catch (URISyntaxException uRISyntaxException) {
                Logging.recoverableException((Logger)LOGGER, Tile.class, (String)"compare", (Throwable)uRISyntaxException);
            }
        } else if (object instanceof CharSequence) {
            object = object.toString();
        }
        return object;
    }

    private static Object toCompatible(Object object, Object object2) {
        if (object2 instanceof URI) {
            if (object instanceof File) {
                object = ((File)object).toURI();
            }
        } else if (object2 instanceof String && (object instanceof File || object instanceof URI)) {
            object = object.toString();
        }
        return object;
    }

    private static int compareInputs(Object object, Object object2) {
        if (Utilities.equals((Object)object, (Object)object2)) {
            return 0;
        }
        object = Tile.toComparable(object);
        object2 = Tile.toComparable(object2);
        object = Tile.toCompatible(object, object2);
        object2 = Tile.toCompatible(object2, object);
        if (object instanceof Comparable && object.getClass().isInstance(object2)) {
            return ((Comparable)object).compareTo(object2);
        }
        if (object2 instanceof Comparable && object2.getClass().isInstance(object)) {
            return -((Comparable)object2).compareTo(object);
        }
        int n = object.getClass().getCanonicalName().compareTo(object2.getClass().getCanonicalName());
        if (n != 0) {
            return n;
        }
        return System.identityHashCode(object2) - System.identityHashCode(object);
    }

    @Override
    public final int compareTo(Tile tile) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = Tile.compareInputs(this.input, tile.input);
        if (n5 == 0 && (n5 = (this.imageIndex & 0xFFFF) - (tile.imageIndex & 0xFFFF)) == 0 && (n5 = (n4 = this.ySubsampling & 0xFFFF) - (n3 = tile.ySubsampling & 0xFFFF)) == 0 && (n5 = (n2 = this.xSubsampling & 0xFFFF) - (n = tile.xSubsampling & 0xFFFF)) == 0 && (n5 = this.y * n4 - tile.y * n3) == 0) {
            n5 = this.x * n2 - tile.x * n;
        }
        return n5;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            Tile tile = (Tile)object;
            if (this.x == tile.x && this.y == tile.y && this.xSubsampling == tile.xSubsampling && this.ySubsampling == tile.ySubsampling && this.imageIndex == tile.imageIndex && Utilities.equals((Object)this.provider, (Object)tile.provider) && Utilities.deepEquals((Object)this.input, (Object)tile.input)) {
                return !(this.width != 0 && tile.width != 0 && this.width != tile.width || this.height != 0 && tile.height != 0 && this.height != tile.height);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.provider.hashCode() + Utilities.deepHashCode((Object)this.input) + 31 * this.imageIndex;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortClassName((Object)this)).append('[');
        stringBuilder.append("format=\"").append(this.getFormatName()).append("\", input=\"").append(this.getInputName()).append("\", index=").append(this.getImageIndex());
        if (this.xSubsampling != 0 || this.ySubsampling != 0) {
            Cloneable cloneable;
            stringBuilder.append(", location=(");
            if (this.width == 0 && this.height == 0) {
                cloneable = this.getLocation();
                stringBuilder.append(((Point)cloneable).x).append(',').append(((Point)cloneable).y);
            } else {
                try {
                    cloneable = this.getRegion();
                    stringBuilder.append(cloneable.x).append(',').append(cloneable.y).append("), size=(").append(cloneable.width).append(',').append(cloneable.height);
                }
                catch (IOException iOException) {
                    stringBuilder.append(iOException);
                }
            }
            cloneable = this.getSubsampling();
            stringBuilder.append("), subsampling=(").append(((Dimension)cloneable).width).append(',').append(((Dimension)cloneable).height).append(')');
        } else if ((this.width != 0 || this.height != 0) && this.getClass() == Tile.class) {
            stringBuilder.append(", size=(").append(this.width & 0xFFFF).append(',').append(this.height & 0xFFFF).append(')');
        }
        return stringBuilder.append(']').toString();
    }

    static String toString(Collection<Tile> collection, int n) {
        StringWriter stringWriter = new StringWriter();
        try {
            Tile.writeTable(collection, stringWriter, n);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return stringWriter.toString();
    }

    public static void writeTable(Collection<Tile> collection, Writer writer, int n) throws IOException {
        int n2 = n;
        TableWriter tableWriter = new TableWriter(writer);
        tableWriter.nextLine('\u2550');
        tableWriter.write("Format\tInput\tindex\tx\ty\twidth\theight\tdx\tdy\n");
        tableWriter.nextLine('\u2500');
        tableWriter.setMultiLinesCells(true);
        for (Tile tile : collection) {
            if (--n2 < 0) break;
            tableWriter.setAlignment(0);
            String string = tile.getFormatName();
            if (string != null) {
                tableWriter.write(string);
            }
            tableWriter.nextColumn();
            tableWriter.write(tile.getInputName());
            tableWriter.nextColumn();
            tableWriter.setAlignment(2);
            tableWriter.write(String.valueOf(tile.getImageIndex()));
            tableWriter.nextColumn();
            int n3 = tile.x;
            int n4 = tile.y;
            int n5 = tile.width & 0xFFFF;
            int n6 = tile.height & 0xFFFF;
            int n7 = tile.xSubsampling & 0xFFFF;
            int n8 = tile.ySubsampling & 0xFFFF;
            if (tile.getClass() != Tile.class) {
                Dimension dimension = tile.getSubsampling();
                n7 = dimension.width;
                n8 = dimension.height;
                try {
                    Rectangle rectangle = tile.getRegion();
                    n3 = rectangle.x;
                    n4 = rectangle.y;
                    n5 = rectangle.width;
                    n6 = rectangle.height;
                }
                catch (IOException iOException) {
                    n5 = 0;
                    n6 = 0;
                }
            }
            tableWriter.write(String.valueOf(n3));
            tableWriter.nextColumn();
            tableWriter.write(String.valueOf(n4));
            if (n5 != 0 || n6 != 0) {
                tableWriter.nextColumn();
                tableWriter.write(String.valueOf(n5));
                tableWriter.nextColumn();
                tableWriter.write(String.valueOf(n6));
            } else {
                tableWriter.nextColumn();
                tableWriter.nextColumn();
            }
            if (n7 != 0 || n8 != 0) {
                tableWriter.nextColumn();
                tableWriter.write(String.valueOf(n7));
                tableWriter.nextColumn();
                tableWriter.write(String.valueOf(n8));
            }
            tableWriter.nextLine();
        }
        tableWriter.nextLine('\u2550');
        tableWriter.flush();
        if (n2 < 0) {
            writer.write(Vocabulary.format((int)198, (Object)(collection.size() - n)));
            writer.write(System.getProperty("line.separator", "\n"));
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(Classes.getClass((Object)this.provider));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        IIORegistry iIORegistry = IIORegistry.getDefaultInstance();
        Class clazz = object.getClass();
        try {
            clazz = (Class)object;
            Field field = Tile.class.getDeclaredField("provider");
            field.setAccessible(true);
            field.set(this, iIORegistry.getServiceProviderByClass(clazz));
        }
        catch (Exception exception) {
            InvalidClassException invalidClassException = new InvalidClassException(clazz.getCanonicalName(), Errors.format((int)76, (Object)clazz, ImageReaderSpi.class));
            invalidClassException.initCause(exception);
            throw invalidClassException;
        }
        if (this.provider == null) {
            throw new ClassNotFoundException(clazz.getCanonicalName());
        }
    }
}

