/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.mosaic;

import java.awt.Rectangle;
import java.util.Map;
import org.geotoolkit.image.io.mosaic.TreeNode;

final class SelectedNode
extends TreeNode {
    protected long cost;

    SelectedNode(Rectangle rectangle) {
        super(rectangle);
        assert (!this.isEmpty());
    }

    @Override
    public void addChild(TreeNode treeNode) throws ClassCastException {
        long l;
        super.addChild(treeNode);
        if (treeNode != null && (l = ((SelectedNode)treeNode).cost) != 0L) {
            SelectedNode selectedNode = this;
            do {
                selectedNode.cost += l;
            } while ((selectedNode = (SelectedNode)selectedNode.getParent()) != null);
        }
    }

    @Override
    public void removeChildren() {
        long l = this.childrenCost();
        if (l != 0L) {
            SelectedNode selectedNode = this;
            do {
                selectedNode.cost -= l;
            } while ((selectedNode = (SelectedNode)selectedNode.getParent()) != null);
        }
        super.removeChildren();
    }

    @Override
    public void remove() {
        if (this.cost != 0L) {
            TreeNode treeNode = this;
            while ((treeNode = treeNode.getParent()) != null) {
                treeNode.cost -= this.cost;
            }
        }
        super.remove();
    }

    private long childrenCost() {
        long l = 0L;
        for (SelectedNode selectedNode = (SelectedNode)this.firstChildren(); selectedNode != null; selectedNode = (SelectedNode)selectedNode.nextSibling()) {
            l += selectedNode.cost;
        }
        assert (this.cost >= l);
        return l;
    }

    public final boolean isCheaperThan(SelectedNode selectedNode) {
        if (this.cost < selectedNode.cost) {
            return true;
        }
        if (this.cost == selectedNode.cost) {
            return this.getTileCount() < selectedNode.getTileCount();
        }
        return false;
    }

    final void removeTrivialOverlaps(Map<Rectangle, SelectedNode> map) {
        SelectedNode selectedNode;
        SelectedNode selectedNode2 = (SelectedNode)this.firstChildren();
        while (selectedNode2 != null) {
            SelectedNode selectedNode3 = (SelectedNode)selectedNode2.nextSibling();
            selectedNode2.removeTrivialOverlaps(map);
            selectedNode2 = selectedNode3;
        }
        if (this.tile == null && (selectedNode2 = (SelectedNode)this.firstChildren()) != null) {
            int n = this.x;
            int n2 = this.y;
            int n3 = this.width;
            int n4 = this.height;
            this.height = -1;
            this.width = -1;
            do {
                assert (!selectedNode2.isEmpty()) : selectedNode2;
                this.add(selectedNode2);
            } while ((selectedNode2 = (SelectedNode)selectedNode2.nextSibling()) != null);
            if (this.x < n) {
                n3 -= n - this.x;
                this.x = n;
            }
            if (this.y < n2) {
                n4 -= n2 - this.y;
                this.y = n2;
            }
            if (this.width > n3) {
                this.width = n3;
            }
            if (this.height > n4) {
                this.height = n4;
            }
        }
        if ((selectedNode = map.put(this, this)) != null && selectedNode != this) {
            if (!this.isCheaperThan(selectedNode)) {
                if (selectedNode.getParent() == this) {
                    if (this.tile != null) {
                        this.tile = null;
                        this.cost = this.childrenCost();
                    }
                    return;
                }
                map.put(selectedNode, selectedNode);
                selectedNode = this;
            }
            selectedNode.remove();
            selectedNode.removeFrom(map);
            assert (map.get(selectedNode) != selectedNode);
        }
    }

    private void removeFrom(Map<Rectangle, SelectedNode> map) {
        for (SelectedNode selectedNode = (SelectedNode)this.firstChildren(); selectedNode != null; selectedNode = (SelectedNode)selectedNode.nextSibling()) {
            selectedNode.removeFrom(map);
            SelectedNode selectedNode2 = map.remove(selectedNode);
            if (selectedNode2 == null || selectedNode2 == selectedNode) continue;
            map.put(selectedNode2, selectedNode2);
        }
    }

    @Override
    boolean checkValidity() {
        if (this.childrenCost() > this.cost) {
            throw new AssertionError(this);
        }
        return super.checkValidity();
    }
}

