/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.mosaic;

import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageReaderSpi;
import net.jcip.annotations.Immutable;
import org.geotoolkit.util.Utilities;

@Immutable
class ReaderInputPair {
    private final Object reader;
    private final Object input;
    private final int hash;

    ReaderInputPair(ImageReaderSpi imageReaderSpi, Object object) {
        this.reader = imageReaderSpi;
        this.input = object;
        this.hash = this.hash();
    }

    ReaderInputPair(ImageReader imageReader, Object object) {
        this.reader = imageReader;
        this.input = object;
        this.hash = this.hash();
    }

    public final int hashCode() {
        return this.hash;
    }

    private int hash() {
        return this.reader.hashCode() + 31 * Utilities.deepHashCode((Object)this.input);
    }

    public final boolean equals(Object object) {
        if (object instanceof ReaderInputPair) {
            ReaderInputPair readerInputPair = (ReaderInputPair)object;
            return Utilities.equals((Object)this.reader, (Object)readerInputPair.reader) && Utilities.deepEquals((Object)this.input, (Object)readerInputPair.input);
        }
        return false;
    }

    static final class WithWriter
    extends ReaderInputPair {
        ImageWriter writer;
        boolean needStream;

        WithWriter(ImageReaderSpi imageReaderSpi, Class<?> clazz) {
            super(imageReaderSpi, clazz);
        }
    }
}

