/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.jcip.annotations.NotThreadSafe;
import org.geotoolkit.gui.swing.tree.TreeFormat;
import org.geotoolkit.gui.swing.tree.Trees;
import org.geotoolkit.image.io.mosaic.GridNode;
import org.geotoolkit.image.io.mosaic.SelectedNode;
import org.geotoolkit.image.io.mosaic.Tile;
import org.geotoolkit.image.io.mosaic.TreeNode;

@NotThreadSafe
final class RTree
implements org.geotoolkit.util.Cloneable {
    private static final Level LEVEL = Level.FINER;
    final TreeNode root;
    Rectangle regionOfInterest;
    Dimension subsampling;
    boolean subsamplingChangeAllowed;
    private Dimension subsamplingCandidate;
    private final Set<Dimension> subsamplingDone;
    private final Queue<Dimension> subsamplingToTry;
    private final Map<Rectangle, SelectedNode> distinctBounds;
    boolean inUse;

    public RTree(TreeNode treeNode) {
        this.root = treeNode;
        this.subsamplingDone = new HashSet<Dimension>();
        this.subsamplingToTry = new LinkedList<Dimension>();
        this.distinctBounds = new HashMap<Rectangle, SelectedNode>();
    }

    public RTree clone() {
        return new RTree(this.root);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.root);
    }

    public Dimension getTileSize() {
        Dimension dimension = new Dimension();
        for (TreeNode treeNode : this.root) {
            GridNode gridNode = (GridNode)treeNode;
            int n = gridNode.width / gridNode.getXSubsampling();
            int n2 = gridNode.height / gridNode.getYSubsampling();
            if (n > dimension.width) {
                dimension.width = n;
            }
            if (n2 <= dimension.height) continue;
            dimension.height = n2;
        }
        return dimension;
    }

    public boolean intersects() {
        return ((GridNode)this.root).intersects(this.regionOfInterest, this.subsampling);
    }

    private static Dimension getSubsamplingFloor(TreeNode treeNode, Dimension dimension) {
        Dimension dimension2;
        Tile tile = treeNode.tile;
        if (tile != null && (dimension2 = tile.getSubsamplingFloor(dimension)) != null) {
            return dimension2;
        }
        for (treeNode = treeNode.firstChildren(); treeNode != null; treeNode = treeNode.nextSibling()) {
            dimension2 = RTree.getSubsamplingFloor(treeNode, dimension);
            if (dimension2 == null) continue;
            return dimension2;
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tile> searchTiles() throws IOException {
        Cloneable cloneable;
        assert (this.subsamplingDone.isEmpty() && this.subsamplingToTry.isEmpty() && this.distinctBounds.isEmpty());
        Dimension dimension = this.subsamplingCandidate = this.subsampling;
        Cloneable cloneable2 = null;
        int n = 0;
        long l = Long.MAX_VALUE;
        try {
            if (this.subsamplingChangeAllowed && (cloneable = RTree.getSubsamplingFloor(this.root, this.subsampling)) != this.subsampling) {
                this.subsamplingDone.add(this.subsampling);
                this.subsamplingToTry.add(this.subsampling);
                this.subsamplingCandidate = cloneable;
            }
            do {
                int n2;
                if ((cloneable = this.addTileCandidate(this.root, l)) == null) continue;
                try {
                    ((SelectedNode)cloneable).removeTrivialOverlaps(this.distinctBounds);
                    n2 = this.distinctBounds.size();
                }
                finally {
                    this.distinctBounds.clear();
                }
                if (cloneable2 != null && !((SelectedNode)cloneable).isCheaperThan((SelectedNode)cloneable2)) continue;
                cloneable2 = cloneable;
                n = n2;
                dimension = this.subsamplingCandidate;
                l = ((SelectedNode)cloneable).cost;
            } while ((this.subsamplingCandidate = this.subsamplingToTry.poll()) != null);
        }
        finally {
            this.subsamplingToTry.clear();
            this.subsamplingDone.clear();
        }
        this.subsampling.setSize(dimension);
        cloneable = new ArrayList(n);
        if (cloneable2 != null) {
            assert (((SelectedNode)cloneable2).checkValidity()) : ((TreeNode)cloneable2).toTree();
            ((TreeNode)cloneable2).getTiles((List<Tile>)((Object)cloneable));
            if (Tile.LOGGER.isLoggable(LEVEL)) {
                TreeFormat treeFormat = new TreeFormat();
                StringBuilder stringBuilder = new StringBuilder("Tiles count: ").append(cloneable.size()).append(treeFormat.getLineSeparator());
                treeFormat.format((javax.swing.tree.TreeNode)((Object)cloneable2), stringBuilder);
                LogRecord logRecord = new LogRecord(LEVEL, stringBuilder.toString());
                logRecord.setSourceClassName("org.geotoolkit.image.io.mosaic.TileManager");
                logRecord.setSourceMethodName("getTiles");
                logRecord.setLoggerName(Tile.LOGGER.getName());
                Tile.LOGGER.log(logRecord);
            }
        }
        assert (cloneable.isEmpty() == !this.intersects()) : cloneable;
        return cloneable;
    }

    private SelectedNode addTileCandidate(TreeNode treeNode, long l) throws IOException {
        long l2;
        if (!treeNode.intersects(this.regionOfInterest)) {
            return null;
        }
        SelectedNode selectedNode = null;
        Tile tile = treeNode.tile;
        if (tile != null) {
            assert (treeNode.equals(tile.getAbsoluteRegion())) : tile;
            Dimension dimension = tile.getSubsamplingFloor(this.subsamplingCandidate);
            if (dimension != null) {
                if (dimension != this.subsamplingCandidate) {
                    if (this.subsamplingChangeAllowed && this.subsamplingDone.add(dimension)) {
                        this.subsamplingToTry.add(dimension);
                    }
                } else {
                    Rectangle rectangle = treeNode.intersection(this.regionOfInterest);
                    selectedNode = new SelectedNode(rectangle);
                    selectedNode.tile = tile;
                    selectedNode.cost = tile.countUnwantedPixelsFromAbsolute(rectangle, this.subsampling);
                }
            }
        }
        if (treeNode.isLeaf()) {
            return selectedNode;
        }
        if (selectedNode == null) {
            selectedNode = new SelectedNode(treeNode.intersection(this.regionOfInterest));
            l2 = selectedNode.cost;
        } else {
            l2 = selectedNode.cost;
            if (l2 == 0L || selectedNode.equals(treeNode) && !tile.isFinerThan(this.subsamplingCandidate)) {
                return selectedNode;
            }
            if (l2 < l) {
                l = l2;
            }
        }
        for (TreeNode treeNode2 : treeNode) {
            selectedNode.addChild(this.addTileCandidate(treeNode2, l));
            if (selectedNode.cost - l2 < l) continue;
            if (selectedNode.tile != null) {
                selectedNode.removeChildren();
            }
            return selectedNode;
        }
        selectedNode.tile = null;
        selectedNode.cost -= l2;
        if (selectedNode.isLeaf()) {
            return null;
        }
        TreeNode treeNode3 = selectedNode.getChild();
        if (treeNode3 != null && treeNode3.equals(selectedNode)) {
            selectedNode.removeChildren();
            selectedNode = (SelectedNode)treeNode3;
        }
        return selectedNode;
    }

    public String toString() {
        return Trees.toString((javax.swing.tree.TreeNode)((Object)this.root));
    }
}

