/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.geotoolkit.image.io.mosaic.FilenameFormatter;
import org.geotoolkit.image.io.mosaic.Tile;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.FrequencySortedSet;
import org.geotoolkit.util.collection.IntegerList;
import org.geotoolkit.util.collection.UnmodifiableArrayList;
import org.geotoolkit.util.logging.Logging;

final class OverviewLevel
implements Comparable<OverviewLevel>,
Serializable {
    private static final long serialVersionUID = -1441934881339348L;
    private static final Set<Class<?>> INPUT_TYPES = new HashSet(8);
    private OverviewLevel finer;
    private int ordinal;
    private int nx;
    private int ny;
    private final int xSubsampling;
    private final int ySubsampling;
    private final int xOffset;
    private final int yOffset;
    private final int dx;
    private final int dy;
    private final Rectangle mosaic;
    private List<Tile> tiles;
    private Tile[] patterns;
    private IntegerList patternUsed;
    private transient Tile sample;
    private transient int lastPattern;
    private transient FilenameFormatter formatter;

    OverviewLevel(Tile tile, Rectangle rectangle) throws IOException {
        Dimension dimension = tile.getSubsampling();
        Rectangle rectangle2 = tile.getRegion();
        this.mosaic = rectangle = new Rectangle(rectangle);
        this.dx = rectangle2.width;
        int n = rectangle2.x % this.dx;
        this.dy = rectangle2.height;
        int n2 = rectangle2.y % this.dy;
        if (n < 0) {
            n += this.dx;
        }
        if (n2 < 0) {
            n2 += this.dy;
        }
        this.xOffset = n;
        this.yOffset = n2;
        this.xSubsampling = dimension.width;
        this.ySubsampling = dimension.height;
        this.patterns = new Tile[]{tile};
    }

    OverviewLevel(Tile tile, Dimension dimension) throws IOException {
        this.mosaic = tile.getRegion();
        this.dx = this.mosaic.width;
        int n = this.mosaic.x % this.dx;
        this.dy = this.mosaic.height;
        int n2 = this.mosaic.y % this.dy;
        if (n < 0) {
            n += this.dx;
        }
        if (n2 < 0) {
            n2 += this.dy;
        }
        this.xOffset = n;
        this.yOffset = n2;
        assert (dimension.equals(tile.getSubsampling())) : dimension;
        this.xSubsampling = dimension.width;
        this.ySubsampling = dimension.height;
        this.tiles = new ArrayList<Tile>();
        this.tiles.add(tile);
    }

    final void add(Tile tile, Dimension dimension) throws IOException, IllegalArgumentException {
        assert (dimension.equals(tile.getSubsampling())) : dimension;
        assert (dimension.width == this.xSubsampling && dimension.height == this.ySubsampling) : dimension;
        Rectangle rectangle = tile.getRegion();
        if (rectangle.width > this.dx || rectangle.height > this.dy) {
            throw new IllegalArgumentException(Errors.format((int)209));
        }
        int n = rectangle.x % this.dx;
        int n2 = rectangle.y % this.dy;
        if (n < 0) {
            n += this.dx;
        }
        if (n2 < 0) {
            n2 += this.dy;
        }
        if ((n -= this.xOffset) < 0 || n + rectangle.width > this.dx || (n2 -= this.yOffset) < 0 || n2 + rectangle.height > this.dy) {
            throw new IllegalArgumentException(Errors.format((int)144));
        }
        this.mosaic.add(rectangle);
        this.tiles.add(tile);
    }

    /*
     * WARNING - void declaration
     */
    final synchronized void createLinkedList(int n, OverviewLevel overviewLevel) throws IOException {
        assert (this.ordinal == 0 && this.finer == null);
        this.ordinal = n;
        this.finer = overviewLevel;
        assert (this.getFinerLevel() == overviewLevel);
        this.nx = (this.mosaic.width + (this.dx - 1)) / this.dx;
        this.ny = (this.mosaic.height + (this.dy - 1)) / this.dy;
        assert (this.tiles == null != (this.patterns == null));
        if (this.patterns != null) {
            return;
        }
        this.formatter = new FilenameFormatter();
        Rectangle rectangle = new Rectangle(this.xOffset, this.yOffset, this.dx, this.dy);
        HashMap<Tile, ArrayList<Tile>> hashMap = new HashMap<Tile, ArrayList<Tile>>();
        for (Tile object : this.tiles) {
            String string = this.inputPattern(object);
            Tile tile = string != null ? new Tile(object, string, rectangle) : null;
            Serializable serializable = (ArrayList<Tile>)hashMap.get(tile);
            if (serializable == null) {
                serializable = new ArrayList<Tile>();
                hashMap.put(tile, (ArrayList<Tile>)serializable);
            }
            serializable.add(object);
        }
        this.tiles = (List)hashMap.remove(null);
        Iterator<Tile> iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            List list = (List)((Object)iterator.next());
            if (list.size() >= 4) continue;
            if (this.tiles == null) {
                this.tiles = list;
            } else {
                this.tiles.addAll(list);
            }
            iterator.remove();
        }
        if (this.tiles != null) {
            this.tiles = UnmodifiableArrayList.wrap((Object[])this.toArray(this.tiles));
        }
        this.formatter = null;
        if (hashMap.isEmpty()) {
            return;
        }
        this.patterns = new Tile[hashMap.size()];
        this.patternUsed = new IntegerList(this.nx * this.ny, this.patterns.length, true);
        int n2 = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            this.patterns[n2++] = (Tile)entry.getKey();
            for (Serializable serializable : (List)entry.getValue()) {
                Point point = this.getIndex2D((Tile)serializable);
                int n3 = this.getIndex(point.x, point.y);
                int n4 = this.patternUsed.getInteger(n3);
                if (n4 != 0 && n4 != n2 || this.tiles != null && this.tiles.get(n3) != null) {
                    throw OverviewLevel.duplicatedTile(point);
                }
                this.patternUsed.setInteger(n3, n2);
            }
        }
        if (this.patterns.length == 1) {
            void var6_12;
            int n5 = this.patternUsed.size();
            while (--var6_12 >= 0) {
                if (this.patternUsed.getInteger((int)var6_12) != 0 || this.tiles != null && this.tiles.get((int)var6_12) != null) continue;
                return;
            }
            this.patternUsed = null;
        }
    }

    private String inputPattern(Tile tile) throws IOException {
        Class<?> clazz;
        Object object;
        if (tile.getClass() != Tile.class) {
            return null;
        }
        if (!tile.isSizeEquals(this.dx, this.dy)) {
            object = this.getIndex2D(tile);
            if (!tile.getRegion().equals(this.getCellBounds(((Point)object).x, ((Point)object).y))) {
                return null;
            }
        }
        if (!INPUT_TYPES.contains(clazz = (object = tile.getInput()).getClass())) {
            return null;
        }
        Point point = this.getIndex2D(tile);
        String string = object.toString();
        if ((string = this.formatter.guessPattern(this.ordinal, point.x, point.y, string)) != null) {
            string = clazz.getSimpleName() + ':' + string;
        }
        return string;
    }

    private static IllegalArgumentException duplicatedTile(Point point) {
        return new IllegalArgumentException(Errors.format((int)55, (Object)("location=" + point.x + ',' + point.y)));
    }

    final void removeTile(int n, int n2) {
        int n3 = this.getIndex(n, n2);
        assert (this.tiles == null || this.tiles.get(n3) == null);
        if (this.patternUsed == null) {
            this.patternUsed = new IntegerList(this.nx * this.ny, this.patterns.length, true);
            this.patternUsed.fill(1);
        }
        this.patternUsed.setInteger(n3, 0);
    }

    private Tile[] toArray(Collection<Tile> collection) {
        Tile[] tileArray = new Tile[this.nx * this.ny];
        for (Tile tile : collection) {
            Point point = this.getIndex2D(tile);
            int n = this.getIndex(point.x, point.y);
            if (tileArray[n] != null && !tile.equals(tileArray[n])) {
                throw OverviewLevel.duplicatedTile(point);
            }
            tileArray[n] = tile;
        }
        return tileArray;
    }

    private Rectangle toTileIndex(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(this.dx * this.xSubsampling, this.dy * this.ySubsampling);
        int n = rectangle.x - this.mosaic.x * this.xSubsampling;
        int n2 = rectangle.y - this.mosaic.y * this.ySubsampling;
        if (n >= 0) {
            rectangle2.x = n / rectangle2.width;
        }
        if (n2 >= 0) {
            rectangle2.y = n2 / rectangle2.height;
        }
        rectangle2.width = Math.min(this.nx, (n += rectangle.width - 1) / rectangle2.width + 1) - rectangle2.x;
        rectangle2.height = Math.min(this.ny, (n2 += rectangle.height - 1) / rectangle2.height + 1) - rectangle2.y;
        return rectangle2;
    }

    private Point getIndex2D(Tile tile) {
        Point point = tile.getLocation();
        point.x -= this.mosaic.x;
        point.y -= this.mosaic.y;
        assert (point.x % this.dx == 0 && point.y % this.dy == 0) : point;
        point.x /= this.dx;
        point.y /= this.dy;
        return point;
    }

    private int getIndex(int n, int n2) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.nx || n2 < 0 || n2 >= this.ny) {
            throw new IndexOutOfBoundsException(Errors.format((int)96, (Object)("(" + n + ',' + n2 + ')')));
        }
        return n2 * this.nx + n;
    }

    public OverviewLevel getFinerLevel() {
        assert (this.finer == null ? this.ordinal == 0 : this.ordinal > 0) : this.ordinal;
        assert (this.finer == null || this.compareTo(this.finer) >= 0 && this.finer.ordinal == this.ordinal - 1) : this.finer;
        return this.finer;
    }

    public int getNumTiles() {
        int n = 0;
        if (this.patterns != null) {
            n = this.nx * this.ny;
            if (this.patternUsed != null) {
                n -= this.patternUsed.occurrence(0);
            }
        } else if (this.tiles != null) {
            for (Tile tile : this.tiles) {
                if (tile == null) continue;
                ++n;
            }
        }
        return n;
    }

    public final int getNumXTiles() {
        return this.nx;
    }

    public final int getNumYTiles() {
        return this.ny;
    }

    public Dimension getTileSize() {
        if (this.mosaic.width > this.dx || this.mosaic.height > this.dy) {
            return new Dimension(this.dx, this.dy);
        }
        return null;
    }

    public Rectangle getAbsoluteRegion() {
        return new Rectangle(this.xSubsampling * this.mosaic.x, this.ySubsampling * this.mosaic.y, this.xSubsampling * this.mosaic.width, this.ySubsampling * this.mosaic.height);
    }

    private boolean isAbsoluteTilesRegion(Rectangle rectangle) {
        int n;
        int n2 = this.dx * this.xSubsampling;
        if (rectangle.width % n2 == 0 && rectangle.height % (n = this.dy * this.ySubsampling) == 0) {
            return (rectangle.x - this.xOffset * this.xSubsampling) % n2 == 0 && (rectangle.y - this.yOffset * this.ySubsampling) % n == 0;
        }
        return false;
    }

    public synchronized Tile getSampleTile() {
        if (this.sample == null) {
            if (this.patterns != null) {
                int n = 0;
                do {
                    this.sample = this.patterns[n++];
                } while (this.sample == null);
            } else {
                int n = 0;
                do {
                    this.sample = this.tiles.get(n++);
                } while (this.sample == null);
            }
        }
        return this.sample;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Tile getTile(int n, int n2) throws IndexOutOfBoundsException, MalformedURLException {
        String string;
        int n3 = this.getIndex(n, n2);
        if (this.tiles != null) {
            Tile tile = this.tiles.get(n3);
            if (tile != null) {
                assert (this.patternUsed == null || this.patternUsed.getInteger(n3) == 0) : n3;
                return tile;
            }
            if (this.patterns == null) {
                return null;
            }
        }
        int n4 = 0;
        if (this.patternUsed != null) {
            n4 = this.patternUsed.get(n3);
            if (n4 == 0) {
                return null;
            }
            --n4;
        }
        Tile tile = this.patterns[n4];
        String string2 = tile.getInput().toString();
        Object object = this;
        synchronized (object) {
            if (this.formatter == null) {
                this.formatter = new FilenameFormatter();
                this.lastPattern = -1;
            }
            if (n4 != this.lastPattern) {
                this.formatter.applyPattern(string2.substring(string2.indexOf(58) + 1));
                this.lastPattern = n4;
            }
            string = this.formatter.generateFilename(this.ordinal, n, n2);
        }
        if (string2.startsWith("File")) {
            object = new File(string);
        } else if (string2.startsWith("URL")) {
            object = new URL(string);
        } else if (string2.startsWith("URI")) {
            try {
                object = new URI(IOUtilities.encodeURI((String)string));
            }
            catch (URISyntaxException uRISyntaxException) {
                MalformedURLException malformedURLException = new MalformedURLException(uRISyntaxException.getLocalizedMessage());
                malformedURLException.initCause(uRISyntaxException);
                throw malformedURLException;
            }
        } else {
            object = string;
        }
        assert (INPUT_TYPES.contains(object.getClass())) : object;
        return new Tile(tile, object, this.getCellBounds(n, n2));
    }

    private Rectangle getCellBounds(int n, int n2) {
        int n3 = n * this.dx;
        int n4 = n2 * this.dy;
        return new Rectangle(this.mosaic.x + n3, this.mosaic.y + n4, Math.min(this.dx, this.mosaic.width - n3), Math.min(this.dy, this.mosaic.height - n4));
    }

    final void getInternalTiles(FrequencySortedSet<? super Tile> frequencySortedSet) {
        int n = 0;
        if (this.tiles != null) {
            for (Tile tile : this.tiles) {
                if (tile == null) continue;
                frequencySortedSet.add((Object)tile);
                ++n;
            }
        }
        if (this.patterns != null) {
            int n2 = 0;
            while (n2 < this.patterns.length) {
                Tile tile;
                tile = this.patterns[n2++];
                int n3 = this.patternUsed != null ? this.patternUsed.occurrence(n2) : this.nx * this.ny - n;
                frequencySortedSet.add((Object)tile, n3);
            }
        }
    }

    final long getTiles(ArrayList<Tile> arrayList, Rectangle rectangle, Dimension dimension, long l) throws IOException {
        Rectangle rectangle2 = this.toTileIndex(rectangle);
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        int n3 = rectangle2.width + n;
        int n4 = rectangle2.height + n2;
        rectangle2.width = this.dx * this.xSubsampling;
        rectangle2.height = this.dy * this.ySubsampling;
        int n5 = this.mosaic.x * this.xSubsampling;
        int n6 = this.mosaic.y * this.ySubsampling;
        int n7 = arrayList.size();
        if (n7 == 0) {
            int n8 = (n3 - n) * (n4 - n2);
            arrayList.ensureCapacity(n8);
        }
        long l2 = 0L;
        for (int i = n2; i < n4; ++i) {
            block1: for (int j = n; j < n3; ++j) {
                Tile tile = this.getTile(j, i);
                if (tile == null) continue;
                long l3 = tile.countUnwantedPixelsFromAbsolute(rectangle, dimension);
                if (l3 != 0L) {
                    if ((l2 += l3) >= l) {
                        arrayList.subList(n7, arrayList.size()).clear();
                        return -1L;
                    }
                    rectangle2.x = n5 + rectangle2.width * j;
                    rectangle2.y = n6 + rectangle2.height * i;
                    assert (rectangle2.contains(tile.getAbsoluteRegion()) || tile.getClass() != Tile.class) : tile;
                    OverviewLevel overviewLevel = this;
                    while ((overviewLevel = overviewLevel.getFinerLevel()) != null) {
                        if (!overviewLevel.isAbsoluteTilesRegion(rectangle2)) continue;
                        Rectangle rectangle3 = rectangle2.intersection(rectangle);
                        long l4 = overviewLevel.getTiles(arrayList, rectangle3, dimension, l3);
                        if (l4 < 0L) break;
                        l2 += l4 - l3;
                        continue block1;
                    }
                }
                arrayList.add(tile);
            }
        }
        assert (arrayList.size() > n7 == this.intersects(rectangle));
        return l2;
    }

    final boolean intersects(Rectangle rectangle) throws IOException {
        Rectangle rectangle2 = this.toTileIndex(rectangle);
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        int n3 = rectangle2.width + n;
        int n4 = rectangle2.height + n2;
        for (int i = n2; i < n4; ++i) {
            for (int j = n; j < n3; ++j) {
                int n5 = this.getIndex(j, i);
                if (this.tiles != null) {
                    Tile tile = this.tiles.get(n5);
                    if (tile != null) {
                        if (!rectangle.intersects(tile.getAbsoluteRegion())) continue;
                        return true;
                    }
                    if (this.patterns == null) continue;
                }
                if (this.patternUsed != null && this.patternUsed.get(n5) == 0) continue;
                return true;
            }
        }
        return false;
    }

    static boolean contains(OverviewLevel overviewLevel, Tile tile) {
        Dimension dimension = tile.getSubsampling();
        while (overviewLevel != null) {
            if (overviewLevel.xSubsampling == dimension.width && overviewLevel.ySubsampling == dimension.height) {
                Point point = overviewLevel.getIndex2D(tile);
                if (point.x < 0 || point.x >= overviewLevel.nx || point.y < 0 || point.y >= overviewLevel.ny) break;
                try {
                    return tile.equals(overviewLevel.getTile(point.x, point.y));
                }
                catch (MalformedURLException malformedURLException) {
                    Logging.recoverableException((Logger)Tile.LOGGER, OverviewLevel.class, (String)"contains", (Throwable)malformedURLException);
                    break;
                }
            }
            overviewLevel = overviewLevel.getFinerLevel();
        }
        return false;
    }

    @Override
    public int compareTo(Dimension dimension) {
        int n = this.xSubsampling * this.ySubsampling - dimension.width * dimension.height;
        if (n == 0 && (n = this.xSubsampling - dimension.width) == 0) {
            n = this.ySubsampling - dimension.height;
        }
        return n;
    }

    @Override
    public int compareTo(OverviewLevel overviewLevel) {
        int n = this.xSubsampling * this.ySubsampling - overviewLevel.xSubsampling * overviewLevel.ySubsampling;
        if (n == 0 && (n = this.xSubsampling - overviewLevel.xSubsampling) == 0) {
            n = this.ySubsampling - overviewLevel.ySubsampling;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof OverviewLevel) {
            OverviewLevel overviewLevel = (OverviewLevel)object;
            return this.ordinal == overviewLevel.ordinal && this.dx == overviewLevel.dx && this.dy == overviewLevel.dy && this.nx == overviewLevel.nx && this.ny == overviewLevel.ny && this.xSubsampling == overviewLevel.xSubsampling && this.ySubsampling == overviewLevel.ySubsampling && this.xOffset == overviewLevel.xOffset && this.yOffset == overviewLevel.yOffset && Utilities.equals((Object)this.mosaic, (Object)overviewLevel.mosaic) && Utilities.equals(this.tiles, overviewLevel.tiles) && Arrays.equals(this.patterns, overviewLevel.patterns) && Utilities.equals((Object)this.patternUsed, (Object)overviewLevel.patternUsed) && Utilities.equals((Object)this.finer, (Object)overviewLevel.finer);
        }
        return false;
    }

    public int hashCode() {
        int n = this.ordinal + 31 * (this.xSubsampling + 31 * (this.ySubsampling + Arrays.hashCode(this.patterns)));
        if (this.finer != null) {
            n += 31 * this.finer.hashCode();
        }
        return n;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.ordinal + ", subsampling=(" + this.xSubsampling + ',' + this.ySubsampling + "), " + this.getNumTiles() + " tiles]";
    }

    static {
        INPUT_TYPES.add(String.class);
        INPUT_TYPES.add(File.class);
        INPUT_TYPES.add(URL.class);
        INPUT_TYPES.add(URI.class);
    }
}

