/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.DataBuffer;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageOutputStream;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.logging.PerformanceLevel;
import org.geotoolkit.image.io.InvalidImageStoreException;
import org.geotoolkit.image.io.UnsupportedImageFormatException;
import org.geotoolkit.image.io.mosaic.CachingMosaicReader;
import org.geotoolkit.image.io.mosaic.GridNode;
import org.geotoolkit.image.io.mosaic.MosaicImageReadParam;
import org.geotoolkit.image.io.mosaic.MosaicImageReader;
import org.geotoolkit.image.io.mosaic.MosaicImageWriteParam;
import org.geotoolkit.image.io.mosaic.ReaderInputPair;
import org.geotoolkit.image.io.mosaic.Tile;
import org.geotoolkit.image.io.mosaic.TileCopier;
import org.geotoolkit.image.io.mosaic.TileManager;
import org.geotoolkit.image.io.mosaic.TileManagerFactory;
import org.geotoolkit.image.io.mosaic.TileWritingPolicy;
import org.geotoolkit.image.io.mosaic.TreeNode;
import org.geotoolkit.internal.Threads;
import org.geotoolkit.internal.image.ImageUtilities;
import org.geotoolkit.internal.image.io.IIOUtilities;
import org.geotoolkit.internal.image.io.RawFile;
import org.geotoolkit.internal.image.io.SupportFiles;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.internal.io.TemporaryFile;
import org.geotoolkit.internal.rmi.RMI;
import org.geotoolkit.internal.rmi.ShareableTask;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.Disposable;
import org.geotoolkit.util.Version;
import org.geotoolkit.util.logging.LogProducer;
import org.geotoolkit.util.logging.Logging;

public class MosaicImageWriter
extends ImageWriter
implements LogProducer,
Disposable {
    private static final int FILL_VALUE = 0;
    private static final int IMAGE_TILE_SIZE = 64;
    private Level logLevel;
    private final Map<Tile, RawFile> temporaryFiles = new HashMap<Tile, RawFile>();

    public MosaicImageWriter() {
        this(null);
    }

    public MosaicImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi != null ? imageWriterSpi : Spi.DEFAULT);
    }

    private boolean isLoggable() {
        Level level = this.logLevel;
        if (level == null) {
            level = PerformanceLevel.SLOWEST;
        }
        return Tile.LOGGER.isLoggable(level);
    }

    private Level getFineLevel() {
        Level level = this.logLevel;
        return level != null ? level : PerformanceLevel.FINE;
    }

    public Level getLogLevel() {
        Level level = this.logLevel;
        return level != null ? level : PerformanceLevel.PERFORMANCE;
    }

    public void setLogLevel(Level level) {
        this.logLevel = level;
    }

    public TileManager[] getOutput() {
        TileManager[] tileManagerArray = (TileManager[])super.getOutput();
        return tileManagerArray != null ? (TileManager[])tileManagerArray.clone() : null;
    }

    @Override
    public void setOutput(Object object) throws IllegalArgumentException {
        TileManager[] tileManagerArray;
        try {
            tileManagerArray = TileManagerFactory.DEFAULT.createFromObject(object);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getLocalizedMessage(), iOException);
        }
        super.setOutput(tileManagerArray);
    }

    @Override
    public MosaicImageWriteParam getDefaultWriteParam() {
        return new MosaicImageWriteParam();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("png");
        while (iterator.hasNext()) {
            ImageWriter imageWriter = iterator.next();
            if (!this.filter(imageWriter)) continue;
            File file = File.createTempFile("MIW", ".png");
            try {
                ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file);
                imageWriter.setOutput(imageOutputStream);
                imageWriter.write(iIOMetadata, iIOImage, imageWriteParam);
                imageOutputStream.close();
                imageWriteParam = imageWriteParam instanceof MosaicImageWriteParam ? new MosaicImageWriteParam((MosaicImageWriteParam)imageWriteParam) : null;
                this.writeFromInput(file, 0, imageWriteParam);
            }
            finally {
                file.delete();
            }
            return;
        }
        throw new UnsupportedImageFormatException(Errors.format((int)159));
    }

    public boolean writeFromInput(Object object, ImageWriteParam imageWriteParam) throws IOException {
        return this.writeFromInput(object, 0, imageWriteParam, true);
    }

    public boolean writeFromInput(Object object, int n, ImageWriteParam imageWriteParam) throws IOException {
        return this.writeFromInput(object, n, imageWriteParam, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    final boolean writeFromInput(Object object, int n, ImageWriteParam imageWriteParam, boolean bl) throws IOException {
        ImageReader imageReader = this.getImageReader(object, n, imageWriteParam);
        LinkedList<ReaderInputPair.WithWriter> linkedList = new LinkedList<ReaderInputPair.WithWriter>();
        if (bl && imageReader.getNumImages(false) <= 1) {
            bl = false;
        }
        boolean bl2 = !bl && this.writeFromReader(imageReader, n, imageWriteParam, linkedList);
        MosaicImageWriter.close(imageReader.getInput(), object);
        try {
            imageReader.dispose();
        }
        finally {
            this.deleteTemporaryFiles();
        }
        LinkedList<ReaderInputPair.WithWriter> linkedList2 = linkedList;
        synchronized (linkedList2) {
            for (ReaderInputPair.WithWriter withWriter : linkedList) {
                withWriter.writer.dispose();
            }
            linkedList.clear();
        }
        catch (Throwable throwable) {
            try {
                imageReader.dispose();
            }
            finally {
                this.deleteTemporaryFiles();
            }
            LinkedList<ReaderInputPair.WithWriter> linkedList3 = linkedList;
            synchronized (linkedList3) {
                for (ReaderInputPair.WithWriter withWriter : linkedList) {
                    withWriter.writer.dispose();
                }
                linkedList.clear();
            }
            throw throwable;
        }
        if (bl) {
            throw new InvalidImageStoreException(Errors.getResources((Locale)this.locale).getString(100));
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeFromReader(ImageReader imageReader, int n, ImageWriteParam imageWriteParam, final Queue<ReaderInputPair.WithWriter> queue) throws IOException {
        boolean bl;
        Serializable serializable;
        Object object;
        Object object2;
        int n2;
        List<Tile> list;
        TileWritingPolicy tileWritingPolicy;
        int n3;
        TileManager[] tileManagerArray;
        this.clearAbortRequest();
        if (imageWriteParam instanceof MosaicImageWriteParam) {
            tileManagerArray = (TileManager[])imageWriteParam;
            n3 = tileManagerArray.getOutputIndex();
            tileWritingPolicy = tileManagerArray.getTileWritingPolicy();
        } else {
            n3 = 0;
            tileWritingPolicy = TileWritingPolicy.DEFAULT;
        }
        this.processImageStarted(n3);
        tileManagerArray = this.getOutput();
        if (tileManagerArray == null) {
            throw new IllegalStateException(Errors.format((int)157));
        }
        if (tileWritingPolicy == TileWritingPolicy.NO_WRITE) {
            list = Collections.emptyList();
            n2 = 1;
        } else {
            SampleModel sampleModel;
            list = new LinkedList<Tile>(tileManagerArray[n3].getTiles());
            ImageTypeSpecifier imageTypeSpecifier = imageReader.getRawImageType(n);
            n2 = imageTypeSpecifier != null && (sampleModel = imageTypeSpecifier.getSampleModel()) != null ? Math.max(1, sampleModel.getNumBands() * DataBuffer.getDataTypeSize(sampleModel.getDataType()) / 8) : 3;
        }
        int n4 = list.size();
        float f = 100.0f / (float)n4;
        if (!tileWritingPolicy.overwrite) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object2 = (Tile)iterator.next();
                object = ((Tile)object2).getInput();
                if (!(object instanceof File) || !((File)(serializable = (File)object)).isFile()) continue;
                iterator.remove();
            }
        }
        int n5 = Runtime.getRuntime().availableProcessors();
        object2 = Executors.newFixedThreadPool(n5, Threads.createThreadFactory((String)"MosaicImageWriter #"));
        object = new Semaphore(n5 + 1);
        serializable = new ArrayList();
        GridNode gridNode = new GridNode(list.toArray(new Tile[list.size()]));
        ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
        final boolean bl2 = this.isLoggable();
        boolean bl3 = bl = !(imageReader instanceof LogProducer);
        if (!bl) {
            ((LogProducer)imageReader).setLogLevel(this.logLevel);
        }
        if (imageWriteParam != null) {
            if (imageWriteParam.getSourceXSubsampling() != 1 || imageWriteParam.getSubsamplingXOffset() != 0 || imageWriteParam.getSourceYSubsampling() != 1 || imageWriteParam.getSubsamplingYOffset() != 0 || imageWriteParam.getSourceRegion() != null) {
                throw new IllegalArgumentException(Errors.format((int)206, (Object)"writeFromInput"));
            }
            imageReadParam.setSourceBands(imageWriteParam.getSourceBands());
        }
        long l = this.getMaximumMemoryAllocation();
        int n6 = (int)(l / (long)n2);
        BufferedImage bufferedImage = null;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        while (!list.isEmpty()) {
            if (this.abortRequested()) {
                this.processWriteAborted();
                object2.shutdown();
                return false;
            }
            Dimension dimension = new Dimension();
            Tile tile = MosaicImageWriter.getEnclosingTile(list, gridNode, dimension, n6);
            Rectangle rectangle = tile.getAbsoluteRegion();
            this.awaitTermination((List<Future<?>>)((Object)serializable), n4 - list.size(), f);
            if (bufferedImage != null) {
                int n11 = rectangle.width / dimension.width;
                int n12 = rectangle.height / dimension.height;
                if (n11 <= bufferedImage.getWidth() && n12 <= bufferedImage.getHeight()) {
                    ImageUtilities.fill((WritableRenderedImage)bufferedImage, (Number)0);
                    assert (this.isEmpty(bufferedImage, new Rectangle(n11, n12)));
                } else {
                    bufferedImage = null;
                }
                n6 = (int)(l / (long)n2);
            }
            imageReadParam.setDestination(bufferedImage);
            imageReadParam.setSourceRegion(rectangle);
            imageReadParam.setSourceSubsampling(dimension.width, dimension.height, 0, 0);
            if (imageReadParam instanceof MosaicImageReadParam) {
                ((MosaicImageReadParam)imageReadParam).setNullForEmptyImage(true);
            }
            if (bl) {
                this.log(false, 177, tile);
            }
            System.gc();
            try {
                bufferedImage = imageReader.read(n, imageReadParam);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if ((n6 >>>= 1) == 0) {
                    throw outOfMemoryError;
                }
                if (!bl2) continue;
                this.log(true, 41, Float.valueOf((float)rectangle.width * (float)rectangle.height / 1048576.0f));
                continue;
            }
            if (bl2 && bufferedImage != imageReadParam.getDestination()) {
                this.logMemoryUsage();
            }
            assert (bufferedImage == null || bufferedImage.getWidth() * dimension.width >= rectangle.width && bufferedImage.getHeight() * dimension.height >= rectangle.height) : tile;
            assert (list.contains(tile)) : tile;
            Iterator<Tile> iterator = list.iterator();
            while (iterator.hasNext()) {
                Rectangle rectangle2;
                final Tile tile2 = iterator.next();
                Dimension dimension2 = tile2.getSubsampling();
                if (!MosaicImageWriter.isDivisor(dimension2, dimension) || !rectangle.contains(rectangle2 = tile2.getAbsoluteRegion())) continue;
                int n13 = dimension2.width / dimension.width;
                int n14 = dimension2.height / dimension.height;
                rectangle2.translate(-rectangle.x, -rectangle.y);
                rectangle2.x /= dimension.width;
                rectangle2.y /= dimension.height;
                rectangle2.width /= dimension.width;
                rectangle2.height /= dimension.height;
                if (bufferedImage != null && (tileWritingPolicy.includeEmpty || !this.isEmpty(bufferedImage, rectangle2))) {
                    try {
                        ((Semaphore)object).acquire();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InterruptedIOException(interruptedException.getLocalizedMessage());
                    }
                    final ReaderInputPair.WithWriter withWriter = this.getImageWriter(tile2, bufferedImage, queue);
                    final ImageWriteParam imageWriteParam2 = withWriter.writer.getDefaultWriteParam();
                    this.onTileWrite(tile2, imageWriteParam2);
                    imageWriteParam2.setSourceRegion(rectangle2);
                    imageWriteParam2.setSourceSubsampling(n13, n14, 0, 0);
                    if (imageWriteParam2.canWriteTiles()) {
                        if (n7 != rectangle2.width) {
                            n7 = rectangle2.width;
                            n8 = MosaicImageWriter.imageTileSize(n7);
                        }
                        if (n9 != rectangle2.height) {
                            n9 = rectangle2.height;
                            n10 = MosaicImageWriter.imageTileSize(n9);
                        }
                        imageWriteParam2.setTilingMode(2);
                        imageWriteParam2.setTiling(n8, n10, 0, 0);
                    }
                    final IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
                    serializable.add(object2.submit(new Callable<Object>((Semaphore)object){
                        final /* synthetic */ Semaphore val$submitPermits;
                        {
                            this.val$submitPermits = semaphore;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Object call() throws IOException {
                            Object object;
                            Object object2;
                            try {
                                if (MosaicImageWriter.this.abortRequested()) {
                                    Object var2_1 = null;
                                    return var2_1;
                                }
                                if (bl2) {
                                    MosaicImageWriter.this.log(false, 260, tile2);
                                }
                                object2 = tile2.getInput();
                                object = withWriter.writer;
                                boolean bl = false;
                                try {
                                    ((ImageWriter)object).write(null, iIOImage, imageWriteParam2);
                                    MosaicImageWriter.close(((ImageWriter)object).getOutput(), object2);
                                    bl = true;
                                }
                                finally {
                                    if (bl) {
                                        ((ImageWriter)object).reset();
                                        Queue queue2 = queue;
                                        synchronized (queue2) {
                                            queue.add(withWriter);
                                        }
                                    } else {
                                        Object object3 = ((ImageWriter)object).getOutput();
                                        ((ImageWriter)object).dispose();
                                        MosaicImageWriter.close(object3, null);
                                        if (object2 instanceof File) {
                                            ((File)object2).delete();
                                        }
                                    }
                                }
                            }
                            finally {
                                this.val$submitPermits.release();
                            }
                            if (object2 instanceof File && (object = tile2.getGridToCRS()) != null) {
                                object = new AffineTransform((AffineTransform)object);
                                Point point = tile2.getLocation();
                                ((AffineTransform)object).translate(point.x, point.y);
                                SupportFiles.writeTFW((File)object2, (AffineTransform)object);
                            }
                            return null;
                        }
                    }));
                    Queue<ReaderInputPair.WithWriter> queue2 = queue;
                    synchronized (queue2) {
                        while (queue.size() > 2 * n5) {
                            queue.remove().writer.dispose();
                        }
                    }
                }
                iterator.remove();
                if (!gridNode.remove(tile2)) {
                    throw new AssertionError(tile2);
                }
            }
            assert (!list.contains(tile)) : tile;
        }
        this.awaitTermination((List<Future<?>>)((Object)serializable), n4, f);
        object2.shutdown();
        if (this.abortRequested()) {
            this.processWriteAborted();
            return false;
        }
        this.processImageComplete();
        return true;
    }

    private static void close(Object object, Object object2) throws IOException {
        if (object != object2) {
            IOUtilities.close((Object)object);
        }
    }

    private void awaitTermination(List<Future<?>> list, int n, float f) throws IOException {
        n -= list.size();
        Throwable throwable = null;
        for (int i = 0; i < list.size(); ++i) {
            Future<?> future = list.get(i);
            try {
                future.get();
                this.processImageProgress(f * (float)n++);
                continue;
            }
            catch (ExecutionException executionException) {
                if (throwable == null) {
                    throwable = executionException.getCause();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.abort();
            int n2 = list.size();
            while (--n2 > i) {
                future = list.get(n2);
                if (!future.cancel(false)) continue;
                list.remove(n2);
            }
        }
        list.clear();
        if (throwable != null) {
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new UndeclaredThrowableException(throwable);
        }
    }

    private void log(boolean bl, int n, Object object) {
        Loggings loggings = bl ? Loggings.getResources((Locale)this.locale) : Vocabulary.getResources((Locale)this.locale);
        LogRecord logRecord = loggings.getLogRecord(this.getFineLevel(), n, object);
        logRecord.setSourceClassName(MosaicImageWriter.class.getName());
        logRecord.setSourceMethodName("writeFromInput");
        logRecord.setLoggerName(Tile.LOGGER.getName());
        Tile.LOGGER.log(logRecord);
    }

    private static Tile getEnclosingTile(List<Tile> list, TreeNode treeNode, Dimension dimension, int n) throws IOException {
        HashSet<Dimension> hashSet = list.size() > 24 ? new HashSet<Dimension>() : null;
        int n2 = 0;
        Tile tile = null;
        Tile tile2 = null;
        long l = Long.MAX_VALUE;
        assert (treeNode.containsAll(list));
        block0: for (Tile tile3 : list) {
            Object object;
            Rectangle rectangle = tile3.getAbsoluteRegion();
            Dimension dimension2 = tile3.getSubsampling();
            if (hashSet != null && !hashSet.add(dimension2)) continue;
            Collection<Tile> collection = treeNode.containedIn(rectangle);
            assert (collection.contains(tile3)) : tile3;
            if (collection.size() <= n2) {
                assert (tile != null) : n2;
                continue;
            }
            Dimension dimension3 = dimension2;
            int n3 = dimension2.width * dimension2.height;
            for (Tile tile4 : collection) {
                object = tile4.getSubsampling();
                int n4 = ((Dimension)object).width * ((Dimension)object).height;
                if (n4 >= n3) continue;
                n3 = n4;
                dimension3 = object;
            }
            long l2 = (long)rectangle.width * (long)rectangle.height;
            if ((l2 /= (long)n3) > (long)n) {
                if (l2 >= l) continue;
                l = l2;
                tile2 = tile3;
                continue;
            }
            object = collection.iterator();
            while (object.hasNext()) {
                Tile tile5 = (Tile)object.next();
                Dimension dimension4 = tile5.getSubsampling();
                if (!MosaicImageWriter.isDivisor(dimension2, dimension4)) {
                    object.remove();
                    if (!dimension4.equals(dimension3)) continue;
                    continue block0;
                }
                Rectangle rectangle2 = tile5.getAbsoluteRegion();
                l2 = (long)rectangle2.width * (long)rectangle2.height;
                if ((l2 /= (long)n3) <= (long)n) continue;
                object.remove();
                if (!dimension4.equals(dimension3)) continue;
                continue block0;
            }
            int n5 = collection.size();
            if (tile != null && n5 <= n2) continue;
            tile = tile3;
            n2 = n5;
            dimension.setSize(dimension3);
        }
        if (tile == null) {
            tile = tile2;
            dimension.setSize(tile2.getSubsampling());
        }
        return tile;
    }

    private static boolean isDivisor(Dimension dimension, Dimension dimension2) {
        return dimension.width % dimension2.width == 0 && dimension.height % dimension2.height == 0;
    }

    public long getMaximumMemoryAllocation() {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.maxMemory();
        runtime.gc();
        long l2 = runtime.freeMemory();
        l2 += l - runtime.totalMemory();
        return Math.max(0x1000000L, l2 -= l / 8L);
    }

    private void logMemoryUsage() {
        Vocabulary vocabulary = Vocabulary.getResources((Locale)this.locale);
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory();
        double d = 1.0f - (float)runtime.freeMemory() / (float)l;
        LogRecord logRecord = new LogRecord(this.getFineLevel(), vocabulary.getString(190, (Object)(l / 0x100000L)) + ". " + vocabulary.getString(191, (Object)d) + '.');
        logRecord.setSourceClassName(MosaicImageWriter.class.getName());
        logRecord.setSourceMethodName("writeFromInput");
        logRecord.setLoggerName(Tile.LOGGER.getName());
        Tile.LOGGER.log(logRecord);
    }

    protected boolean isCachingEnabled(ImageReader imageReader, int n) throws IOException {
        TileManager[] tileManagerArray;
        int n2;
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        long l = runtime.maxMemory() - (runtime.totalMemory() - runtime.freeMemory());
        int n3 = IIOUtilities.bitsPerPixel(imageReader.getRawImageType(n));
        long l2 = RMI.getSharedTemporaryDirectory().getUsableSpace();
        long l3 = 0x400000L;
        if (imageReader instanceof MosaicImageReader) {
            n2 = 0;
            block0: for (TileManager tileManager : ((MosaicImageReader)imageReader).getInput()) {
                if ((l3 += tileManager.diskUsage() * (long)n3 / 8L) > l2) {
                    return false;
                }
                if (tileManager.largestTileArea() * (long)n3 / 8L > l) {
                    return false;
                }
                if (n2 != 0) continue;
                for (ImageReaderSpi imageReaderSpi : tileManager.getImageReaderSpis()) {
                    if (IIOUtilities.guessCompressionRatio(imageReaderSpi) == 1) continue;
                    n2 = 1;
                    continue block0;
                }
            }
            if (n2 == 0) {
                return false;
            }
        } else {
            int n4;
            if (IIOUtilities.guessCompressionRatio(imageReader.getOriginatingProvider()) == 1) {
                return false;
            }
            n2 = imageReader.getWidth(n);
            long l4 = (long)n2 * (long)(n4 = imageReader.getHeight(n)) * (long)n3 / 8L;
            if (l4 > l || (l3 += l4) > l2) {
                return false;
            }
        }
        if ((tileManagerArray = this.getOutput()) != null) {
            for (TileManager tileManager : tileManagerArray) {
                File file = tileManager.rootDirectory();
                if (file == null) continue;
                l2 = file.getUsableSpace();
                long l5 = tileManager.diskUsage() * (long)n3 / 8L;
                for (ImageReaderSpi imageReaderSpi : tileManager.getImageReaderSpis()) {
                    int n5 = IIOUtilities.guessCompressionRatio(imageReaderSpi);
                    if (n5 == 0) continue;
                    l5 /= (long)n5;
                    break;
                }
                if ((l3 += l5) <= l2) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean filter(ImageReader imageReader) throws IOException {
        return true;
    }

    protected boolean filter(ImageWriter imageWriter) throws IOException {
        return true;
    }

    private boolean isEmpty(BufferedImage bufferedImage, Rectangle rectangle) {
        int[] nArray = null;
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = rectangle.x + rectangle.width;
        int n2 = rectangle.y + rectangle.height;
        for (int i = rectangle.y; i < n2; ++i) {
            for (int j = rectangle.x; j < n; ++j) {
                nArray = writableRaster.getPixel(j, i, nArray);
                int n3 = nArray.length;
                while (--n3 >= 0) {
                    if (nArray[n3] == 0) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected void onTileWrite(Tile tile, ImageWriteParam imageWriteParam) throws IOException {
    }

    private ImageReader getImageReader(Object object, int n, ImageWriteParam imageWriteParam) throws IOException {
        Object object2;
        BufferedImageOp bufferedImageOp = null;
        ImageReader imageReader = this.getImageReader(object);
        if (imageWriteParam instanceof MosaicImageWriteParam) {
            object2 = (MosaicImageWriteParam)imageWriteParam;
            if (((MosaicImageWriteParam)object2).getTileWritingPolicy() == TileWritingPolicy.NO_WRITE) {
                return imageReader;
            }
            bufferedImageOp = ((MosaicImageWriteParam)object2).getSourceTileFilter();
        }
        if (bufferedImageOp != null || this.isCachingEnabled(imageReader, n)) {
            object2 = new ArrayList();
            if (imageReader instanceof MosaicImageReader) {
                for (TileManager tileManager : ((MosaicImageReader)imageReader).getInput()) {
                    object2.addAll(tileManager.getTiles());
                }
            } else {
                object2.add(new Tile(imageReader.getOriginatingProvider(), object, 0, new Point(), (Dimension)null));
            }
            this.temporaryFiles.putAll((Map)RMI.execute((ShareableTask)new TileCopier((Collection<Tile>)object2, bufferedImageOp)));
        }
        return imageReader;
    }

    private ImageReader getImageReader(Object object) throws IOException {
        ImageReader imageReader;
        TileManager[] tileManagerArray;
        Object object2;
        Closeable closeable;
        if (MosaicImageReader.Spi.DEFAULT.canDecodeInput(object)) {
            closeable = new CachingMosaicReader(this.temporaryFiles, object);
            if (this.filter((ImageReader)((Object)closeable))) {
                return closeable;
            }
            ((ImageReader)((Object)closeable)).dispose();
        }
        closeable = null;
        boolean bl = false;
        do {
            if (bl) {
                closeable = Tile.createImageInputStream(object);
                if (closeable == null) continue;
                object2 = closeable;
            } else {
                object2 = object;
            }
            tileManagerArray = ImageIO.getImageReaders(object2);
            while (tileManagerArray.hasNext()) {
                imageReader = tileManagerArray.next();
                imageReader.setInput(object2);
                if (this.filter(imageReader)) {
                    return imageReader;
                }
                imageReader.dispose();
            }
        } while (bl = !bl);
        if (closeable != null) {
            closeable.close();
        }
        object2 = null;
        if (object instanceof File) {
            tileManagerArray = null;
            try {
                tileManagerArray = TileManagerFactory.DEFAULT.create((File)object);
            }
            catch (Exception exception) {
                object2 = exception;
            }
            if (tileManagerArray != null) {
                imageReader = new CachingMosaicReader(this.temporaryFiles, tileManagerArray);
                if (this.filter(imageReader)) {
                    return imageReader;
                }
                imageReader.dispose();
            }
        }
        throw new UnsupportedImageFormatException(Errors.format((int)158), (Throwable)object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private ReaderInputPair.WithWriter getImageWriter(Tile tile, RenderedImage renderedImage, Queue<ReaderInputPair.WithWriter> stringArray) throws IOException {
        ImageOutputStream imageOutputStream;
        block26: {
            Object object;
            Object object2;
            Class<?>[] classArray;
            Object object3;
            Object object4;
            Object object5;
            Object object6 = tile.getInput();
            Class<?> clazz = object6.getClass();
            ImageReaderSpi imageReaderSpi = tile.getImageReaderSpi();
            imageOutputStream = null;
            ReaderInputPair.WithWriter withWriter = new ReaderInputPair.WithWriter(imageReaderSpi, clazz);
            if (stringArray != null) {
                Object object7 = null;
                object5 = stringArray;
                // MONITORENTER : stringArray
                object4 = stringArray.iterator();
                while (object4.hasNext()) {
                    object3 = (ReaderInputPair.WithWriter)object4.next();
                    if (!withWriter.equals(object3)) continue;
                    object7 = object3;
                    object4.remove();
                    break;
                }
                // MONITOREXIT : object5
                if (object7 != null) {
                    object5 = ((ReaderInputPair.WithWriter)object7).writer;
                    if (((ReaderInputPair.WithWriter)object7).needStream) {
                        imageOutputStream = ImageIO.createImageOutputStream(object6);
                        ((ImageWriter)object5).setOutput(imageOutputStream);
                    } else {
                        ((ImageWriter)object5).setOutput(object6);
                    }
                    if (this.filter((ImageWriter)object5)) {
                        return object7;
                    }
                    ((ImageWriter)object5).dispose();
                }
            }
            int n = 0;
            object5 = imageReaderSpi.getImageWriterSpiNames();
            object4 = imageReaderSpi.getFormatNames();
            object3 = IIORegistry.getDefaultInstance();
            LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
            ArrayList<Object> arrayList = null;
            Iterator<ImageWriterSpi> iterator = null;
            boolean bl = true;
            block5: while (true) {
                block31: {
                    block30: {
                        block28: {
                            block29: {
                                block27: {
                                    if (object5 == null || n >= ((String[])object5).length) break block27;
                                    classArray = object5[n++];
                                    try {
                                        object2 = Class.forName((String)classArray);
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        Logging.recoverableException((Logger)Tile.LOGGER, MosaicImageWriter.class, (String)"getImageWriter", (Throwable)classNotFoundException);
                                        continue;
                                    }
                                    Object obj = ((ServiceRegistry)object3).getServiceProviderByClass(object2);
                                    if (!(obj instanceof ImageWriterSpi)) continue;
                                    object = (ImageWriterSpi)obj;
                                    break block28;
                                }
                                if (iterator == null) {
                                    iterator = ((ServiceRegistry)object3).getServiceProviders(ImageWriterSpi.class, true);
                                }
                                if (iterator.hasNext()) break block29;
                                if (arrayList == null || !linkedHashSet.isEmpty()) break block30;
                                iterator = arrayList.iterator();
                                arrayList = null;
                                bl = false;
                            }
                            if (!ArraysExt.intersects((Object[])object4, (Object[])((ImageReaderWriterSpi)(object = iterator.next())).getFormatNames())) continue;
                            if (bl && Tile.ignore((ImageWriterSpi)object)) {
                                if (arrayList == null) {
                                    arrayList = new ArrayList<Object>(4);
                                }
                                arrayList.add(object);
                                continue;
                            }
                        }
                        if (!((ImageWriterSpi)object).canEncodeImage(renderedImage) || !linkedHashSet.add(object)) continue;
                        break block31;
                    }
                    if (linkedHashSet.isEmpty()) break block26;
                    if (imageOutputStream == null) {
                        imageOutputStream = ImageIO.createImageOutputStream(object6);
                    }
                    if (imageOutputStream != null) {
                        object = imageOutputStream.getClass();
                        classArray = linkedHashSet.iterator();
                        break;
                    }
                    break block26;
                }
                classArray = ((ImageWriterSpi)object).getOutputTypes();
                int n2 = classArray.length;
                int n3 = 0;
                while (true) {
                    if (n3 >= n2) continue block5;
                    Class<?> clazz2 = classArray[n3];
                    if (clazz2.isAssignableFrom(clazz)) {
                        ImageWriter imageWriter = ((ImageWriterSpi)object).createWriterInstance();
                        imageWriter.setOutput(object6);
                        if (this.filter(imageWriter)) {
                            if (imageOutputStream != null) {
                                imageOutputStream.close();
                            }
                            withWriter.writer = imageWriter;
                            return withWriter;
                        }
                        imageWriter.dispose();
                        continue block5;
                    }
                    ++n3;
                }
                break;
            }
            block7: while (classArray.hasNext()) {
                object2 = (ImageWriterSpi)classArray.next();
                for (Class<?> clazz3 : ((ImageWriterSpi)object2).getOutputTypes()) {
                    if (!clazz3.isAssignableFrom((Class<?>)object)) continue;
                    ImageWriter imageWriter = ((ImageWriterSpi)object2).createWriterInstance();
                    imageWriter.setOutput(imageOutputStream);
                    if (this.filter(imageWriter)) {
                        withWriter.writer = imageWriter;
                        withWriter.needStream = true;
                        return withWriter;
                    }
                    imageWriter.dispose();
                    continue block7;
                }
            }
        }
        if (imageOutputStream == null) throw new UnsupportedImageFormatException(Errors.format((int)159));
        imageOutputStream.close();
        throw new UnsupportedImageFormatException(Errors.format((int)159));
    }

    private static int imageTileSize(int n) {
        int[] nArray = MathFunctions.divisors((int)n);
        int n2 = Arrays.binarySearch(nArray, 64);
        if (n2 < 0) {
            n2 ^= 0xFFFFFFFF;
        }
        return n2 < nArray.length ? nArray[n2] : n;
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    private void deleteTemporaryFiles() {
        Iterator<RawFile> iterator = this.temporaryFiles.values().iterator();
        while (iterator.hasNext()) {
            File file = iterator.next().file;
            if (!TemporaryFile.delete((File)file)) {
                file.deleteOnExit();
            }
            iterator.remove();
        }
    }

    @Override
    public void reset() {
        this.deleteTemporaryFiles();
        super.reset();
    }

    @Override
    public void dispose() {
        this.deleteTemporaryFiles();
        super.dispose();
    }

    public static class Spi
    extends ImageWriterSpi {
        public static final Spi DEFAULT = new Spi();

        public Spi() {
            this.vendorName = "Geotoolkit.org";
            this.version = Version.GEOTOOLKIT.toString();
            this.names = MosaicImageReader.Spi.NAMES;
            this.pluginClassName = "org.geotoolkit.image.io.mosaic.MosaicImageWriter";
        }

        @Override
        public synchronized Class<?>[] getOutputTypes() {
            if (this.outputTypes == null) {
                this.outputTypes = new Class[]{TileManager[].class, TileManager.class, Tile[].class, Collection.class};
            }
            return super.getOutputTypes();
        }

        public boolean canEncodeOutput(Object object) throws IOException {
            return MosaicImageReader.Spi.DEFAULT.canDecodeInput(object);
        }

        @Override
        public boolean canEncodeImage(ImageTypeSpecifier imageTypeSpecifier) {
            return true;
        }

        @Override
        public ImageWriter createWriterInstance(Object object) throws IOException {
            return new MosaicImageWriter(this);
        }

        @Override
        public String getDescription(Locale locale) {
            return "Mosaic Image Writer";
        }
    }
}

