/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.mosaic;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ComponentColorModel;
import java.awt.image.RenderedImage;
import javax.imageio.ImageWriteParam;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.image.ImageWorker;
import org.geotoolkit.image.io.mosaic.TileWritingPolicy;
import org.geotoolkit.internal.image.SimpleBufferedImageOp;
import org.opengis.coverage.PaletteInterpretation;

public class MosaicImageWriteParam
extends ImageWriteParam {
    private int outputIndex = 0;
    private TileWritingPolicy policy = TileWritingPolicy.DEFAULT;
    private BufferedImageOp sourceTileFilter;

    public MosaicImageWriteParam() {
    }

    MosaicImageWriteParam(MosaicImageWriteParam mosaicImageWriteParam) {
        this.outputIndex = mosaicImageWriteParam.outputIndex;
        this.policy = mosaicImageWriteParam.policy;
    }

    public int getOutputIndex() {
        return this.outputIndex;
    }

    public void setOutputIndex(int n) {
        ArgumentChecks.ensureBetween((String)"index", (int)0, (int)65535, (int)n);
        this.outputIndex = n;
    }

    public TileWritingPolicy getTileWritingPolicy() {
        return this.policy;
    }

    public void setTileWritingPolicy(TileWritingPolicy tileWritingPolicy) {
        ArgumentChecks.ensureNonNull((String)"policy", (Object)((Object)tileWritingPolicy));
        this.policy = tileWritingPolicy;
    }

    public BufferedImageOp getSourceTileFilter() {
        return this.sourceTileFilter;
    }

    public void setSourceTileFilter(BufferedImageOp bufferedImageOp) {
        this.sourceTileFilter = bufferedImageOp;
    }

    public void setOpaqueBorderFilter(Color ... colorArray) {
        this.setSourceTileFilter((BufferedImageOp)((Object)new BorderFilter(colorArray)));
    }

    private static final class BorderFilter
    extends SimpleBufferedImageOp {
        private static final long serialVersionUID = 890880010471839924L;
        private final Color[] colors;

        BorderFilter(Color[] colorArray) {
            this.colors = (Color[])colorArray.clone();
        }

        public RenderedImage filter(BufferedImage bufferedImage) {
            ImageWorker imageWorker = new ImageWorker((RenderedImage)bufferedImage);
            imageWorker.setColorSpaceType(PaletteInterpretation.RGB);
            imageWorker.setColorModelType(ComponentColorModel.class);
            double[][] dArray = new double[this.colors.length][imageWorker.getNumBands()];
            for (int i = 0; i < dArray.length; ++i) {
                Color color = this.colors[i];
                double[] dArray2 = dArray[i];
                switch (dArray2.length) {
                    default: {
                        dArray2[3] = color.getAlpha();
                    }
                    case 3: {
                        dArray2[2] = color.getBlue();
                    }
                    case 2: {
                        dArray2[1] = color.getGreen();
                    }
                    case 1: {
                        dArray2[0] = color.getRed();
                    }
                    case 0: 
                }
            }
            imageWorker.maskBackground(dArray, null);
            return imageWorker.getRenderedImage();
        }
    }
}

