/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.mosaic;

import java.util.Map;
import java.util.WeakHashMap;
import javax.imageio.IIOParamController;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import org.geotoolkit.image.io.mosaic.ImageTypePolicy;
import org.geotoolkit.image.io.mosaic.MosaicController;
import org.geotoolkit.image.io.mosaic.MosaicImageReader;

public class MosaicImageReadParam
extends ImageReadParam {
    private ImageTypePolicy imageTypePolicy;
    private boolean subsamplingChangeAllowed;
    private boolean nullForEmptyImage;
    final Map<ImageReader, ImageReadParam> readers = new WeakHashMap<ImageReader, ImageReadParam>();
    private Boolean hasController;

    public MosaicImageReadParam() {
        this(null);
        this.hasController = Boolean.FALSE;
    }

    protected MosaicImageReadParam(MosaicImageReader mosaicImageReader) {
        if (mosaicImageReader != null) {
            for (ImageReader imageReader : mosaicImageReader.readers.getTileReaders()) {
                this.readers.put(imageReader, null);
            }
        }
        this.controller = this.defaultController = MosaicController.DEFAULT;
    }

    public boolean isSubsamplingChangeAllowed() {
        return this.subsamplingChangeAllowed;
    }

    public void setSubsamplingChangeAllowed(boolean bl) {
        this.subsamplingChangeAllowed = bl;
    }

    public boolean getNullForEmptyImage() {
        return this.nullForEmptyImage;
    }

    public void setNullForEmptyImage(boolean bl) {
        this.nullForEmptyImage = bl;
    }

    public ImageTypePolicy getImageTypePolicy() {
        return this.imageTypePolicy;
    }

    public void setImageTypePolicy(ImageTypePolicy imageTypePolicy) {
        this.imageTypePolicy = imageTypePolicy;
    }

    final ImageReadParam getCachedTileParameters(ImageReader imageReader) {
        ImageReadParam imageReadParam = this.readers.get(imageReader);
        if (imageReadParam == null) {
            imageReadParam = this.getTileParameters(imageReader);
            this.readers.put(imageReader, imageReadParam);
        }
        return imageReadParam;
    }

    protected ImageReadParam getTileParameters(ImageReader imageReader) {
        ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
        imageReadParam.setSourceBands(this.sourceBands);
        imageReadParam.setDestinationBands(this.destinationBands);
        imageReadParam.setSourceProgressivePasses(this.minProgressivePass, this.numProgressivePasses);
        return imageReadParam;
    }

    @Override
    public boolean hasController() {
        if (this.controller != this.defaultController) {
            return super.hasController();
        }
        if (this.hasController == null) {
            this.hasController = Boolean.FALSE;
            for (Map.Entry<ImageReader, ImageReadParam> entry : this.readers.entrySet()) {
                ImageReadParam imageReadParam = entry.getValue();
                if (imageReadParam == null) {
                    imageReadParam = this.getTileParameters(entry.getKey());
                    entry.setValue(imageReadParam);
                }
                if (!imageReadParam.hasController()) continue;
                this.hasController = Boolean.TRUE;
                break;
            }
        }
        return this.hasController;
    }

    @Override
    public IIOParamController getDefaultController() {
        return super.getDefaultController();
    }
}

