/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.mosaic;

import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.geotoolkit.image.io.mosaic.OverviewLevel;
import org.geotoolkit.image.io.mosaic.Tile;
import org.geotoolkit.util.logging.Logging;

final class GridTileIterator
implements Iterator<Tile> {
    private OverviewLevel level;
    private int x;
    private int y;
    private Tile tile;

    GridTileIterator(OverviewLevel overviewLevel) {
        this.level = overviewLevel;
        this.advance();
    }

    private void advance() {
        while (this.level != null) {
            while (this.y < this.level.getNumYTiles()) {
                while (this.x < this.level.getNumXTiles()) {
                    try {
                        this.tile = this.level.getTile(this.x++, this.y);
                    }
                    catch (MalformedURLException malformedURLException) {
                        Logging.unexpectedException((Logger)Tile.LOGGER, GridTileIterator.class, (String)"next", (Throwable)malformedURLException);
                        continue;
                    }
                    if (this.tile == null) continue;
                    return;
                }
                this.x = 0;
                ++this.y;
            }
            this.y = 0;
            this.level = this.level.getFinerLevel();
        }
        this.tile = null;
    }

    @Override
    public boolean hasNext() {
        return this.level != null;
    }

    @Override
    public Tile next() throws NoSuchElementException {
        Tile tile = this.tile;
        if (tile == null) {
            throw new NoSuchElementException();
        }
        this.advance();
        return tile;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

