/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import org.geotoolkit.image.io.mosaic.Tile;
import org.geotoolkit.image.io.mosaic.TreeNode;

final class GridNode
extends TreeNode
implements Comparable<GridNode> {
    private static final int GROUP_SIZE = 3;
    private final int index;
    private short xSubsampling;
    private short ySubsampling;
    private static final Comparator<GridNode> PRE_PROCESSING = new Comparator<GridNode>(){

        @Override
        public int compare(GridNode gridNode, GridNode gridNode2) {
            int n;
            int n2 = (gridNode.xSubsampling & 0xFFFF) * (gridNode.ySubsampling & 0xFFFF);
            if (n2 > (n = (gridNode2.xSubsampling & 0xFFFF) * (gridNode2.ySubsampling & 0xFFFF))) {
                return -1;
            }
            if (n2 < n) {
                return 1;
            }
            long l = (long)gridNode.width * (long)gridNode.height;
            long l2 = (long)gridNode2.width * (long)gridNode2.height;
            if (l > l2) {
                return -1;
            }
            if (l < l2) {
                return 1;
            }
            return gridNode.index - gridNode2.index;
        }
    };

    @Override
    public int compareTo(GridNode gridNode) {
        return this.index - gridNode.index;
    }

    private GridNode(Rectangle rectangle) {
        super(rectangle);
        this.index = -1;
    }

    private GridNode(Tile tile, int n) throws IOException {
        super(tile.getAbsoluteRegion());
        this.tile = tile;
        Dimension dimension = tile.getSubsampling();
        Tile.checkSubsampling(dimension);
        this.xSubsampling = Tile.toShort(dimension.width);
        this.ySubsampling = Tile.toShort(dimension.height);
        this.index = n;
    }

    public GridNode(Tile[] tileArray) throws IOException {
        int n;
        int n2;
        GridNode[] gridNodeArray = new GridNode[tileArray.length];
        for (n2 = 0; n2 < tileArray.length; ++n2) {
            gridNodeArray[n2] = new GridNode(tileArray[n2], n2);
        }
        Arrays.sort(gridNodeArray, PRE_PROCESSING);
        n2 = GridNode.isFlat(gridNodeArray) ? 1 : 0;
        if (n2 != 0) {
            gridNodeArray = GridNode.prependTree(gridNodeArray);
        }
        GridNode gridNode = null;
        if (gridNodeArray.length != 0) {
            gridNode = gridNodeArray[0];
            for (n = 1; n < gridNodeArray.length; ++n) {
                if (gridNode.contains(gridNodeArray[n])) continue;
                gridNode = null;
                break;
            }
        }
        if (gridNode != null) {
            this.setBounds(gridNode);
            this.tile = gridNode.tile;
            this.index = gridNode.index;
            this.xSubsampling = gridNode.xSubsampling;
            this.ySubsampling = gridNode.ySubsampling;
        } else {
            this.index = -1;
        }
        int n3 = n = gridNode != null ? 1 : 0;
        while (n < gridNodeArray.length) {
            GridNode gridNode2 = gridNodeArray[n];
            GridNode gridNode3 = this.smallest(gridNode2);
            gridNode3.addChild(gridNode2);
            ++n;
        }
        if (gridNode == null) {
            assert ((this.width | this.height) < 0) : this;
            for (TreeNode treeNode = this.firstChildren(); treeNode != null; treeNode = treeNode.nextSibling()) {
                this.add(treeNode);
            }
        }
        if (n2 == 0) {
            this.splitOverlappingChildren();
        }
        this.postTreeCreation();
        assert (this.checkValidity()) : this.toTree();
    }

    private GridNode smallest(Rectangle rectangle) {
        boolean bl;
        long l;
        if (this.isEmpty()) {
            l = Long.MAX_VALUE;
            bl = false;
        } else {
            assert (this.contains(rectangle));
            l = (long)this.width * (long)this.height;
            bl = this.isGridded(rectangle);
        }
        GridNode gridNode = this;
        for (GridNode gridNode2 = (GridNode)this.firstChildren(); gridNode2 != null; gridNode2 = (GridNode)gridNode2.nextSibling()) {
            if (!gridNode2.contains(rectangle)) continue;
            GridNode gridNode3 = gridNode2.smallest(rectangle);
            boolean bl2 = gridNode3.isGridded(rectangle);
            if (bl && !bl2) continue;
            long l2 = (long)gridNode3.width * (long)gridNode3.height;
            if ((bl || !bl2) && l2 >= l) continue;
            l = l2;
            gridNode = gridNode3;
            bl = bl2;
        }
        return gridNode;
    }

    private boolean isGridded(Rectangle rectangle) {
        return this.width % rectangle.width == 0 && (rectangle.x - this.x) % rectangle.width == 0 && this.height % rectangle.height == 0 && (rectangle.y - this.y) % rectangle.height == 0;
    }

    private void splitOverlappingChildren() {
        GridNode gridNode;
        assert (this.isLeaf() || !this.isEmpty()) : this;
        for (gridNode = (GridNode)this.firstChildren(); gridNode != null; gridNode = (GridNode)gridNode.nextSibling()) {
            gridNode.splitOverlappingChildren();
        }
        if (this.isFlat() || !this.hasOverlaps()) {
            return;
        }
        LinkedList<GridNode> linkedList = new LinkedList<GridNode>();
        ArrayList<GridNode> arrayList = new ArrayList<GridNode>();
        for (gridNode = (GridNode)this.firstChildren(); gridNode != null; gridNode = (GridNode)gridNode.nextSibling()) {
            linkedList.add(gridNode);
        }
        this.removeChildren();
        while (!linkedList.isEmpty()) {
            Iterator iterator = linkedList.iterator();
            gridNode = (GridNode)iterator.next();
            arrayList.add(gridNode);
            iterator.remove();
            short s = gridNode.xSubsampling;
            short s2 = gridNode.ySubsampling;
            while (iterator.hasNext()) {
                gridNode = (GridNode)iterator.next();
                if (gridNode.xSubsampling != s || gridNode.ySubsampling != s2) continue;
                arrayList.add(gridNode);
                iterator.remove();
            }
            gridNode = new GridNode(this);
            assert (gridNode.isLeaf());
            for (GridNode gridNode2 : arrayList) {
                gridNode.addChild(gridNode2);
            }
            arrayList.clear();
            this.addChild(gridNode);
        }
    }

    private void postTreeCreation() {
        for (GridNode gridNode = (GridNode)this.firstChildren(); gridNode != null; gridNode = (GridNode)gridNode.nextSibling()) {
            gridNode.postTreeCreation();
            if ((gridNode.xSubsampling & 0xFFFF) > (this.xSubsampling & 0xFFFF)) {
                this.xSubsampling = gridNode.xSubsampling;
            }
            if ((gridNode.ySubsampling & 0xFFFF) <= (this.ySubsampling & 0xFFFF)) continue;
            this.ySubsampling = gridNode.ySubsampling;
        }
    }

    public boolean intersects(Rectangle rectangle, Dimension dimension) {
        if (this.intersects(rectangle)) {
            if (this.tile != null) {
                int n;
                int n2;
                if (this.isLeaf()) {
                    n2 = this.xSubsampling & 0xFFFF;
                    n = this.ySubsampling & 0xFFFF;
                } else {
                    Dimension dimension2 = this.tile.getSubsampling();
                    n2 = dimension2.width;
                    n = dimension2.height;
                }
                if (n2 <= dimension.width && n <= dimension.height) {
                    return true;
                }
            }
            for (GridNode gridNode = (GridNode)this.firstChildren(); gridNode != null; gridNode = (GridNode)gridNode.nextSibling()) {
                if (!gridNode.intersects(rectangle, dimension)) continue;
                return true;
            }
        }
        return false;
    }

    public int getXSubsampling() {
        return this.xSubsampling & 0xFFFF;
    }

    public int getYSubsampling() {
        return this.ySubsampling & 0xFFFF;
    }

    private boolean isFlat() {
        GridNode gridNode = (GridNode)this.firstChildren();
        if (gridNode != null) {
            short s = gridNode.xSubsampling;
            short s2 = gridNode.ySubsampling;
            while ((gridNode = (GridNode)gridNode.nextSibling()) != null) {
                if (gridNode.xSubsampling == s && gridNode.ySubsampling == s2) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isFlat(GridNode[] gridNodeArray) {
        if (gridNodeArray != null && gridNodeArray.length != 0) {
            GridNode gridNode = gridNodeArray[0];
            short s = gridNode.xSubsampling;
            short s2 = gridNode.ySubsampling;
            for (int i = 1; i < gridNodeArray.length; ++i) {
                gridNode = gridNodeArray[i];
                if (gridNode.xSubsampling == s && gridNode.ySubsampling == s2) continue;
                return false;
            }
        }
        return true;
    }

    private static GridNode[] prependTree(GridNode[] gridNodeArray) {
        int n;
        int n2;
        int n3;
        Rectangle rectangle = new Rectangle(-1, -1);
        int n4 = 0;
        int n5 = 0;
        for (GridNode gridNode : gridNodeArray) {
            rectangle.add(gridNode);
            if (gridNode.width > n4) {
                n4 = gridNode.width;
            }
            if (gridNode.height <= n5) continue;
            n5 = gridNode.height;
        }
        if (rectangle.isEmpty()) {
            return gridNodeArray;
        }
        int n6 = 0;
        int n7 = 0;
        for (GridNode object2 : gridNodeArray) {
            int n8;
            if (object2.x == rectangle.x && (n8 = n4 - object2.width) > n6) {
                n6 = n8;
            }
            if (object2.y != rectangle.y || (n8 = n5 - object2.height) <= n7) continue;
            n7 = n8;
        }
        while (true) {
            for (GridNode gridNode : gridNodeArray) {
                if (gridNode.width <= n4 - (gridNode.x - rectangle.x) % n4) continue;
                if (--n6 < 0) {
                    return gridNodeArray;
                }
                --rectangle.x;
            }
            break;
        }
        while (true) {
            for (GridNode gridNode : gridNodeArray) {
                if (gridNode.height <= n5 - (gridNode.y - rectangle.y) % n5) continue;
                if (--n7 < 0) {
                    return gridNodeArray;
                }
                --rectangle.y;
            }
            break;
        }
        int n9 = (rectangle.width + ((n4 *= 3) - 1)) / n4;
        int n10 = (rectangle.height + ((n5 *= 3) - 1)) / n5;
        boolean[] blArray = new boolean[n9 * n10];
        for (GridNode gridNode : gridNodeArray) {
            n3 = (gridNode.x - rectangle.x) / n4;
            n2 = (gridNode.y - rectangle.y) / n5;
            blArray[n2 * n9 + n3] = true;
        }
        Rectangle rectangle2 = new Rectangle();
        ArrayList<GridNode> arrayList = new ArrayList<GridNode>();
        while (blArray.length > 1) {
            rectangle2.width = n4;
            rectangle2.height = n5;
            n = blArray.length;
            while (--n >= 0) {
                if (!blArray[n]) continue;
                rectangle2.x = rectangle.x + n4 * (n % n9);
                rectangle2.y = rectangle.y + n5 * (n / n9);
                arrayList.add(new GridNode(rectangle2.intersection(rectangle)));
            }
            n4 *= 3;
            n5 *= 3;
            boolean[] blArray2 = blArray;
            int n11 = n9;
            n9 = (n9 + 2) / 3;
            n10 = (n10 + 2) / 3;
            blArray = new boolean[n9 * n10];
            for (n3 = 0; n3 < blArray2.length; ++n3) {
                if (!blArray2[n3]) continue;
                n2 = n3 / n11 / 3;
                int n12 = n3 % n11 / 3;
                blArray[n2 * n9 + n12] = true;
            }
        }
        n = arrayList.size();
        if (n != 0) {
            Collections.reverse(arrayList);
            GridNode[] gridNodeArray2 = gridNodeArray;
            gridNodeArray = arrayList.toArray(new GridNode[n + gridNodeArray2.length]);
            System.arraycopy(gridNodeArray2, 0, gridNodeArray, n, gridNodeArray2.length);
        }
        return gridNodeArray;
    }
}

